/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.util.Hashtable;
import java.util.Map;

class ClassRegistry {
    private Map registry = null;

    protected Map registry() {
        return this.registry;
    }

    protected void registry(Map newValue) {
        this.registry = newValue;
    }

    protected ClassRegistry() {
        this.registry(new Hashtable());
    }

    protected Object findForClassNamed(String className) {
        try {
            Class<?> aClass = Class.forName(className);
            return this.findForClass(aClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected Object findForClass(Class aClass) {
        Object result = null;
        Class<?>[] interfaces = null;
        if (aClass != null && (result = this.getRegistered(aClass)) == null) {
            interfaces = aClass.getInterfaces();
            for (int index = 0; result == null && index < interfaces.length; ++index) {
                result = this.findForClass(interfaces[index]);
            }
            if (result == null && !aClass.isInterface()) {
                result = this.findForClass(aClass.getSuperclass());
            }
        }
        return result;
    }

    protected Object getRegistered(String className) {
        return this.registry().get(className);
    }

    protected Object getRegistered(Class aClass) {
        return this.getRegistered(aClass.getName());
    }

    protected void register(String className, Object obj) {
        this.registry().put(className, obj);
    }

    protected void register(Class aClass, Object obj) {
        this.register(aClass.getName(), obj);
    }
}

