/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.net.URL;
import javax.swing.ImageIcon;
import org.pf.joi.InspectionRenderer;

public class ImageProvider {
    private static final String PACKAGE_NAME = InspectionRenderer.class.getPackage().getName().replace('.', '/');
    private static final String ICONS_DIR = "icons/";
    private static final String ROOT_ICON_FILE = "root_co.gif";
    private static final String PACKAGE_ICON_FILE = "default_co.gif";
    private static final String PUBLIC_ICON_FILE = "public_co.gif";
    private static final String PROTECTED_ICON_FILE = "protected_co.gif";
    private static final String PRIVATE_ICON_FILE = "private_co.gif";
    private static final String DRILLABLE_PACKAGE_ICON_FILE = "default_co_drillable.gif";
    private static final String DRILLABLE_PUBLIC_ICON_FILE = "public_co_drillable.gif";
    private static final String DRILLABLE_PROTECTED_ICON_FILE = "protected_co_drillable.gif";
    private static final String DRILLABLE_PRIVATE_ICON_FILE = "private_co_drillable.gif";
    private static ImageProvider soleInstance = new ImageProvider();
    private ImageIcon rootIcon = null;
    private ImageIcon packageIcon = null;
    private ImageIcon publicIcon = null;
    private ImageIcon protectedIcon = null;
    private ImageIcon privateIcon = null;
    private ImageIcon drillablePackageIcon = null;
    private ImageIcon drilldownPublicIcon = null;
    private ImageIcon drillableProtectedIcon = null;
    private ImageIcon drillablePrivateIcon = null;

    public ImageIcon getRootIcon() {
        return this.rootIcon;
    }

    protected void setRootIcon(ImageIcon newValue) {
        this.rootIcon = newValue;
    }

    public ImageIcon getPackageIcon() {
        return this.packageIcon;
    }

    protected void setPackageIcon(ImageIcon newValue) {
        this.packageIcon = newValue;
    }

    public ImageIcon getPublicIcon() {
        return this.publicIcon;
    }

    protected void setPublicIcon(ImageIcon newValue) {
        this.publicIcon = newValue;
    }

    public ImageIcon getProtectedIcon() {
        return this.protectedIcon;
    }

    protected void setProtectedIcon(ImageIcon newValue) {
        this.protectedIcon = newValue;
    }

    public ImageIcon getPrivateIcon() {
        return this.privateIcon;
    }

    protected void setPrivateIcon(ImageIcon newValue) {
        this.privateIcon = newValue;
    }

    public ImageIcon getDrillablePackageIcon() {
        return this.drillablePackageIcon;
    }

    protected void setDrillablePackageIcon(ImageIcon newValue) {
        this.drillablePackageIcon = newValue;
    }

    public ImageIcon getDrillablePublicIcon() {
        return this.drilldownPublicIcon;
    }

    protected void setDrillablePublicIcon(ImageIcon newValue) {
        this.drilldownPublicIcon = newValue;
    }

    public ImageIcon getDrillableProtectedIcon() {
        return this.drillableProtectedIcon;
    }

    protected void setDrillableProtectedIcon(ImageIcon newValue) {
        this.drillableProtectedIcon = newValue;
    }

    public ImageIcon getDrillablePrivateIcon() {
        return this.drillablePrivateIcon;
    }

    protected void setDrillablePrivateIcon(ImageIcon newValue) {
        this.drillablePrivateIcon = newValue;
    }

    public static ImageProvider instance() {
        return soleInstance;
    }

    private ImageProvider() {
        this.initialize();
    }

    protected void initialize() {
        this.setRootIcon(this.createIcon(ROOT_ICON_FILE));
        this.setPackageIcon(this.createIcon(PACKAGE_ICON_FILE));
        this.setPublicIcon(this.createIcon(PUBLIC_ICON_FILE));
        this.setProtectedIcon(this.createIcon(PROTECTED_ICON_FILE));
        this.setPrivateIcon(this.createIcon(PRIVATE_ICON_FILE));
        this.setDrillablePackageIcon(this.createIcon(DRILLABLE_PACKAGE_ICON_FILE));
        this.setDrillablePublicIcon(this.createIcon(DRILLABLE_PUBLIC_ICON_FILE));
        this.setDrillableProtectedIcon(this.createIcon(DRILLABLE_PROTECTED_ICON_FILE));
        this.setDrillablePrivateIcon(this.createIcon(DRILLABLE_PRIVATE_ICON_FILE));
    }

    protected ImageIcon createIcon(String filename) {
        String filePath = PACKAGE_NAME + "/" + ICONS_DIR + filename;
        URL url = this.findFileOnClasspath(filePath);
        if (url == null) {
            System.err.println("file '" + filePath + "' not found");
            return null;
        }
        return new ImageIcon(url);
    }

    protected URL findFileOnClasspath(String filePath) {
        ClassLoader cl = null;
        URL url = null;
        try {
            cl = this.getClass().getClassLoader();
            if (cl == null) {
                return null;
            }
            url = cl.getResource(filePath);
            if (url == null) {
                System.out.println("ERROR: File '" + filePath + "' not found in CLASSPATH !!!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return url;
    }
}

