/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.List;
import org.pf.joi.AbstractObjectSpy;
import org.pf.joi.ArraySpy;
import org.pf.joi.BasicInspector;
import org.pf.joi.ClassAssociations;
import org.pf.joi.ExportProvider;
import org.pf.joi.InspectionWindowController;
import org.pf.joi.ObjectSpy;
import org.pf.plugin.ClassRegistry;
import org.pf.plugin.PluginCollector;
import org.pf.reflect.ClassInfo;
import org.pf.text.StringUtil;

public abstract class Inspector
extends MouseAdapter {
    protected static final String PROG_NAME = "Java Object Inspector";
    protected static final String ActionSeparator = "|";
    protected static final String ExportPrefix = "Export|";
    protected static final String ImportPrefix = "Import|";
    public static final String INSPECTOR_MAPPING_FILENAME = "META-INF/joi.inspector";
    public static final String EXPORTER_MAPPING_FILENAME = "META-INF/joi.exporter";
    private static List controllerRegistry = new ArrayList();
    private static ClassAssociations inspectorBinding = null;
    private static ClassAssociations exportProviderRegistry = null;
    private static boolean haltCurrentProccess = false;
    private AbstractObjectSpy inspectedObject = null;

    protected static List getControllerRegistry() {
        return controllerRegistry;
    }

    protected static void setControllerRegistry(List newValue) {
        controllerRegistry = newValue;
    }

    protected static ClassAssociations getInspectorBinding() {
        return inspectorBinding;
    }

    protected static void setInspectorBinding(ClassAssociations newValue) {
        inspectorBinding = newValue;
    }

    protected static ClassAssociations getExportProviderRegistry() {
        return exportProviderRegistry;
    }

    protected static void setExportProviderRegistry(ClassAssociations newValue) {
        exportProviderRegistry = newValue;
    }

    protected static boolean getHaltCurrentProccess() {
        return haltCurrentProccess;
    }

    protected static void setHaltCurrentProccess(boolean newValue) {
        haltCurrentProccess = newValue;
    }

    protected AbstractObjectSpy getInspectedObject() {
        return this.inspectedObject;
    }

    protected void setInspectedObject(AbstractObjectSpy newValue) {
        this.inspectedObject = newValue;
    }

    public static Inspector basicInspect(Object obj) {
        return Inspector.basicInspect(null, obj);
    }

    public static Inspector basicInspect(String name, Object obj) {
        return Inspector.launchInspectorOn(new BasicInspector(), name, obj);
    }

    public static Inspector inspect(Object obj) {
        return Inspector.inspect(null, obj, null, null);
    }

    public static Inspector inspect(Object obj, String[] elementNames, String frameTitle) {
        return Inspector.inspect(null, obj, elementNames, frameTitle);
    }

    public static Inspector inspect(String name, Object obj) {
        return Inspector.inspect(name, obj, null, null);
    }

    public static Inspector inspect(String name, Object obj, String[] elementNames, String frameTitle) {
        return Inspector.launchInspectorOn(Inspector.getInspectorFor(obj), name, obj, elementNames, null, frameTitle);
    }

    public static Inspector inspect(String name, Object obj, String[] elementNames, String[] elementTypes, String frameTitle) {
        return Inspector.launchInspectorOn(Inspector.getInspectorFor(obj), name, obj, elementNames, elementTypes, frameTitle);
    }

    public static void basicInspectWait(Object obj) {
        Inspector.basicInspectWait(null, obj);
    }

    public static void basicInspectWait(String name, Object obj) {
        Inspector.basicInspect(name, obj);
        Inspector.halt();
    }

    public static void inspectWait(Object obj) {
        Inspector.inspectWait(null, obj);
    }

    public static void inspectWait(String name, Object obj) {
        Inspector.inspect(name, obj);
        Inspector.halt();
    }

    public static void bindInspector(String className, String inspectorName) {
        Inspector.inspectorBinding();
        Inspector.basicBindInspector(className, inspectorName);
    }

    public static AbstractObjectSpy getBasicObjectSpy(Object obj) {
        return Inspector.getBasicObjectSpy(null, obj);
    }

    public static AbstractObjectSpy getBasicObjectSpy(String name, Object obj) {
        BasicInspector inspector = null;
        inspector = new BasicInspector();
        return inspector.objectSpyFor(name, obj);
    }

    public static AbstractObjectSpy getObjectSpy(Object obj) {
        return Inspector.getObjectSpy(null, obj);
    }

    public static AbstractObjectSpy getObjectSpy(String name, Object obj) {
        BasicInspector inspector = null;
        inspector = Inspector.getInspectorFor(obj);
        return inspector.objectSpyFor(name, obj);
    }

    public static void deactivateHalt() {
        Inspector.setHaltCurrentProccess(false);
    }

    public static void halt() {
        Inspector.setHaltCurrentProccess(true);
        Inspector.waitWhileHaltActive();
    }

    protected static BasicInspector inspectIn(InspectionWindowController controller, int where, String name, Object obj) {
        BasicInspector inspector = Inspector.getInspectorFor(obj);
        Inspector.openInspectorIn(controller, where, inspector, name, obj);
        return inspector;
    }

    protected static BasicInspector basicInspectIn(InspectionWindowController controller, int where, String name, Object obj) {
        BasicInspector inspector = new BasicInspector();
        Inspector.openInspectorIn(controller, where, inspector, name, obj);
        return inspector;
    }

    protected static BasicInspector openInspectorIn(InspectionWindowController controller, int where, BasicInspector inspector, String name, Object obj) {
        inspector.inspectObject(name, obj);
        controller.openNewInspector(inspector, where);
        return inspector;
    }

    protected static Inspector launchInspectorOn(BasicInspector inspector, String name, Object obj) {
        return Inspector.launchInspectorOn(inspector, name, obj, null, null, null);
    }

    protected static Inspector launchInspectorOn(BasicInspector inspector, String name, Object obj, String[] elementNames, String[] elementTypes, String frameTitle) {
        inspector.inspectObject(name, obj, elementNames, elementTypes, true);
        InspectionWindowController controller = new InspectionWindowController(frameTitle);
        Inspector.registerController(controller);
        controller.start(inspector);
        return inspector;
    }

    protected static BasicInspector getInspectorFor(Object obj) {
        BasicInspector inspector = null;
        ClassInfo inspectorClassInfo = null;
        if (obj != null && (inspectorClassInfo = Inspector.findInspectorClassInfoFor(obj.getClass())) != null) {
            inspector = (BasicInspector)inspectorClassInfo.createInstance();
        }
        if (inspector == null) {
            inspector = new BasicInspector();
        }
        return inspector;
    }

    protected static ClassInfo findInspectorClassInfoFor(Class aClass) {
        return Inspector.inspectorBinding().findForClass(aClass);
    }

    protected static ClassAssociations inspectorBinding() {
        if (Inspector.getInspectorBinding() == null) {
            Inspector.initializeInspectorBinding();
        }
        return Inspector.getInspectorBinding();
    }

    protected static void initializeInspectorBinding() {
        Inspector.setInspectorBinding(new ClassAssociations(BasicInspector.class));
        PluginCollector collector = new PluginCollector((ClassRegistry)Inspector.getInspectorBinding());
        collector.loadPlugins(INSPECTOR_MAPPING_FILENAME);
    }

    protected static void basicBindInspector(String className, String inspectorName) {
        Inspector.getInspectorBinding().register(className, inspectorName);
    }

    protected static void registerController(InspectionWindowController controller) {
        Inspector.getControllerRegistry().add(controller);
    }

    protected static void unregisterController(InspectionWindowController controller) {
        Inspector.getControllerRegistry().remove(controller);
    }

    protected static boolean anyInspectorActive() {
        return Inspector.getControllerRegistry().size() > 0;
    }

    protected static boolean isHaltActive() {
        return Inspector.getHaltCurrentProccess() && Inspector.anyInspectorActive();
    }

    protected static void waitWhileHaltActive() {
        while (Inspector.isHaltActive()) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
    }

    protected static ClassAssociations exportProviderRegistry() {
        if (Inspector.getExportProviderRegistry() == null) {
            Inspector.initializeExportProviderRegistry();
        }
        return Inspector.getExportProviderRegistry();
    }

    protected static void initializeExportProviderRegistry() {
        Inspector.setExportProviderRegistry(new ClassAssociations(ExportProvider.class));
        PluginCollector collector = new PluginCollector((ClassRegistry)Inspector.getExportProviderRegistry());
        collector.loadPlugins(EXPORTER_MAPPING_FILENAME);
    }

    protected static ExportProvider findExporterNamed(String exporterId) {
        ExportProvider exportProvider = null;
        String key = exporterId;
        if (key.startsWith(ExportPrefix)) {
            key = StringUtil.current().suffix(key, ExportPrefix);
        }
        exportProvider = (ExportProvider)Inspector.exportProviderRegistry().newInstance(key);
        return exportProvider;
    }

    protected Inspector() {
    }

    protected void inspectObject(String name, Object obj, String[] elementNames, String[] elementTypes, boolean isRootNode) {
        AbstractObjectSpy ospy = null;
        ospy = this.objectSpyFor(name, obj, elementNames, elementTypes, isRootNode);
        this.setInspectedObject(ospy);
    }

    protected AbstractObjectSpy objectSpyFor(Object obj, String[] elementNames, String[] elementTypes, boolean isRoot) {
        AbstractObjectSpy ospy = null;
        ospy = obj != null && obj.getClass().isArray() ? new ArraySpy(obj, elementNames, elementTypes, isRoot) : new ObjectSpy(obj, isRoot);
        return ospy;
    }

    protected AbstractObjectSpy objectSpyFor(String name, Object obj) {
        return this.objectSpyFor(name, obj, null, null, false);
    }

    protected AbstractObjectSpy objectSpyFor(String name, Object obj, String[] elementNames, String[] elementTypes, boolean isRoot) {
        AbstractObjectSpy ospy = null;
        ospy = this.objectSpyFor(obj, elementNames, elementTypes, isRoot);
        if (name != null) {
            ospy.setName(name);
        }
        return ospy;
    }
}

