/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.Component;
import org.pf.joi.ClassAssociations;
import org.pf.joi.Inspectable;
import org.pf.joi.ObjectRenderer;
import org.pf.joi.ObjectRenderer2;
import org.pf.plugin.ClassRegistry;
import org.pf.plugin.PluginCollector;
import org.pf.reflect.ClassInfo;
import org.pf.reflect.Dynamic;

public abstract class Spy {
    public static final String RENDERER_MAPPING_FILENAME = "META-INF/joi.renderer";
    protected static final String PRIMITIVE_INT = "int";
    protected static final String PRIMITIVE_LONG = "long";
    protected static final String PRIMITIVE_BOOLEAN = "boolean";
    protected static final String PRIMITIVE_DOUBLE = "double";
    protected static final String PRIMITIVE_FLOAT = "float";
    protected static final String PRIMITIVE_SHORT = "short";
    protected static final String PRIMITIVE_BYTE = "byte";
    protected static final String PRIMITIVE_CHAR = "char";
    private static ClassAssociations rendererRegistry = null;

    protected static ClassAssociations getRendererRegistry() {
        return rendererRegistry;
    }

    protected static void setRendererRegistry(ClassAssociations newValue) {
        rendererRegistry = newValue;
    }

    private static void initializeRendererRegistry() {
        Spy.setRendererRegistry(new ClassAssociations(ObjectRenderer.class));
        PluginCollector collector = new PluginCollector((ClassRegistry)Spy.getRendererRegistry());
        collector.loadPlugins(RENDERER_MAPPING_FILENAME);
    }

    private static ClassAssociations rendererRegistry() {
        if (Spy.getRendererRegistry() == null) {
            Spy.initializeRendererRegistry();
        }
        return Spy.getRendererRegistry();
    }

    public abstract String getName();

    public abstract Class getType();

    public abstract Object getValue() throws Exception;

    public abstract int getModifiers();

    public String getValueString() throws Exception {
        Object value = null;
        value = this.getValue();
        return this.objectAsString(value);
    }

    public Component getValueComponent() throws Exception {
        Object value = this.getValue();
        return this.objectAsComponent(value);
    }

    public String getTypeString() {
        return this.getTypeStringOf(this.getType());
    }

    public String getValueTypeString() throws Exception {
        Object value = null;
        String typeString = null;
        value = this.getValue();
        typeString = value == null ? "---" : (this.getType().isPrimitive() ? this.getType().getName() : this.getTypeStringOf(value.getClass()));
        return typeString;
    }

    public boolean valueIsNull() throws Exception {
        return this.getValue() == null;
    }

    public boolean isElementSpy() {
        return false;
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isEditable() {
        return false;
    }

    public void setValue(Object newValue) throws Exception {
    }

    public boolean is_int() {
        return PRIMITIVE_INT.equals(this.getType().getName());
    }

    public boolean is_long() {
        return PRIMITIVE_LONG.equals(this.getType().getName());
    }

    public boolean is_short() {
        return PRIMITIVE_SHORT.equals(this.getType().getName());
    }

    public boolean is_byte() {
        return PRIMITIVE_BYTE.equals(this.getType().getName());
    }

    public boolean is_char() {
        return PRIMITIVE_CHAR.equals(this.getType().getName());
    }

    public boolean is_boolean() {
        return PRIMITIVE_BOOLEAN.equals(this.getType().getName());
    }

    public boolean is_double() {
        return PRIMITIVE_DOUBLE.equals(this.getType().getName());
    }

    public boolean is_float() {
        return PRIMITIVE_FLOAT.equals(this.getType().getName());
    }

    protected String getTypeStringOf(Class type) {
        String typeString = null;
        if (type == null) {
            typeString = "---";
        } else if (type.isArray()) {
            type = type.getComponentType();
            typeString = type.getName() + "[]";
        } else {
            typeString = type.getName();
        }
        return typeString;
    }

    protected ObjectRenderer rendererFor(Class aClass) {
        ClassInfo classInfo = Spy.rendererRegistry().findForClass(aClass);
        if (classInfo == null) {
            return null;
        }
        return (ObjectRenderer)classInfo.createInstance();
    }

    protected String objectAsString(Object object) {
        String result = null;
        ObjectRenderer renderer = null;
        if (object == null) {
            result = "null";
        } else if (object instanceof Inspectable) {
            result = ((Inspectable)object).inspectString();
        } else {
            renderer = this.rendererFor(object.getClass());
            if (renderer != null) {
                result = renderer.inspectString(object);
            } else {
                result = this.invokeInspectString(object);
                if (result == null) {
                    result = object.toString();
                }
            }
        }
        return result;
    }

    protected Component objectAsComponent(Object object) {
        Component result = null;
        if (object == null) {
            return null;
        }
        ObjectRenderer renderer = this.rendererFor(object.getClass());
        if (renderer instanceof ObjectRenderer2) {
            ObjectRenderer2 renderer2 = (ObjectRenderer2)renderer;
            result = renderer2.inspectComponent(object);
        }
        return result;
    }

    protected String invokeInspectString(Object object) {
        Object result = null;
        try {
            result = Dynamic.perform((Object)object, (String)"inspectString");
            if (!(result instanceof String)) {
                result = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)result;
    }
}

