/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.sonatype.guice.bean.binders.BeanListProvider;
import org.sonatype.guice.bean.binders.BeanMapProvider;
import org.sonatype.guice.bean.binders.BeanProvider;
import org.sonatype.guice.bean.binders.NamedBeanMapProvider;
import org.sonatype.guice.bean.binders.PlaceholderBeanProvider;
import org.sonatype.guice.bean.binders.Wiring;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.guice.bean.locators.HiddenBinding;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.reflect.TypeParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocatorWiring
implements Wiring {
    private static final Set<Class<?>> RESTRICTED_CLASSES = new HashSet<Class>(Arrays.asList(BeanLocator.class, MutableBeanLocator.class, AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, Module.class, Provider.class, Scope.class, TypeLiteral.class));
    private static final HiddenBinding HIDDEN_SOURCE = new HiddenBinding(){

        public String toString() {
            return LocatorWiring.class.getName();
        }
    };
    private final Binder binder;

    LocatorWiring(Binder binder) {
        this.binder = binder.withSource((Object)HIDDEN_SOURCE);
    }

    @Override
    public boolean wire(Key<?> key) {
        Class clazz = key.getTypeLiteral().getRawType();
        if (Map.class == clazz) {
            this.bindMapImport(key);
        } else if (List.class == clazz || Iterable.class == clazz) {
            this.bindListImport(key);
        } else if (!LocatorWiring.isRestricted(clazz)) {
            this.bindBeanImport(key);
        }
        return true;
    }

    private void bindMapImport(Key<?> key) {
        TypeLiteral<?>[] parameters = TypeParameters.get(key.getTypeLiteral());
        if (2 == parameters.length && null == key.getAnnotation()) {
            Class qualifierType = parameters[0].getRawType();
            if (String.class == qualifierType) {
                this.binder.bind(key).toProvider(new NamedBeanMapProvider(parameters[1]));
            } else if (qualifierType.isAnnotationPresent(Qualifier.class)) {
                this.binder.bind(key).toProvider(new BeanMapProvider(Key.get(parameters[1], (Class)qualifierType)));
            }
        }
    }

    private void bindListImport(Key<?> key) {
        TypeLiteral<?>[] parameters = TypeParameters.get(key.getTypeLiteral());
        if (1 == parameters.length && null == key.getAnnotation()) {
            this.binder.bind(key).toProvider(new BeanListProvider(Key.get(parameters[0])));
        }
    }

    private <T> void bindBeanImport(Key<T> key) {
        String name;
        Annotation qualifier = key.getAnnotation();
        String string = name = qualifier instanceof Named ? ((Named)qualifier).value() : "CUSTOM";
        if (name.contains("${")) {
            this.binder.bind(key).toProvider(new PlaceholderBeanProvider<T>(key));
        } else if (name.length() == 0) {
            this.binder.bind(key).toProvider(new BeanProvider(Key.get((TypeLiteral)key.getTypeLiteral(), Named.class)));
        } else if (!LocatorWiring.isImplicit(key)) {
            this.binder.bind(key).toProvider(new BeanProvider<T>(key));
        }
    }

    private static boolean isRestricted(Class<?> clazz) {
        return RESTRICTED_CLASSES.contains(clazz);
    }

    private static boolean isImplicit(Key<?> key) {
        if (null == key.getAnnotationType()) {
            Class clazz = key.getTypeLiteral().getRawType();
            if ((clazz.getModifiers() & 0x600) == 0) {
                return true;
            }
            if (clazz.getName().equals("org.slf4j.Logger")) {
                return true;
            }
        }
        return false;
    }
}

