/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Constructor;
import javax.enterprise.inject.Typed;
import javax.inject.Provider;
import org.sonatype.guice.bean.binders.BeanListener;
import org.sonatype.guice.bean.locators.WildcardKey;
import org.sonatype.guice.bean.reflect.TypeParameters;
import org.sonatype.guice.bean.scanners.QualifiedTypeListener;
import org.sonatype.inject.EagerSingleton;
import org.sonatype.inject.Mediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QualifiedTypeBinder
implements QualifiedTypeListener {
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private final Binder rootBinder;
    private BeanListener beanListener;
    private Object currentSource;
    private Binder binder;

    public QualifiedTypeBinder(Binder binder) {
        this.rootBinder = binder;
        this.binder = binder;
    }

    public void hear(Annotation qualifier, Class qualifiedType, Object source) {
        if (this.currentSource != source) {
            if (null != source) {
                this.binder = this.rootBinder.withSource(source);
                this.currentSource = source;
            } else {
                this.binder = this.rootBinder;
                this.currentSource = null;
            }
        }
        if ((qualifiedType.getModifiers() & 0x600) != 0) {
            return;
        }
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if (Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else if (Provider.class.isAssignableFrom(qualifiedType)) {
            this.bindProviderType(qualifiedType);
        } else {
            this.bindQualifiedType(qualifiedType);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module = this.newInstance(moduleType);
        if (null != module) {
            this.binder.install(module);
        }
    }

    private void registerMediator(Class<Mediator> mediatorType) {
        TypeLiteral<?>[] params = QualifiedTypeBinder.getSuperTypeParameters(mediatorType, Mediator.class);
        if (params.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = this.newInstance(mediatorType);
            if (null != mediator) {
                this.mediate(Key.get(params[1], (Class)params[0].getRawType()), mediator, params[2].getRawType());
            }
        }
    }

    private void mediate(Key key, Mediator mediator, Class watcherType) {
        if (null == this.beanListener) {
            this.beanListener = new BeanListener();
            this.binder.bindListener(Matchers.any(), (TypeListener)this.beanListener);
            this.binder.requestInjection((Object)this.beanListener);
        }
        this.beanListener.mediate(key, mediator, watcherType);
    }

    private void bindProviderType(Class<?> providerType) {
        TypeLiteral<?>[] params = QualifiedTypeBinder.getSuperTypeParameters(providerType, Provider.class);
        if (params.length != 1) {
            this.binder.addError(providerType + " has wrong number of type arguments", new Object[0]);
        } else {
            Key<?> key = QualifiedTypeBinder.getBindingKey(params[0], (Annotation)QualifiedTypeBinder.getBindingName(providerType));
            ScopedBindingBuilder sbb = this.binder.bind(key).toProvider(providerType);
            if (providerType.isAnnotationPresent(EagerSingleton.class)) {
                sbb.asEagerSingleton();
            } else if (providerType.isAnnotationPresent(javax.inject.Singleton.class) || providerType.isAnnotationPresent(Singleton.class)) {
                sbb.in(Scopes.SINGLETON);
            }
            Typed typed = providerType.getAnnotation(Typed.class);
            if (null != typed) {
                for (Class<?> bindingType : typed.value()) {
                    this.binder.bind(key.ofType(bindingType)).to(key);
                }
            }
        }
    }

    private void bindQualifiedType(Class<?> qualifiedType) {
        AnnotatedBindingBuilder sbb = this.binder.bind(qualifiedType);
        if (qualifiedType.isAnnotationPresent(EagerSingleton.class)) {
            sbb.asEagerSingleton();
        }
        Named bindingName = QualifiedTypeBinder.getBindingName(qualifiedType);
        Typed typed = qualifiedType.getAnnotation(Typed.class);
        if (null != typed || Object.class == qualifiedType.getSuperclass()) {
            Class<?>[] interfaces = qualifiedType.getInterfaces();
            if (null != typed && typed.value().length > 0) {
                interfaces = typed.value();
            }
            Key<?> key = QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, (Annotation)bindingName);
            for (Class<?> bindingType : interfaces) {
                this.binder.bind(key.ofType(bindingType)).to(qualifiedType);
            }
        } else {
            this.binder.bind((Key)new WildcardKey(qualifiedType, (Annotation)bindingName)).to(qualifiedType);
        }
    }

    private <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            this.binder.addError("Error creating instance of: " + type + " reason: " + e, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] getSuperTypeParameters(Class<?> type, Class<?> superType) {
        return TypeParameters.get(TypeLiteral.get(type).getSupertype(superType));
    }

    private static <T> Key<T> getBindingKey(TypeLiteral<T> bindingType, Annotation qualifier) {
        return null != qualifier ? Key.get(bindingType, (Annotation)qualifier) : Key.get(bindingType);
    }

    private static Named getBindingName(Class<?> qualifiedType) {
        javax.inject.Named jsr330 = qualifiedType.getAnnotation(javax.inject.Named.class);
        if (null != jsr330) {
            try {
                String name = jsr330.value();
                if (name.length() > 0) {
                    return "default".equals(name) ? null : Names.named((String)name);
                }
            }
            catch (IncompleteAnnotationException e) {}
        } else {
            String name;
            Named guice = qualifiedType.getAnnotation(Named.class);
            if (null != guice && (name = guice.value()).length() > 0) {
                return "default".equals(name) ? null : guice;
            }
        }
        if (qualifiedType.getSimpleName().startsWith("Default")) {
            return null;
        }
        return Names.named((String)qualifiedType.getName());
    }
}

