/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceVisitor;
import org.sonatype.guice.bean.scanners.EmptyClassVisitor;
import org.sonatype.guice.bean.scanners.QualifiedTypeListener;
import org.sonatype.guice.bean.scanners.QualifierCache;
import org.sonatype.guice.bean.scanners.asm.AnnotationVisitor;
import org.sonatype.guice.bean.scanners.asm.ClassVisitor;

public final class QualifiedTypeVisitor
extends EmptyClassVisitor
implements ClassSpaceVisitor {
    private final QualifierCache qualifierCache = new QualifierCache();
    private final List<Class<Annotation>> qualifiers = new ArrayList<Class<Annotation>>();
    private final QualifiedTypeListener listener;
    private ClassSpace space;
    private URL location;
    private String source;
    private String clazzName;

    public QualifiedTypeVisitor(QualifiedTypeListener listener) {
        this.listener = listener;
    }

    public void visit(ClassSpace _space) {
        this.space = _space;
        this.source = null;
    }

    public ClassVisitor visitClass(URL url) {
        this.qualifiers.clear();
        this.location = url;
        this.clazzName = null;
        return this;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x1600) == 0) {
            this.clazzName = name;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Class<Annotation> qualifier;
        if (null != this.clazzName && null != (qualifier = this.qualifierCache.qualify(this.space, desc))) {
            this.qualifiers.add(qualifier);
        }
        return null;
    }

    public void visitEnd() {
        int numQualifiers = this.qualifiers.size();
        if (numQualifiers > 0) {
            String path = this.location.getPath();
            if (null == this.source || !path.startsWith(this.source)) {
                int i = path.indexOf(this.clazzName);
                this.source = i <= 0 ? path : path.substring(0, i);
            }
            Class<?> clazz = this.space.loadClass(this.clazzName.replace('/', '.'));
            for (int i = 0; i < numQualifiers; ++i) {
                this.listener.hear(clazz.getAnnotation(this.qualifiers.get(i)), clazz, this.source);
            }
        }
    }
}

