/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.PCA;
import org.apache.spark.mllib.feature.PCAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PCAExample$ {
    public static final PCAExample$ MODULE$;

    static {
        new PCAExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("PCAExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/ridge-data/lpsa.data", sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String line) {
                String[] parts = new StringOps(Predef$.MODULE$.augmentString(line)).split(',');
                return new LabeledPoint(new StringOps(Predef$.MODULE$.augmentString(parts[0])).toDouble(), Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(parts[1])).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
        RDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0].cache();
        RDD test = splits[1];
        PCAModel pca = new PCA(((LabeledPoint)training.first()).features().size() / 2).fit(data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(LabeledPoint x$2) {
                return x$2.features();
            }
        }, ClassTag$.MODULE$.apply(Vector.class)));
        RDD training_pca = training.map((Function1)new Serializable(pca){
            public static final long serialVersionUID = 0L;
            private final PCAModel pca$1;

            public final LabeledPoint apply(LabeledPoint p) {
                Vector x$3 = this.pca$1.transform(p.features());
                double x$4 = p.copy$default$1();
                return p.copy(x$4, x$3);
            }
            {
                this.pca$1 = pca$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        RDD test_pca = test.map((Function1)new Serializable(pca){
            public static final long serialVersionUID = 0L;
            private final PCAModel pca$1;

            public final LabeledPoint apply(LabeledPoint p) {
                Vector x$5 = this.pca$1.transform(p.features());
                double x$6 = p.copy$default$1();
                return p.copy(x$6, x$5);
            }
            {
                this.pca$1 = pca$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numIterations = 100;
        LinearRegressionModel model = LinearRegressionWithSGD$.MODULE$.train(training, numIterations);
        LinearRegressionModel model_pca = LinearRegressionWithSGD$.MODULE$.train(training_pca, numIterations);
        RDD valuesAndPreds = test.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final LinearRegressionModel model$1;

            public final Tuple2<Object, Object> apply(LabeledPoint point) {
                double score = this.model$1.predict(point.features());
                return new Tuple2.mcDD.sp(score, point.label());
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD valuesAndPreds_pca = test_pca.map((Function1)new Serializable(model_pca){
            public static final long serialVersionUID = 0L;
            private final LinearRegressionModel model_pca$1;

            public final Tuple2<Object, Object> apply(LabeledPoint point) {
                double score = this.model_pca$1.predict(point.features());
                return new Tuple2.mcDD.sp(score, point.label());
            }
            {
                this.model_pca$1 = model_pca$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double MSE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(valuesAndPreds.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double v = tuple2._1$mcD$sp();
                    double p = tuple2._2$mcD$sp();
                    double d = package$.MODULE$.pow(v - p, 2.0);
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).mean();
        double MSE_pca = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(valuesAndPreds_pca.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    double v = tuple2._1$mcD$sp();
                    double p = tuple2._2$mcD$sp();
                    double d = package$.MODULE$.pow(v - p, 2.0);
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mean Squared Error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)MSE)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PCA Mean Squared Error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)MSE_pca)})));
        sc.stop();
    }

    private PCAExample$() {
        MODULE$ = this;
    }
}

