/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.DefaultDecorator;
import com.github.rjeschke.txtmark.SpanEmitter;
import java.util.ArrayList;
import java.util.List;
import org.markdown4j.Plugin;

public class Configuration {
    final boolean safeMode;
    final String encoding;
    final Decorator decorator;
    final BlockEmitter codeBlockEmitter;
    final boolean forceExtendedProfile;
    final boolean convertNewline2Br;
    final SpanEmitter specialLinkEmitter;
    final List<Plugin> plugins;
    public static final Configuration DEFAULT = Configuration.builder().build();
    public static final Configuration DEFAULT_SAFE = Configuration.builder().enableSafeMode().build();

    Configuration(boolean safeMode, String encoding, Decorator decorator, BlockEmitter codeBlockEmitter, boolean forceExtendedProfile, boolean convertNewline2Br, SpanEmitter specialLinkEmitter, List<Plugin> plugins) {
        this.safeMode = safeMode;
        this.encoding = encoding;
        this.decorator = decorator;
        this.codeBlockEmitter = codeBlockEmitter;
        this.convertNewline2Br = convertNewline2Br;
        this.forceExtendedProfile = forceExtendedProfile;
        this.specialLinkEmitter = specialLinkEmitter;
        this.plugins = plugins;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean safeMode = false;
        private boolean forceExtendedProfile = true;
        private boolean convertNewline2Br = false;
        private String encoding = "UTF-8";
        private Decorator decorator = new DefaultDecorator();
        private BlockEmitter codeBlockEmitter = null;
        private SpanEmitter specialLinkEmitter = null;
        private final List<Plugin> plugins = new ArrayList<Plugin>();

        Builder() {
        }

        public Builder enableSafeMode() {
            this.safeMode = true;
            return this;
        }

        public Builder forceExtentedProfile() {
            this.forceExtendedProfile = true;
            return this;
        }

        public Builder convertNewline2Br() {
            this.convertNewline2Br = true;
            return this;
        }

        public Builder setSafeMode(boolean flag) {
            this.safeMode = flag;
            return this;
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setDecorator(Decorator decorator) {
            this.decorator = decorator;
            return this;
        }

        public Builder setCodeBlockEmitter(BlockEmitter emitter) {
            this.codeBlockEmitter = emitter;
            return this;
        }

        public Builder setSpecialLinkEmitter(SpanEmitter emitter) {
            this.specialLinkEmitter = emitter;
            return this;
        }

        public Builder registerPlugins(Plugin ... plugins) {
            for (Plugin plugin : plugins) {
                this.plugins.add(plugin);
            }
            return this;
        }

        public Configuration build() {
            return new Configuration(this.safeMode, this.encoding, this.decorator, this.codeBlockEmitter, this.forceExtendedProfile, this.convertNewline2Br, this.specialLinkEmitter, this.plugins);
        }

        public Decorator getDecorator() {
            return this.decorator;
        }
    }
}

