/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.lib.YarnInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.YarnRunner;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.NpmPackage;
import org.apache.zeppelin.helium.WebpackResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliumBundleFactory {
    private Logger logger = LoggerFactory.getLogger(HeliumBundleFactory.class);
    private static final String NODE_VERSION = "v6.9.1";
    private static final String NPM_VERSION = "3.10.8";
    private static final String YARN_VERSION = "v0.21.3";
    private static final String NPM_PACKAGE_NAME = "npm";
    protected static final String HELIUM_LOCAL_REPO = "helium-bundle";
    private static final String HELIUM_BUNDLES_DIR = "bundles";
    private static final String HELIUM_LOCAL_MODULE_DIR = "local_modules";
    private static final String HELIUM_BUNDLES_SRC_DIR = "src";
    private static final String HELIUM_BUNDLES_SRC = "load.js";
    private static final String YARN_CACHE_DIR = "yarn-cache";
    private static final String PACKAGE_JSON = "package.json";
    private static final String HELIUM_BUNDLE_CACHE = "helium.bundle.cache.js";
    private static final String HELIUM_BUNDLE = "helium.bundle.js";
    private static final String HELIUM_BUNDLES_VAR = "heliumBundles";
    private static final int FETCH_RETRY_COUNT = 2;
    private static final int FETCH_RETRY_FACTOR_COUNT = 1;
    private static final int FETCH_RETRY_MIN_TIMEOUT = 5000;
    private final FrontendPluginFactory frontEndPluginFactory;
    private final File nodeInstallationDirectory;
    private final File heliumLocalRepoDirectory;
    private final File heliumBundleDirectory;
    private final File heliumLocalModuleDirectory;
    private final File yarnCacheDir;
    private File tabledataModulePath;
    private File visualizationModulePath;
    private File spellModulePath;
    private String defaultNodeInstallerUrl;
    private String defaultNpmInstallerUrl;
    private String defaultYarnInstallerUrl;
    private Gson gson;
    private boolean nodeAndNpmInstalled = false;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public HeliumBundleFactory(ZeppelinConfiguration conf, File nodeInstallationDir, File moduleDownloadPath, File tabledataModulePath, File visualizationModulePath, File spellModulePath) throws TaskRunnerException {
        this(conf, nodeInstallationDir, moduleDownloadPath);
        this.tabledataModulePath = tabledataModulePath;
        this.visualizationModulePath = visualizationModulePath;
        this.spellModulePath = spellModulePath;
    }

    private HeliumBundleFactory(ZeppelinConfiguration conf, File nodeInstallationDir, File moduleDownloadPath) throws TaskRunnerException {
        this.heliumLocalRepoDirectory = new File(moduleDownloadPath, HELIUM_LOCAL_REPO);
        this.heliumBundleDirectory = new File(this.heliumLocalRepoDirectory, HELIUM_BUNDLES_DIR);
        this.heliumLocalModuleDirectory = new File(this.heliumLocalRepoDirectory, HELIUM_LOCAL_MODULE_DIR);
        this.yarnCacheDir = new File(this.heliumLocalRepoDirectory, YARN_CACHE_DIR);
        this.defaultNodeInstallerUrl = conf.getHeliumNodeInstallerUrl();
        this.defaultNpmInstallerUrl = conf.getHeliumNpmInstallerUrl();
        this.defaultYarnInstallerUrl = conf.getHeliumYarnInstallerUrl();
        this.nodeInstallationDirectory = nodeInstallationDir == null ? this.heliumLocalRepoDirectory : nodeInstallationDir;
        this.frontEndPluginFactory = new FrontendPluginFactory(this.heliumLocalRepoDirectory, this.nodeInstallationDirectory);
        this.gson = new Gson();
    }

    void installNodeAndNpm() throws TaskRunnerException {
        if (this.nodeAndNpmInstalled) {
            return;
        }
        try {
            NodeInstaller nodeInstaller = this.frontEndPluginFactory.getNodeInstaller(this.getProxyConfig(this.isSecure(this.defaultNodeInstallerUrl)));
            nodeInstaller.setNodeVersion(NODE_VERSION);
            nodeInstaller.setNodeDownloadRoot(this.defaultNodeInstallerUrl);
            nodeInstaller.install();
            NPMInstaller npmInstaller = this.frontEndPluginFactory.getNPMInstaller(this.getProxyConfig(this.isSecure(this.defaultNpmInstallerUrl)));
            npmInstaller.setNpmVersion(NPM_VERSION);
            npmInstaller.setNpmDownloadRoot(this.defaultNpmInstallerUrl + "/" + NPM_PACKAGE_NAME + "/-/");
            npmInstaller.install();
            YarnInstaller yarnInstaller = this.frontEndPluginFactory.getYarnInstaller(this.getProxyConfig(this.isSecure(this.defaultYarnInstallerUrl)));
            yarnInstaller.setYarnVersion(YARN_VERSION);
            yarnInstaller.setYarnDownloadRoot(this.defaultYarnInstallerUrl);
            yarnInstaller.install();
            this.yarnCacheDir.mkdirs();
            String yarnCacheDirPath = this.yarnCacheDir.getAbsolutePath();
            this.yarnCommand(this.frontEndPluginFactory, "config set cache-folder " + yarnCacheDirPath);
            this.configureLogger();
            this.nodeAndNpmInstalled = true;
        }
        catch (InstallationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private ProxyConfig getProxyConfig(boolean isSecure) {
        LinkedList<ProxyConfig.Proxy> proxies = new LinkedList<ProxyConfig.Proxy>();
        String httpProxy = StringUtils.isBlank((String)System.getenv("http_proxy")) ? System.getenv("HTTP_PROXY") : System.getenv("http_proxy");
        String httpsProxy = StringUtils.isBlank((String)System.getenv("https_proxy")) ? System.getenv("HTTPS_PROXY") : System.getenv("https_proxy");
        try {
            if (isSecure && StringUtils.isNotBlank((String)httpsProxy)) {
                proxies.add(this.generateProxy("secure", new URI(httpsProxy)));
            } else if (!isSecure && StringUtils.isNotBlank((String)httpProxy)) {
                proxies.add(this.generateProxy("insecure", new URI(httpProxy)));
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return new ProxyConfig(proxies);
    }

    private ProxyConfig.Proxy generateProxy(String proxyId, URI uri) {
        String protocol = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort() <= 0 ? 80 : uri.getPort();
        String username = null;
        String password = null;
        if (uri.getUserInfo() != null) {
            String[] authority = uri.getUserInfo().split(":");
            if (authority.length == 2) {
                username = authority[0];
                password = authority[1];
            } else if (authority.length == 1) {
                username = authority[0];
            }
        }
        String nonProxyHosts = StringUtils.isBlank((String)System.getenv("no_proxy")) ? System.getenv("NO_PROXY") : System.getenv("no_proxy");
        return new ProxyConfig.Proxy(proxyId, protocol, host, port, username, password, nonProxyHosts);
    }

    private boolean isSecure(String url) {
        return url.toLowerCase().startsWith("https");
    }

    public void buildAllPackages(List<HeliumPackage> pkgs) throws IOException {
        this.buildAllPackages(pkgs, false);
    }

    private File getHeliumPackageDirectory(String pkgName) {
        return new File(this.heliumBundleDirectory, pkgName);
    }

    private File getHeliumPackageSourceDirectory(String pkgName) {
        return new File(this.heliumBundleDirectory, pkgName + "/" + HELIUM_BUNDLES_SRC_DIR);
    }

    private File getHeliumPackageBundleCache(String pkgName) {
        return new File(this.heliumBundleDirectory, pkgName + "/" + HELIUM_BUNDLE_CACHE);
    }

    private static List<String> unTgz(File tarFile, File directory) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (TarArchiveInputStream in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(tarFile)));){
            TarArchiveEntry entry = in.getNextTarEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    entry = in.getNextTarEntry();
                    continue;
                }
                File curfile = new File(directory, entry.getName());
                File parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try (FileOutputStream out = new FileOutputStream(curfile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                result.add(entry.getName());
                entry = in.getNextTarEntry();
            }
        }
        return result;
    }

    private String downloadPackage(HeliumPackage pkg, String[] nameAndVersion, File bundleDir, String templateWebpackConfig, String templatePackageJson, FrontendPluginFactory fpf) throws IOException, TaskRunnerException {
        if (bundleDir.exists()) {
            FileUtils.deleteQuietly((File)bundleDir);
        }
        FileUtils.forceMkdir((File)bundleDir);
        FileFilter copyFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName();
                return !fileName.startsWith(".") && !fileName.startsWith("#") && !fileName.startsWith("~");
            }
        };
        if (this.isLocalPackage(pkg)) {
            FileUtils.copyDirectory((File)new File(pkg.getArtifact()), (File)bundleDir, (FileFilter)copyFilter);
        } else {
            String version = nameAndVersion[1];
            File tgz = new File(this.heliumLocalRepoDirectory, pkg.getName() + "-" + version + ".tgz");
            tgz.delete();
            this.npmCommand(fpf, "pack " + pkg.getArtifact());
            File extracted = new File(this.heliumBundleDirectory, "package");
            FileUtils.deleteDirectory((File)extracted);
            List<String> entries = HeliumBundleFactory.unTgz(tgz, this.heliumBundleDirectory);
            for (String entry : entries) {
                this.logger.debug("Extracted " + entry);
            }
            tgz.delete();
            FileUtils.copyDirectory((File)extracted, (File)bundleDir);
            FileUtils.deleteDirectory((File)extracted);
        }
        File existingPackageJson = new File(bundleDir, PACKAGE_JSON);
        JsonReader reader = new JsonReader((Reader)new FileReader(existingPackageJson));
        Map packageJson = (Map)this.gson.fromJson(reader, new TypeToken<Map<String, Object>>(){}.getType());
        Map existingDeps = (Map)packageJson.get("dependencies");
        String mainFileName = (String)packageJson.get("main");
        StringBuilder dependencies = new StringBuilder();
        int index = 0;
        for (Map.Entry e : existingDeps.entrySet()) {
            dependencies.append("    \"").append((String)e.getKey()).append("\": ");
            if (((String)e.getKey()).equals("zeppelin-vis") || ((String)e.getKey()).equals("zeppelin-tabledata") || ((String)e.getKey()).equals("zeppelin-spell")) {
                dependencies.append("\"file:../../local_modules/").append((String)e.getKey()).append("\"");
            } else {
                dependencies.append("\"").append((String)e.getValue()).append("\"");
            }
            if (index < existingDeps.size() - 1) {
                dependencies.append(",\n");
            }
            ++index;
        }
        FileUtils.deleteQuietly((File)new File(bundleDir, PACKAGE_JSON));
        templatePackageJson = templatePackageJson.replaceFirst("PACKAGE_NAME", pkg.getName());
        templatePackageJson = templatePackageJson.replaceFirst("MAIN_FILE", mainFileName);
        templatePackageJson = templatePackageJson.replaceFirst("DEPENDENCIES", dependencies.toString());
        FileUtils.write((File)new File(bundleDir, PACKAGE_JSON), (CharSequence)templatePackageJson);
        FileUtils.write((File)new File(bundleDir, "webpack.config.js"), (CharSequence)templateWebpackConfig);
        return mainFileName;
    }

    private void prepareSource(HeliumPackage pkg, String[] moduleNameVersion, String mainFileName) throws IOException {
        StringBuilder loadJsImport = new StringBuilder();
        StringBuilder loadJsRegister = new StringBuilder();
        String className = HELIUM_BUNDLES_DIR + pkg.getName().replaceAll("[-_]", "");
        if (mainFileName.endsWith(".js")) {
            mainFileName = mainFileName.substring(0, mainFileName.length() - 3);
        }
        loadJsImport.append("import ").append(className).append(" from \"../" + mainFileName + "\"\n");
        loadJsRegister.append("heliumBundles.push({\n");
        loadJsRegister.append("id: \"" + moduleNameVersion[0] + "\",\n");
        loadJsRegister.append("name: \"" + pkg.getName() + "\",\n");
        loadJsRegister.append("icon: " + this.gson.toJson((Object)pkg.getIcon()) + ",\n");
        loadJsRegister.append("type: \"" + pkg.getType() + "\",\n");
        loadJsRegister.append("class: " + className + "\n");
        loadJsRegister.append("})\n");
        File srcDir = this.getHeliumPackageSourceDirectory(pkg.getName());
        FileUtils.forceMkdir((File)srcDir);
        FileUtils.write((File)new File(srcDir, HELIUM_BUNDLES_SRC), (CharSequence)loadJsImport.append((CharSequence)loadJsRegister).toString());
    }

    private synchronized void installNodeModules(FrontendPluginFactory fpf) throws IOException {
        try {
            this.out.reset();
            String commandForNpmInstall = String.format("install --fetch-retries=%d --fetch-retry-factor=%d --fetch-retry-mintimeout=%d", 2, 1, 5000);
            this.logger.info("Installing required node modules");
            this.yarnCommand(fpf, commandForNpmInstall);
            this.logger.info("Installed required node modules");
        }
        catch (TaskRunnerException e) {
            throw new IOException(e);
        }
    }

    private synchronized File bundleHeliumPackage(FrontendPluginFactory fpf, File bundleDir) throws IOException {
        try {
            this.out.reset();
            this.logger.info("Bundling helium packages");
            this.yarnCommand(fpf, "run bundle");
            this.logger.info("Bundled helium packages");
        }
        catch (TaskRunnerException e) {
            throw new IOException(new String(this.out.toByteArray()));
        }
        String bundleStdoutResult = new String(this.out.toByteArray());
        File heliumBundle = new File(bundleDir, HELIUM_BUNDLE);
        if (!heliumBundle.isFile()) {
            throw new IOException("Can't create bundle: \n" + bundleStdoutResult);
        }
        WebpackResult result = this.getWebpackResultFromOutput(bundleStdoutResult);
        if (result.errors.length > 0) {
            FileUtils.deleteQuietly((File)heliumBundle);
            throw new IOException(result.errors[0]);
        }
        return heliumBundle;
    }

    public synchronized File buildPackage(HeliumPackage pkg, boolean rebuild, boolean recopyLocalModule) throws IOException {
        if (pkg == null) {
            return null;
        }
        String[] moduleNameVersion = this.getNpmModuleNameAndVersion(pkg);
        if (moduleNameVersion == null) {
            this.logger.warn("Can't get module name and version of package " + pkg.getName());
            return null;
        }
        String pkgName = pkg.getName();
        File bundleDir = this.getHeliumPackageDirectory(pkgName);
        File bundleCache = this.getHeliumPackageBundleCache(pkgName);
        if (!rebuild && bundleCache.exists() && !bundleCache.isDirectory()) {
            return bundleCache;
        }
        try {
            this.installNodeAndNpm();
        }
        catch (TaskRunnerException e) {
            throw new IOException(e);
        }
        if (!this.heliumLocalRepoDirectory.exists() || !this.heliumLocalRepoDirectory.isDirectory()) {
            FileUtils.deleteQuietly((File)this.heliumLocalRepoDirectory);
            FileUtils.forceMkdir((File)this.heliumLocalRepoDirectory);
        }
        FrontendPluginFactory fpf = new FrontendPluginFactory(bundleDir, this.nodeInstallationDirectory);
        String templateWebpackConfig = Resources.toString((URL)Resources.getResource((String)"helium/webpack.config.js"), (Charset)Charsets.UTF_8);
        String templatePackageJson = Resources.toString((URL)Resources.getResource((String)"helium/package.json"), (Charset)Charsets.UTF_8);
        String mainFileName = null;
        try {
            mainFileName = this.downloadPackage(pkg, moduleNameVersion, bundleDir, templateWebpackConfig, templatePackageJson, fpf);
        }
        catch (TaskRunnerException e) {
            throw new IOException(e);
        }
        this.prepareSource(pkg, moduleNameVersion, mainFileName);
        this.copyFrameworkModulesToInstallPath(recopyLocalModule);
        this.installNodeModules(fpf);
        File heliumBundle = this.bundleHeliumPackage(fpf, bundleDir);
        bundleCache.delete();
        FileUtils.moveFile((File)heliumBundle, (File)bundleCache);
        return bundleCache;
    }

    private synchronized void buildAllPackages(List<HeliumPackage> pkgs, boolean rebuild) throws IOException {
        if (pkgs == null || pkgs.size() == 0) {
            return;
        }
        boolean recopyLocalModules = false;
        for (HeliumPackage pkg : pkgs) {
            try {
                this.buildPackage(pkg, rebuild, recopyLocalModules);
            }
            catch (IOException e) {
                this.logger.error("Failed to build helium package: " + pkg.getArtifact(), (Throwable)e);
            }
        }
    }

    private void copyFrameworkModule(boolean recopy, FileFilter filter, File src, File dest) throws IOException {
        if (src != null) {
            if (recopy && dest.exists()) {
                FileUtils.deleteDirectory((File)dest);
            }
            if (!dest.exists()) {
                FileUtils.copyDirectory((File)src, (File)dest, (FileFilter)filter);
            }
        }
    }

    private void deleteYarnCache() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name.startsWith("npm-zeppelin-vis-") || name.startsWith("npm-zeppelin-tabledata-") || name.startsWith("npm-zeppelin-spell-")) && dir.isDirectory();
            }
        };
        File[] localModuleCaches = this.yarnCacheDir.listFiles(filter);
        if (localModuleCaches != null) {
            for (File f : localModuleCaches) {
                FileUtils.deleteQuietly((File)f);
            }
        }
    }

    void copyFrameworkModulesToInstallPath(boolean recopy) throws IOException {
        FileFilter npmPackageCopyFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName();
                return !fileName.startsWith(".") && !fileName.startsWith("#") && !fileName.startsWith("~");
            }
        };
        FileUtils.forceMkdir((File)this.heliumLocalModuleDirectory);
        this.deleteYarnCache();
        File tabledataModuleInstallPath = new File(this.heliumLocalModuleDirectory, "zeppelin-tabledata");
        this.copyFrameworkModule(recopy, npmPackageCopyFilter, this.tabledataModulePath, tabledataModuleInstallPath);
        File visModuleInstallPath = new File(this.heliumLocalModuleDirectory, "zeppelin-vis");
        this.copyFrameworkModule(recopy, npmPackageCopyFilter, this.visualizationModulePath, visModuleInstallPath);
        File spellModuleInstallPath = new File(this.heliumLocalModuleDirectory, "zeppelin-spell");
        this.copyFrameworkModule(recopy, npmPackageCopyFilter, this.spellModulePath, spellModuleInstallPath);
    }

    private WebpackResult getWebpackResultFromOutput(String output) {
        BufferedReader reader = new BufferedReader(new StringReader(output));
        boolean webpackRunDetected = false;
        boolean resultJsonDetected = false;
        StringBuffer sb = new StringBuffer();
        try {
            boolean last;
            String line = reader.readLine();
            boolean bl = last = line == null;
            while (!last) {
                String next = reader.readLine();
                boolean bl2 = last = next == null;
                if (!webpackRunDetected) {
                    String trimed = line.trim();
                    if (trimed.contains("webpack") && trimed.endsWith("--json")) {
                        webpackRunDetected = true;
                    }
                } else if (!resultJsonDetected) {
                    if (line.trim().equals("{")) {
                        sb.append(line);
                        resultJsonDetected = true;
                    }
                } else if (resultJsonDetected && webpackRunDetected && !last) {
                    sb.append(line);
                }
                line = next;
            }
            return WebpackResult.fromJson(sb.toString());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new WebpackResult();
        }
    }

    private boolean isLocalPackage(HeliumPackage pkg) {
        return pkg.getArtifact().startsWith(".") || pkg.getArtifact().startsWith("/");
    }

    private String[] getNpmModuleNameAndVersion(HeliumPackage pkg) {
        String artifact = pkg.getArtifact();
        if (this.isLocalPackage(pkg)) {
            File packageJson = new File(artifact, PACKAGE_JSON);
            if (!packageJson.isFile()) {
                return null;
            }
            try {
                NpmPackage npmPackage = NpmPackage.fromJson(FileUtils.readFileToString((File)packageJson));
                String[] nameVersion = new String[]{npmPackage.name, npmPackage.version};
                return nameVersion;
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        String[] nameVersion = new String[2];
        int pos = artifact.indexOf(64);
        if (pos > 0) {
            nameVersion[0] = artifact.substring(0, pos);
            nameVersion[1] = artifact.substring(pos + 1);
        } else {
            pos = artifact.indexOf(94);
            if (pos > 0 || (pos = artifact.indexOf(126)) > 0) {
                nameVersion[0] = artifact.substring(0, pos);
                nameVersion[1] = artifact.substring(pos);
            } else {
                nameVersion[0] = artifact;
                nameVersion[1] = "";
            }
        }
        return nameVersion;
    }

    synchronized void install(HeliumPackage pkg) throws TaskRunnerException {
        String commandForNpmInstallArtifact = String.format("install %s --fetch-retries=%d --fetch-retry-factor=%d --fetch-retry-mintimeout=%d", pkg.getArtifact(), 2, 1, 5000);
        this.npmCommand(commandForNpmInstallArtifact);
    }

    private void npmCommand(String args) throws TaskRunnerException {
        this.npmCommand(args, new HashMap<String, String>());
    }

    private void npmCommand(String args, Map<String, String> env) throws TaskRunnerException {
        NpmRunner npm = this.frontEndPluginFactory.getNpmRunner(this.getProxyConfig(this.isSecure(this.defaultNpmInstallerUrl)), this.defaultNpmInstallerUrl);
        npm.execute(args, env);
    }

    private void npmCommand(FrontendPluginFactory fpf, String args) throws TaskRunnerException {
        this.npmCommand(args, new HashMap<String, String>());
    }

    private void yarnCommand(FrontendPluginFactory fpf, String args) throws TaskRunnerException {
        this.yarnCommand(fpf, args, new HashMap<String, String>());
    }

    private void yarnCommand(FrontendPluginFactory fpf, String args, Map<String, String> env) throws TaskRunnerException {
        YarnRunner yarn = fpf.getYarnRunner(this.getProxyConfig(this.isSecure(this.defaultNpmInstallerUrl)), this.defaultNpmInstallerUrl);
        yarn.execute(args, env);
    }

    private synchronized void configureLogger() {
        org.apache.log4j.Logger npmLogger = org.apache.log4j.Logger.getLogger((String)"com.github.eirslett.maven.plugins.frontend.lib.DefaultYarnRunner");
        Enumeration appenders = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        if (appenders != null) {
            while (appenders.hasMoreElements()) {
                Appender appender = (Appender)appenders.nextElement();
                appender.addFilter(new Filter(){

                    public int decide(LoggingEvent loggingEvent) {
                        if (loggingEvent.getLoggerName().contains("DefaultYarnRunner")) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
        }
        npmLogger.addAppender((Appender)new WriterAppender((Layout)new PatternLayout("%m%n"), (OutputStream)this.out));
    }
}

