/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.apache.zeppelin.helium.HeliumRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliumRegistrySerializer
implements JsonSerializer<HeliumRegistry>,
JsonDeserializer<HeliumRegistry> {
    Logger logger = LoggerFactory.getLogger(HeliumRegistrySerializer.class);

    public HeliumRegistry deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String className = jsonObject.get("class").getAsString();
        String uri = jsonObject.get("uri").getAsString();
        String name = jsonObject.get("name").getAsString();
        try {
            this.logger.info("Restore helium registry {} {} {}", new Object[]{name, className, uri});
            Class<?> cls = this.getClass().getClassLoader().loadClass(className);
            Constructor<?> constructor = cls.getConstructor(String.class, String.class);
            HeliumRegistry registry = (HeliumRegistry)constructor.newInstance(name, uri);
            return registry;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JsonElement serialize(HeliumRegistry heliumRegistry, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject json = new JsonObject();
        json.addProperty("class", heliumRegistry.getClass().getName());
        json.addProperty("uri", heliumRegistry.uri());
        json.addProperty("name", heliumRegistry.name());
        return json;
    }
}

