/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfInterpreter
extends Interpreter {
    private static Logger LOGGER = LoggerFactory.getLogger(ConfInterpreter.class);
    protected String sessionId;
    protected String interpreterGroupId;
    protected InterpreterSetting interpreterSetting;

    public ConfInterpreter(Properties properties, String sessionId, String interpreterGroupId, InterpreterSetting interpreterSetting) {
        super(properties);
        this.sessionId = sessionId;
        this.interpreterGroupId = interpreterGroupId;
        this.interpreterSetting = interpreterSetting;
    }

    public void open() throws InterpreterException {
    }

    public void close() throws InterpreterException {
    }

    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        try {
            Properties finalProperties = new Properties();
            finalProperties.putAll((Map<?, ?>)this.getProperties());
            Properties newProperties = new Properties();
            newProperties.load(new StringReader(st));
            finalProperties.putAll((Map<?, ?>)newProperties);
            LOGGER.debug("Properties for InterpreterGroup: " + this.interpreterGroupId + " is " + finalProperties);
            this.interpreterSetting.setInterpreterGroupProperties(this.interpreterGroupId, finalProperties);
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        catch (IOException e) {
            LOGGER.error("Fail to update interpreter setting", (Throwable)e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return null;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return 0;
    }
}

