/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterFactory.class);
    private final InterpreterSettingManager interpreterSettingManager;

    public InterpreterFactory(InterpreterSettingManager interpreterSettingManager) {
        this.interpreterSettingManager = interpreterSettingManager;
    }

    private InterpreterSetting getInterpreterSettingByGroup(List<InterpreterSetting> settings, String group) {
        Preconditions.checkNotNull((Object)group, (Object)"group should be not null");
        for (InterpreterSetting setting : settings) {
            if (!group.equals(setting.getName())) continue;
            return setting;
        }
        return null;
    }

    public Interpreter getInterpreter(String user, String noteId, String replName) throws InterpreterNotFoundException {
        List<InterpreterSetting> settings = this.interpreterSettingManager.getInterpreterSettings(noteId);
        if (settings == null || settings.size() == 0) {
            throw new InterpreterNotFoundException("No interpreter is binded to this note: " + noteId);
        }
        if (StringUtils.isBlank((String)replName)) {
            InterpreterSetting defaultSetting = settings.get(0);
            return defaultSetting.getDefaultInterpreter(user, noteId);
        }
        String[] replNameSplit = replName.split("\\.");
        if (replNameSplit.length == 2) {
            String group = replNameSplit[0];
            String name = replNameSplit[1];
            InterpreterSetting setting = this.getInterpreterSettingByGroup(settings, group);
            if (null != setting) {
                Interpreter interpreter = setting.getInterpreter(user, noteId, name);
                if (null != interpreter) {
                    return interpreter;
                }
                throw new InterpreterNotFoundException("No such interpreter: " + replName);
            }
            throw new InterpreterNotFoundException("Interpreter " + group + " is not binded to this note");
        }
        if (replNameSplit.length == 1) {
            InterpreterSetting setting = settings.get(0);
            Interpreter interpreter = setting.getInterpreter(user, noteId, replName);
            if (null != interpreter) {
                return interpreter;
            }
            setting = this.getInterpreterSettingByGroup(settings, replName);
            if (null != setting) {
                return setting.getDefaultInterpreter(user, noteId);
            }
            throw new InterpreterNotFoundException("Either no interpreter named " + replName + " or it is not binded to this note");
        }
        throw new InterpreterNotFoundException("No such interpreter " + replName + " for note " + noteId);
    }
}

