/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.repository.RemoteRepository;

public class InterpreterInfoSaving
implements JsonSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterInfoSaving.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public Map<String, InterpreterSetting> interpreterSettings = new HashMap<String, InterpreterSetting>();
    public Map<String, List<String>> interpreterBindings = new HashMap<String, List<String>>();
    public List<RemoteRepository> interpreterRepositories = new ArrayList<RemoteRepository>();

    public static InterpreterInfoSaving loadFromFile(Path file) throws IOException {
        LOGGER.info("Load interpreter setting from file: " + file);
        InterpreterInfoSaving infoSaving = null;
        try (BufferedReader json = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse((Reader)json).getAsJsonObject();
            infoSaving = InterpreterInfoSaving.fromJson(jsonObject.toString());
            if (infoSaving != null && infoSaving.interpreterSettings != null) {
                for (InterpreterSetting interpreterSetting : infoSaving.interpreterSettings.values()) {
                    interpreterSetting.convertPermissionsFromUsersToOwners(jsonObject.getAsJsonObject("interpreterSettings").getAsJsonObject(interpreterSetting.getId()));
                }
            }
        }
        return infoSaving == null ? new InterpreterInfoSaving() : infoSaving;
    }

    public void saveToFile(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
            try {
                EnumSet<PosixFilePermission> permissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
                Files.setPosixFilePermissions(file, permissions);
            }
            catch (UnsupportedOperationException e) {
                LOGGER.warn("unable to setPosixFilePermissions on '{}'.", (Object)file);
            }
        }
        LOGGER.info("Save Interpreter Settings to " + file);
        IOUtils.write((String)this.toJson(), (OutputStream)new FileOutputStream(file.toFile()));
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static InterpreterInfoSaving fromJson(String json) {
        return (InterpreterInfoSaving)gson.fromJson(json, InterpreterInfoSaving.class);
    }
}

