/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.StringMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.Dependency;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.ConfInterpreter;
import org.apache.zeppelin.interpreter.DefaultInterpreterProperty;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterInfo;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterPropertyType;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.LifecycleManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.SessionConfInterpreter;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.InterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.ShellScriptLauncher;
import org.apache.zeppelin.interpreter.launcher.SparkInterpreterLauncher;
import org.apache.zeppelin.interpreter.lifecycle.NullLifecycleManager;
import org.apache.zeppelin.interpreter.recovery.NullRecoveryStorage;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventPoller;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.util.IdHashes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterSetting {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterSetting.class);
    private static final String SHARED_PROCESS = "shared_process";
    private static final String SHARED_SESSION = "shared_session";
    private static final Map<String, Object> DEFAULT_EDITOR = ImmutableMap.of((Object)"language", (Object)"text", (Object)"editOnDblClick", (Object)false);
    private String id;
    private String name;
    private String group;
    private Object properties = new Properties();
    private Status status;
    private String errorReason;
    @SerializedName(value="interpreterGroup")
    private List<InterpreterInfo> interpreterInfos;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private InterpreterOption option = new InterpreterOption();
    @SerializedName(value="runner")
    private InterpreterRunner interpreterRunner;
    private transient InterpreterSettingManager interpreterSettingManager;
    private transient String interpreterDir;
    private final transient Map<String, ManagedInterpreterGroup> interpreterGroups = new ConcurrentHashMap<String, ManagedInterpreterGroup>();
    private final transient ReentrantReadWriteLock.ReadLock interpreterGroupReadLock;
    private final transient ReentrantReadWriteLock.WriteLock interpreterGroupWriteLock;
    private transient AngularObjectRegistryListener angularObjectRegistryListener;
    private transient RemoteInterpreterProcessListener remoteInterpreterProcessListener;
    private transient ApplicationEventListener appEventListener;
    private transient DependencyResolver dependencyResolver;
    private transient Map<String, String> infos;
    private transient Map<String, Set<String>> runtimeInfosToBeCleared;
    private transient ZeppelinConfiguration conf = new ZeppelinConfiguration();
    private transient InterpreterLauncher launcher;
    private transient LifecycleManager lifecycleManager;
    private transient RecoveryStorage recoveryStorage;

    public InterpreterSetting() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.id = IdHashes.generateId();
        this.interpreterGroupReadLock = lock.readLock();
        this.interpreterGroupWriteLock = lock.writeLock();
    }

    void postProcessing() {
        this.status = Status.READY;
        this.id = this.name;
        if (this.lifecycleManager == null) {
            this.lifecycleManager = new NullLifecycleManager(this.conf);
        }
        if (this.recoveryStorage == null) {
            try {
                this.recoveryStorage = new NullRecoveryStorage(this.conf, this.interpreterSettingManager);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public InterpreterSetting(InterpreterSetting o) {
        this();
        this.id = o.name;
        this.name = o.name;
        this.group = o.group;
        this.properties = InterpreterSetting.convertInterpreterProperties((Map)o.getProperties());
        this.interpreterInfos = new ArrayList<InterpreterInfo>(o.getInterpreterInfos());
        this.option = InterpreterOption.fromInterpreterOption((InterpreterOption)o.getOption());
        this.dependencies = new ArrayList<Dependency>(o.getDependencies());
        this.interpreterDir = o.getInterpreterDir();
        this.interpreterRunner = o.getInterpreterRunner();
        this.conf = o.getConf();
    }

    private void createLauncher() {
        this.launcher = this.group.equals("spark") ? new SparkInterpreterLauncher(this.conf, this.recoveryStorage) : new ShellScriptLauncher(this.conf, this.recoveryStorage);
    }

    public AngularObjectRegistryListener getAngularObjectRegistryListener() {
        return this.angularObjectRegistryListener;
    }

    public RemoteInterpreterProcessListener getRemoteInterpreterProcessListener() {
        return this.remoteInterpreterProcessListener;
    }

    public ApplicationEventListener getAppEventListener() {
        return this.appEventListener;
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public InterpreterSettingManager getInterpreterSettingManager() {
        return this.interpreterSettingManager;
    }

    public InterpreterSetting setAngularObjectRegistryListener(AngularObjectRegistryListener angularObjectRegistryListener) {
        this.angularObjectRegistryListener = angularObjectRegistryListener;
        return this;
    }

    public InterpreterSetting setAppEventListener(ApplicationEventListener appEventListener) {
        this.appEventListener = appEventListener;
        return this;
    }

    public InterpreterSetting setRemoteInterpreterProcessListener(RemoteInterpreterProcessListener remoteInterpreterProcessListener) {
        this.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
        return this;
    }

    public InterpreterSetting setDependencyResolver(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
        return this;
    }

    public InterpreterSetting setInterpreterSettingManager(InterpreterSettingManager interpreterSettingManager) {
        this.interpreterSettingManager = interpreterSettingManager;
        return this;
    }

    public InterpreterSetting setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
        return this;
    }

    public InterpreterSetting setRecoveryStorage(RecoveryStorage recoveryStorage) {
        this.recoveryStorage = recoveryStorage;
        return this;
    }

    public RecoveryStorage getRecoveryStorage() {
        return this.recoveryStorage;
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    private String getInterpreterGroupId(String user, String noteId) {
        String key = this.option.isExistingProcess ? "existing_process" : (this.getOption().isProcess() ? (this.option.perUserIsolated() ? user : "") + ":" + (this.option.perNoteIsolated() ? noteId : "") : SHARED_PROCESS);
        return this.id + ":" + key;
    }

    private String getInterpreterSessionId(String user, String noteId) {
        String key = this.option.isExistingProcess() ? "existing_process" : (this.option.perNoteScoped() && this.option.perUserScoped() ? user + ":" + noteId : (this.option.perUserScoped() ? user : (this.option.perNoteScoped() ? noteId : SHARED_SESSION)));
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedInterpreterGroup getOrCreateInterpreterGroup(String user, String noteId) {
        String groupId = this.getInterpreterGroupId(user, noteId);
        try {
            this.interpreterGroupWriteLock.lock();
            if (!this.interpreterGroups.containsKey(groupId)) {
                LOGGER.info("Create InterpreterGroup with groupId: {} for user: {} and note: {}", new Object[]{groupId, user, noteId});
                ManagedInterpreterGroup intpGroup = this.createInterpreterGroup(groupId);
                this.interpreterGroups.put(groupId, intpGroup);
            }
            ManagedInterpreterGroup managedInterpreterGroup = this.interpreterGroups.get(groupId);
            return managedInterpreterGroup;
        }
        finally {
            this.interpreterGroupWriteLock.unlock();
        }
    }

    void removeInterpreterGroup(String groupId) {
        try {
            this.interpreterGroupWriteLock.lock();
            this.interpreterGroups.remove(groupId);
        }
        finally {
            this.interpreterGroupWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedInterpreterGroup getInterpreterGroup(String user, String noteId) {
        String groupId = this.getInterpreterGroupId(user, noteId);
        try {
            this.interpreterGroupReadLock.lock();
            ManagedInterpreterGroup managedInterpreterGroup = this.interpreterGroups.get(groupId);
            return managedInterpreterGroup;
        }
        finally {
            this.interpreterGroupReadLock.unlock();
        }
    }

    ManagedInterpreterGroup getInterpreterGroup(String groupId) {
        return this.interpreterGroups.get(groupId);
    }

    public ArrayList<ManagedInterpreterGroup> getAllInterpreterGroups() {
        try {
            this.interpreterGroupReadLock.lock();
            ArrayList<ManagedInterpreterGroup> arrayList = new ArrayList<ManagedInterpreterGroup>(this.interpreterGroups.values());
            return arrayList;
        }
        finally {
            this.interpreterGroupReadLock.unlock();
        }
    }

    Map<String, Object> getEditorFromSettingByClassName(String className) {
        for (InterpreterInfo intpInfo : this.interpreterInfos) {
            if (!className.equals(intpInfo.getClassName())) continue;
            if (intpInfo.getEditor() == null) break;
            return intpInfo.getEditor();
        }
        return DEFAULT_EDITOR;
    }

    void closeInterpreters(String user, String noteId) {
        ManagedInterpreterGroup interpreterGroup = this.getInterpreterGroup(user, noteId);
        if (interpreterGroup != null) {
            String sessionId = this.getInterpreterSessionId(user, noteId);
            interpreterGroup.close(sessionId);
        }
    }

    public void close() {
        LOGGER.info("Close InterpreterSetting: " + this.name);
        for (ManagedInterpreterGroup intpGroup : this.interpreterGroups.values()) {
            intpGroup.close();
        }
        this.interpreterGroups.clear();
        this.runtimeInfosToBeCleared = null;
        this.infos = null;
    }

    public void setProperties(Object object) {
        if (object instanceof StringMap) {
            StringMap map = (StringMap)this.properties;
            Properties newProperties = new Properties();
            for (String key : map.keySet()) {
                newProperties.put(key, map.get((Object)key));
            }
            this.properties = newProperties;
        } else {
            this.properties = object;
        }
    }

    public Object getProperties() {
        return this.properties;
    }

    @VisibleForTesting
    public void setProperty(String name, String value) {
        ((Map)this.properties).put(name, new InterpreterProperty(name, (Object)value));
    }

    public Properties getJavaProperties() {
        Properties jProperties = new Properties();
        Map iProperties = (Map)this.properties;
        for (Map.Entry entry : iProperties.entrySet()) {
            if (((InterpreterProperty)entry.getValue()).getValue() == null) continue;
            jProperties.setProperty((String)entry.getKey(), ((InterpreterProperty)entry.getValue()).getValue().toString());
        }
        if (!jProperties.containsKey("zeppelin.interpreter.output.limit")) {
            jProperties.setProperty("zeppelin.interpreter.output.limit", this.conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_OUTPUT_LIMIT) + "");
        }
        if (!jProperties.containsKey("zeppelin.interpreter.max.poolsize")) {
            jProperties.setProperty("zeppelin.interpreter.max.poolsize", this.conf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_MAX_POOL_SIZE) + "");
        }
        String interpreterLocalRepoPath = this.conf.getInterpreterLocalRepoPath();
        jProperties.setProperty("zeppelin.interpreter.localRepo", interpreterLocalRepoPath + "/" + this.id);
        return jProperties;
    }

    public ZeppelinConfiguration getConf() {
        return this.conf;
    }

    public InterpreterSetting setConf(ZeppelinConfiguration conf) {
        this.conf = conf;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
        this.loadInterpreterDependencies();
    }

    public InterpreterOption getOption() {
        return this.option;
    }

    public void setOption(InterpreterOption option) {
        this.option = option;
    }

    public String getInterpreterDir() {
        return this.interpreterDir;
    }

    public void setInterpreterDir(String interpreterDir) {
        this.interpreterDir = interpreterDir;
    }

    public List<InterpreterInfo> getInterpreterInfos() {
        return this.interpreterInfos;
    }

    void appendDependencies(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            if (this.dependencies.contains(dependency)) continue;
            this.dependencies.add(dependency);
        }
        this.loadInterpreterDependencies();
    }

    void setInterpreterOption(InterpreterOption interpreterOption) {
        this.option = interpreterOption;
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    void setGroup(String group) {
        this.group = group;
    }

    void setName(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public void setErrorReason(String errorReason) {
        this.errorReason = errorReason;
    }

    public void setInterpreterInfos(List<InterpreterInfo> interpreterInfos) {
        this.interpreterInfos = interpreterInfos;
    }

    public void setInfos(Map<String, String> infos) {
        this.infos = infos;
    }

    public Map<String, String> getInfos() {
        return this.infos;
    }

    public InterpreterRunner getInterpreterRunner() {
        return this.interpreterRunner;
    }

    public void setInterpreterRunner(InterpreterRunner interpreterRunner) {
        this.interpreterRunner = interpreterRunner;
    }

    public void addNoteToPara(String noteId, String paraId) {
        Set<String> paraIdSet;
        if (this.runtimeInfosToBeCleared == null) {
            this.runtimeInfosToBeCleared = new HashMap<String, Set<String>>();
        }
        if ((paraIdSet = this.runtimeInfosToBeCleared.get(noteId)) == null) {
            paraIdSet = new HashSet<String>();
            this.runtimeInfosToBeCleared.put(noteId, paraIdSet);
        }
        paraIdSet.add(paraId);
    }

    public Map<String, Set<String>> getNoteIdAndParaMap() {
        return this.runtimeInfosToBeCleared;
    }

    public void clearNoteIdAndParaMap() {
        this.runtimeInfosToBeCleared = null;
    }

    List<Interpreter> createInterpreters(String user, String interpreterGroupId, String sessionId) {
        ArrayList<Interpreter> interpreters = new ArrayList<Interpreter>();
        List<InterpreterInfo> interpreterInfos = this.getInterpreterInfos();
        Properties intpProperties = this.getJavaProperties();
        for (InterpreterInfo info : interpreterInfos) {
            RemoteInterpreter interpreter = new RemoteInterpreter(intpProperties, sessionId, info.getClassName(), user, this.lifecycleManager);
            if (info.isDefaultInterpreter()) {
                interpreters.add(0, interpreter);
            } else {
                interpreters.add(interpreter);
            }
            LOGGER.info("Interpreter {} created for user: {}, sessionId: {}", new Object[]{interpreter.getClassName(), user, sessionId});
        }
        if (this.group.equals("livy")) {
            interpreters.add(new SessionConfInterpreter(intpProperties, sessionId, interpreterGroupId, this));
        } else {
            interpreters.add(new ConfInterpreter(intpProperties, sessionId, interpreterGroupId, this));
        }
        return interpreters;
    }

    synchronized RemoteInterpreterProcess createInterpreterProcess(String interpreterGroupId, String userName, Properties properties) throws IOException {
        if (this.launcher == null) {
            this.createLauncher();
        }
        InterpreterLaunchContext launchContext = new InterpreterLaunchContext(properties, this.option, this.interpreterRunner, userName, interpreterGroupId, this.id, this.group, this.name);
        RemoteInterpreterProcess process = (RemoteInterpreterProcess)this.launcher.launch(launchContext);
        process.setRemoteInterpreterEventPoller(new RemoteInterpreterEventPoller(this.remoteInterpreterProcessListener, this.appEventListener));
        this.recoveryStorage.onInterpreterClientStart((InterpreterClient)process);
        return process;
    }

    List<Interpreter> getOrCreateSession(String user, String noteId) {
        ManagedInterpreterGroup interpreterGroup = this.getOrCreateInterpreterGroup(user, noteId);
        Preconditions.checkNotNull((Object)((Object)interpreterGroup), (String)"No InterpreterGroup existed for user {}, noteId {}", (Object)user, (Object)noteId);
        String sessionId = this.getInterpreterSessionId(user, noteId);
        return interpreterGroup.getOrCreateSession(user, sessionId);
    }

    public Interpreter getDefaultInterpreter(String user, String noteId) {
        return this.getOrCreateSession(user, noteId).get(0);
    }

    public Interpreter getInterpreter(String user, String noteId, String replName) {
        Preconditions.checkNotNull((Object)noteId, (Object)"noteId should be not null");
        Preconditions.checkNotNull((Object)replName, (Object)"replName should be not null");
        String className = this.getInterpreterClassFromInterpreterSetting(replName);
        if (className == null) {
            return null;
        }
        List<Interpreter> interpreters = this.getOrCreateSession(user, noteId);
        for (Interpreter interpreter : interpreters) {
            if (!className.equals(interpreter.getClassName())) continue;
            return interpreter;
        }
        return null;
    }

    private String getInterpreterClassFromInterpreterSetting(String replName) {
        Preconditions.checkNotNull((Object)replName, (Object)"replName should be not null");
        for (InterpreterInfo info : this.interpreterInfos) {
            String infoName = info.getName();
            if (null == info.getName() || !replName.equals(infoName)) continue;
            return info.getClassName();
        }
        if (replName.equals("conf")) {
            if (this.group.equals("livy")) {
                return SessionConfInterpreter.class.getName();
            }
            return ConfInterpreter.class.getName();
        }
        return null;
    }

    private ManagedInterpreterGroup createInterpreterGroup(String groupId) {
        ManagedInterpreterGroup interpreterGroup = new ManagedInterpreterGroup(groupId, this);
        RemoteAngularObjectRegistry angularObjectRegistry = new RemoteAngularObjectRegistry(groupId, this.angularObjectRegistryListener, interpreterGroup);
        interpreterGroup.setAngularObjectRegistry(angularObjectRegistry);
        return interpreterGroup;
    }

    public void setInterpreterGroupProperties(String interpreterGroupId, Properties properties) throws IOException {
        ManagedInterpreterGroup interpreterGroup = this.interpreterGroups.get(interpreterGroupId);
        for (List session : interpreterGroup.sessions.values()) {
            for (Interpreter intp : session) {
                if (!intp.getProperties().equals(properties) && interpreterGroup.getRemoteInterpreterProcess() != null && interpreterGroup.getRemoteInterpreterProcess().isRunning()) {
                    throw new IOException("Can not change interpreter properties when interpreter process has already been launched");
                }
                intp.setProperties(properties);
            }
        }
    }

    private void loadInterpreterDependencies() {
        this.setStatus(Status.DOWNLOADING_DEPENDENCIES);
        this.setErrorReason(null);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    List<Dependency> deps;
                    File localRepoDir = new File(InterpreterSetting.this.conf.getInterpreterLocalRepoPath() + "/" + InterpreterSetting.this.id);
                    if (localRepoDir.exists()) {
                        try {
                            FileUtils.forceDelete((File)localRepoDir);
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.info("A file that does not exist cannot be deleted, nothing to worry", (Throwable)e);
                        }
                    }
                    if ((deps = InterpreterSetting.this.getDependencies()) != null) {
                        for (Dependency d : deps) {
                            File destDir = new File(InterpreterSetting.this.conf.getRelativeDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_DEP_LOCALREPO));
                            if (d.getExclusions() != null) {
                                InterpreterSetting.this.dependencyResolver.load(d.getGroupArtifactVersion(), (Collection)d.getExclusions(), new File(destDir, InterpreterSetting.this.id));
                                continue;
                            }
                            InterpreterSetting.this.dependencyResolver.load(d.getGroupArtifactVersion(), new File(destDir, InterpreterSetting.this.id));
                        }
                    }
                    InterpreterSetting.this.setStatus(Status.READY);
                    InterpreterSetting.this.setErrorReason(null);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Error while downloading repos for interpreter group : %s, go to interpreter setting page click on edit and save it again to make this interpreter work properly. : %s", InterpreterSetting.this.getGroup(), e.getLocalizedMessage()), (Throwable)e);
                    InterpreterSetting.this.setErrorReason(e.getLocalizedMessage());
                    InterpreterSetting.this.setStatus(Status.ERROR);
                }
            }
        };
        t.start();
    }

    public void convertPermissionsFromUsersToOwners(JsonObject jsonObject) {
        JsonArray users;
        JsonObject option;
        if (jsonObject != null && (option = jsonObject.getAsJsonObject("option")) != null && (users = option.getAsJsonArray("users")) != null) {
            if (this.option.getOwners() == null) {
                this.option.owners = new LinkedList();
            }
            for (JsonElement user : users) {
                this.option.getOwners().add(user.getAsString());
            }
        }
    }

    static Map<String, InterpreterProperty> convertInterpreterProperties(Object properties) {
        if (properties != null && properties instanceof StringMap) {
            HashMap<String, InterpreterProperty> newProperties = new HashMap<String, InterpreterProperty>();
            StringMap p = (StringMap)properties;
            for (Object o : p.entrySet()) {
                Map.Entry entry = (Map.Entry)o;
                if (!(entry.getValue() instanceof StringMap)) {
                    InterpreterProperty newProperty = new InterpreterProperty(entry.getKey().toString(), entry.getValue(), InterpreterPropertyType.STRING.getValue());
                    newProperties.put(entry.getKey().toString(), newProperty);
                    continue;
                }
                return (Map)properties;
            }
            return newProperties;
        }
        if (properties instanceof Map) {
            Map dProperties = (Map)properties;
            HashMap<String, InterpreterProperty> newProperties = new HashMap<String, InterpreterProperty>();
            for (String key : dProperties.keySet()) {
                Object value = dProperties.get(key);
                if (value instanceof InterpreterProperty) {
                    return (Map)properties;
                }
                if (value instanceof StringMap) {
                    StringMap stringMap = (StringMap)value;
                    InterpreterProperty newProperty = new InterpreterProperty(key, stringMap.get((Object)"value"), stringMap.containsKey((Object)"type") ? stringMap.get((Object)"type").toString() : "string");
                    newProperties.put(newProperty.getName(), newProperty);
                    continue;
                }
                if (value instanceof DefaultInterpreterProperty) {
                    DefaultInterpreterProperty dProperty = (DefaultInterpreterProperty)value;
                    InterpreterProperty property = new InterpreterProperty(key, dProperty.getValue(), dProperty.getType() != null ? dProperty.getType() : "string");
                    newProperties.put(key, property);
                    continue;
                }
                if (value instanceof String) {
                    InterpreterProperty newProperty = new InterpreterProperty(key, value, "string");
                    newProperties.put(newProperty.getName(), newProperty);
                    continue;
                }
                throw new RuntimeException("Can not convert this type of property: " + value.getClass());
            }
            return newProperties;
        }
        throw new RuntimeException("Can not convert this type: " + properties.getClass());
    }

    public void waitForReady() throws InterruptedException {
        while (this.getStatus().equals((Object)Status.DOWNLOADING_DEPENDENCIES)) {
            Thread.sleep(200L);
        }
    }

    public static enum Status {
        DOWNLOADING_DEPENDENCIES,
        ERROR,
        READY;

    }

    public static class Builder {
        private InterpreterSetting interpreterSetting = new InterpreterSetting();

        public Builder setId(String id) {
            this.interpreterSetting.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.interpreterSetting.name = name;
            return this;
        }

        public Builder setGroup(String group) {
            this.interpreterSetting.group = group;
            return this;
        }

        public Builder setInterpreterInfos(List<InterpreterInfo> interpreterInfos) {
            this.interpreterSetting.interpreterInfos = interpreterInfos;
            return this;
        }

        public Builder setProperties(Object properties) {
            this.interpreterSetting.properties = properties;
            return this;
        }

        public Builder setOption(InterpreterOption option) {
            this.interpreterSetting.option = option;
            return this;
        }

        public Builder setInterpreterDir(String interpreterDir) {
            this.interpreterSetting.interpreterDir = interpreterDir;
            return this;
        }

        public Builder setRunner(InterpreterRunner runner) {
            this.interpreterSetting.interpreterRunner = runner;
            return this;
        }

        public Builder setDependencies(List<Dependency> dependencies) {
            this.interpreterSetting.dependencies = dependencies;
            return this;
        }

        public Builder setConf(ZeppelinConfiguration conf) {
            this.interpreterSetting.conf = conf;
            return this;
        }

        public Builder setDependencyResolver(DependencyResolver dependencyResolver) {
            this.interpreterSetting.dependencyResolver = dependencyResolver;
            return this;
        }

        public Builder setInterpreterRunner(InterpreterRunner runner) {
            this.interpreterSetting.interpreterRunner = runner;
            return this;
        }

        public Builder setIntepreterSettingManager(InterpreterSettingManager interpreterSettingManager) {
            this.interpreterSetting.interpreterSettingManager = interpreterSettingManager;
            return this;
        }

        public Builder setRemoteInterpreterProcessListener(RemoteInterpreterProcessListener remoteInterpreterProcessListener) {
            this.interpreterSetting.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
            return this;
        }

        public Builder setAngularObjectRegistryListener(AngularObjectRegistryListener angularObjectRegistryListener) {
            this.interpreterSetting.angularObjectRegistryListener = angularObjectRegistryListener;
            return this;
        }

        public Builder setApplicationEventListener(ApplicationEventListener applicationEventListener) {
            this.interpreterSetting.appEventListener = applicationEventListener;
            return this;
        }

        public Builder setLifecycleManager(LifecycleManager lifecycleManager) {
            this.interpreterSetting.lifecycleManager = lifecycleManager;
            return this;
        }

        public Builder setRecoveryStorage(RecoveryStorage recoveryStorage) {
            this.interpreterSetting.recoveryStorage = recoveryStorage;
            return this;
        }

        public InterpreterSetting create() {
            this.interpreterSetting.postProcessing();
            return this.interpreterSetting;
        }
    }
}

