/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.Dependency;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterInfo;
import org.apache.zeppelin.interpreter.InterpreterInfoSaving;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManagerMBean;
import org.apache.zeppelin.interpreter.LifecycleManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.apache.zeppelin.storage.ConfigStorage;
import org.apache.zeppelin.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;

public class InterpreterSettingManager
implements InterpreterSettingManagerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterSettingManager.class);
    private static final Map<String, Object> DEFAULT_EDITOR = ImmutableMap.of((Object)"language", (Object)"text", (Object)"editOnDblClick", (Object)false);
    private final ZeppelinConfiguration conf;
    private final Path interpreterDirPath;
    private final Map<String, InterpreterSetting> interpreterSettingTemplates = Maps.newConcurrentMap();
    private final Map<String, InterpreterSetting> interpreterSettings = Maps.newConcurrentMap();
    private final Map<String, List<String>> interpreterBindings = Maps.newConcurrentMap();
    private final List<RemoteRepository> interpreterRepositories;
    private InterpreterOption defaultOption;
    private List<String> interpreterGroupOrderList;
    private final Gson gson;
    private AngularObjectRegistryListener angularObjectRegistryListener;
    private RemoteInterpreterProcessListener remoteInterpreterProcessListener;
    private ApplicationEventListener appEventListener;
    private DependencyResolver dependencyResolver;
    private LifecycleManager lifecycleManager;
    private RecoveryStorage recoveryStorage;
    private ConfigStorage configStorage;

    public InterpreterSettingManager(ZeppelinConfiguration zeppelinConfiguration, AngularObjectRegistryListener angularObjectRegistryListener, RemoteInterpreterProcessListener remoteInterpreterProcessListener, ApplicationEventListener appEventListener) throws IOException {
        this(zeppelinConfiguration, new InterpreterOption(), angularObjectRegistryListener, remoteInterpreterProcessListener, appEventListener, ConfigStorage.getInstance(zeppelinConfiguration));
    }

    public InterpreterSettingManager(ZeppelinConfiguration conf, InterpreterOption defaultOption, AngularObjectRegistryListener angularObjectRegistryListener, RemoteInterpreterProcessListener remoteInterpreterProcessListener, ApplicationEventListener appEventListener, ConfigStorage configStorage) throws IOException {
        this.conf = conf;
        this.defaultOption = defaultOption;
        this.interpreterDirPath = Paths.get(conf.getInterpreterDir(), new String[0]);
        LOGGER.debug("InterpreterRootPath: {}", (Object)this.interpreterDirPath);
        this.dependencyResolver = new DependencyResolver(conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LOCALREPO));
        this.interpreterRepositories = this.dependencyResolver.getRepos();
        this.interpreterGroupOrderList = Arrays.asList(conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_ORDER).split(","));
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.angularObjectRegistryListener = angularObjectRegistryListener;
        this.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
        this.appEventListener = appEventListener;
        this.recoveryStorage = (RecoveryStorage)ReflectionUtils.createClazzInstance(conf.getRecoveryStorageClass(), new Class[]{ZeppelinConfiguration.class, InterpreterSettingManager.class}, new Object[]{conf, this});
        this.recoveryStorage.init();
        LOGGER.info("Using RecoveryStorage: " + this.recoveryStorage.getClass().getName());
        this.lifecycleManager = (LifecycleManager)ReflectionUtils.createClazzInstance(conf.getLifecycleManagerClass(), new Class[]{ZeppelinConfiguration.class}, new Object[]{conf});
        LOGGER.info("Using LifecycleManager: " + this.lifecycleManager.getClass().getName());
        this.configStorage = configStorage;
        this.init();
    }

    private void initInterpreterSetting(InterpreterSetting interpreterSetting) {
        interpreterSetting.setConf(this.conf).setInterpreterSettingManager(this).setAngularObjectRegistryListener(this.angularObjectRegistryListener).setRemoteInterpreterProcessListener(this.remoteInterpreterProcessListener).setAppEventListener(this.appEventListener).setDependencyResolver(this.dependencyResolver).setLifecycleManager(this.lifecycleManager).setRecoveryStorage(this.recoveryStorage).postProcessing();
    }

    private void loadFromFile() throws IOException {
        InterpreterInfoSaving infoSaving = this.configStorage.loadInterpreterSettings();
        if (infoSaving == null) {
            for (InterpreterSetting interpreterSettingTemplate : this.interpreterSettingTemplates.values()) {
                InterpreterSetting interpreterSetting = new InterpreterSetting(interpreterSettingTemplate);
                this.initInterpreterSetting(interpreterSetting);
                this.interpreterSettings.put(interpreterSetting.getId(), interpreterSetting);
            }
            return;
        }
        HashMap newBindingMap = new HashMap();
        for (Map.Entry<String, List<String>> entry : infoSaving.interpreterBindings.entrySet()) {
            String noteId = entry.getKey();
            List<String> oldSettingIdList = entry.getValue();
            ArrayList<String> newSettingIdList = new ArrayList<String>();
            for (String string : oldSettingIdList) {
                if (!infoSaving.interpreterSettings.containsKey(string)) continue;
                newSettingIdList.add(infoSaving.interpreterSettings.get(string).getName());
            }
            newBindingMap.put(noteId, newSettingIdList);
        }
        this.interpreterBindings.putAll(newBindingMap);
        for (InterpreterSetting savedInterpreterSetting : infoSaving.interpreterSettings.values()) {
            savedInterpreterSetting.setProperties(InterpreterSetting.convertInterpreterProperties(savedInterpreterSetting.getProperties()));
            this.initInterpreterSetting(savedInterpreterSetting);
            InterpreterSetting interpreterSettingTemplate = this.interpreterSettingTemplates.get(savedInterpreterSetting.getGroup());
            if (interpreterSettingTemplate != null) {
                savedInterpreterSetting.setInterpreterDir(interpreterSettingTemplate.getInterpreterDir());
                HashMap<String, InterpreterProperty> mergedProperties = new HashMap<String, InterpreterProperty>(InterpreterSetting.convertInterpreterProperties(interpreterSettingTemplate.getProperties()));
                Map<String, InterpreterProperty> savedProperties = InterpreterSetting.convertInterpreterProperties(savedInterpreterSetting.getProperties());
                for (Map.Entry entry : savedProperties.entrySet()) {
                    if (((InterpreterProperty)entry.getValue()).getValue() == null || StringUtils.isBlank((String)((InterpreterProperty)entry.getValue()).toString())) continue;
                    mergedProperties.put((String)entry.getKey(), (InterpreterProperty)entry.getValue());
                }
                savedInterpreterSetting.setProperties(mergedProperties);
                savedInterpreterSetting.setInterpreterInfos(interpreterSettingTemplate.getInterpreterInfos());
                savedInterpreterSetting.setInterpreterRunner(interpreterSettingTemplate.getInterpreterRunner());
            } else {
                LOGGER.warn("No InterpreterSetting Template found for InterpreterSetting: " + savedInterpreterSetting.getGroup() + ", but it is found in interpreter.json, it would be skipped.");
                for (Map.Entry<String, List<String>> entry : this.interpreterBindings.entrySet()) {
                    List<String> ids = entry.getValue();
                    Iterator<String> iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        if (!iterator.next().equals(savedInterpreterSetting.getId())) continue;
                        iterator.remove();
                    }
                }
                continue;
            }
            for (InterpreterSetting setting : this.interpreterSettings.values()) {
                if (!setting.getName().equals(savedInterpreterSetting.getName())) continue;
                this.interpreterSettings.remove(setting.getId());
            }
            savedInterpreterSetting.postProcessing();
            LOGGER.info("Create Interpreter Setting {} from interpreter.json", (Object)savedInterpreterSetting.getName());
            this.interpreterSettings.put(savedInterpreterSetting.getId(), savedInterpreterSetting);
        }
        if (infoSaving.interpreterRepositories != null) {
            for (RemoteRepository repo : infoSaving.interpreterRepositories) {
                if (this.dependencyResolver.getRepos().contains(repo)) continue;
                this.interpreterRepositories.add(repo);
            }
            for (InterpreterSetting setting : this.interpreterSettings.values()) {
                setting.setDependencies(setting.getDependencies());
            }
        }
    }

    public void saveToFile() throws IOException {
        InterpreterInfoSaving info = new InterpreterInfoSaving();
        info.interpreterBindings = this.interpreterBindings;
        info.interpreterSettings = Maps.newHashMap(this.interpreterSettings);
        info.interpreterRepositories = this.interpreterRepositories;
        this.configStorage.save(info);
    }

    private void init() throws IOException {
        String interpreterJson = this.conf.getInterpreterJson();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (Files.exists(this.interpreterDirPath, new LinkOption[0])) {
            for (Path interpreterDir : Files.newDirectoryStream(this.interpreterDirPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return Files.exists(entry, new LinkOption[0]) && Files.isDirectory(entry, new LinkOption[0]);
                }
            })) {
                String interpreterDirString = interpreterDir.toString();
                if (this.registerInterpreterFromPath(interpreterDirString, interpreterJson) || this.registerInterpreterFromResource(cl, interpreterDirString, interpreterJson)) continue;
                LOGGER.warn("No interpreter-setting.json found in " + interpreterDirString);
            }
        } else {
            LOGGER.warn("InterpreterDir {} doesn't exist", (Object)this.interpreterDirPath);
        }
        this.loadFromFile();
        this.saveToFile();
    }

    public RemoteInterpreterProcessListener getRemoteInterpreterProcessListener() {
        return this.remoteInterpreterProcessListener;
    }

    public ApplicationEventListener getAppEventListener() {
        return this.appEventListener;
    }

    private boolean registerInterpreterFromResource(ClassLoader cl, String interpreterDir, String interpreterJson) throws IOException {
        URL[] urls = this.recursiveBuildLibList(new File(interpreterDir));
        URLClassLoader tempClassLoader = new URLClassLoader(urls, null);
        URL url = tempClassLoader.getResource(interpreterJson);
        if (url == null) {
            return false;
        }
        LOGGER.debug("Reading interpreter-setting.json from {} as Resource", (Object)url);
        List<Interpreter.RegisteredInterpreter> registeredInterpreterList = this.getInterpreterListFromJson(url.openStream());
        this.registerInterpreterSetting(registeredInterpreterList, interpreterDir);
        return true;
    }

    private boolean registerInterpreterFromPath(String interpreterDir, String interpreterJson) throws IOException {
        Path interpreterJsonPath = Paths.get(interpreterDir, interpreterJson);
        if (Files.exists(interpreterJsonPath, new LinkOption[0])) {
            LOGGER.debug("Reading interpreter-setting.json from file {}", (Object)interpreterJsonPath);
            List<Interpreter.RegisteredInterpreter> registeredInterpreterList = this.getInterpreterListFromJson(new FileInputStream(interpreterJsonPath.toFile()));
            this.registerInterpreterSetting(registeredInterpreterList, interpreterDir);
            return true;
        }
        return false;
    }

    private List<Interpreter.RegisteredInterpreter> getInterpreterListFromJson(InputStream stream) {
        Type registeredInterpreterListType = new TypeToken<List<Interpreter.RegisteredInterpreter>>(){}.getType();
        return (List)this.gson.fromJson((Reader)new InputStreamReader(stream), registeredInterpreterListType);
    }

    private void registerInterpreterSetting(List<Interpreter.RegisteredInterpreter> registeredInterpreters, String interpreterDir) throws IOException {
        HashMap properties = new HashMap();
        ArrayList<InterpreterInfo> interpreterInfos = new ArrayList<InterpreterInfo>();
        InterpreterOption option = this.defaultOption;
        String group = null;
        InterpreterRunner runner = null;
        for (Interpreter.RegisteredInterpreter registeredInterpreter : registeredInterpreters) {
            InterpreterInfo interpreterInfo = new InterpreterInfo(registeredInterpreter.getClassName(), registeredInterpreter.getName(), registeredInterpreter.isDefaultInterpreter(), registeredInterpreter.getEditor());
            group = registeredInterpreter.getGroup();
            runner = registeredInterpreter.getRunner();
            if (registeredInterpreter.getOption() != null) {
                option = registeredInterpreter.getOption();
            }
            properties.putAll(registeredInterpreter.getProperties());
            interpreterInfos.add(interpreterInfo);
        }
        InterpreterSetting interpreterSettingTemplate = new InterpreterSetting.Builder().setGroup(group).setName(group).setInterpreterInfos(interpreterInfos).setProperties(properties).setDependencies(new ArrayList<Dependency>()).setOption(option).setRunner(runner).setInterpreterDir(interpreterDir).setRunner(runner).setConf(this.conf).setIntepreterSettingManager(this).create();
        LOGGER.info("Register InterpreterSettingTemplate: {}", (Object)interpreterSettingTemplate.getName());
        this.interpreterSettingTemplates.put(interpreterSettingTemplate.getName(), interpreterSettingTemplate);
    }

    @VisibleForTesting
    public InterpreterSetting getDefaultInterpreterSetting(String noteId) {
        List<InterpreterSetting> allInterpreterSettings = this.getInterpreterSettings(noteId);
        return allInterpreterSettings.size() > 0 ? allInterpreterSettings.get(0) : null;
    }

    public List<InterpreterSetting> getInterpreterSettings(String noteId) {
        ArrayList<InterpreterSetting> settings = new ArrayList<InterpreterSetting>();
        List<String> interpreterSettingIds = this.interpreterBindings.get(noteId);
        if (interpreterSettingIds != null) {
            for (String settingId : interpreterSettingIds) {
                if (this.interpreterSettings.containsKey(settingId)) {
                    settings.add(this.interpreterSettings.get(settingId));
                    continue;
                }
                LOGGER.warn("InterpreterSetting {} has been removed, but note {} still bind to it.", (Object)settingId, (Object)noteId);
            }
        }
        return settings;
    }

    public InterpreterSetting getInterpreterSettingByName(String name) {
        for (InterpreterSetting setting : this.interpreterSettings.values()) {
            if (!setting.getName().equals(name)) continue;
            return setting;
        }
        throw new RuntimeException("No such interpreter setting: " + name);
    }

    public ManagedInterpreterGroup getInterpreterGroupById(String groupId) {
        for (InterpreterSetting setting : this.interpreterSettings.values()) {
            ManagedInterpreterGroup interpreterGroup = setting.getInterpreterGroup(groupId);
            if (interpreterGroup == null) continue;
            return interpreterGroup;
        }
        return null;
    }

    public Map<String, Object> getEditorSetting(Interpreter interpreter, String user, String noteId, String replName) {
        Map<String, Object> editor = DEFAULT_EDITOR;
        String group = "";
        try {
            String defaultSettingName = this.getDefaultInterpreterSetting(noteId).getName();
            List<InterpreterSetting> intpSettings = this.getInterpreterSettings(noteId);
            for (InterpreterSetting intpSetting : intpSettings) {
                String[] replNameSplit = replName.split("\\.");
                if (replNameSplit.length == 2) {
                    group = replNameSplit[0];
                }
                if (intpSetting.getName().equals(defaultSettingName)) {
                    editor = intpSetting.getEditorFromSettingByClassName(interpreter.getClassName());
                }
                if (!replName.equals(intpSetting.getName()) && !group.equals(intpSetting.getName())) continue;
                editor = intpSetting.getEditorFromSettingByClassName(interpreter.getClassName());
                break;
            }
        }
        catch (NullPointerException e) {
            LOGGER.debug("Couldn't get interpreter editor setting");
        }
        return editor;
    }

    public List<ManagedInterpreterGroup> getAllInterpreterGroup() {
        ArrayList<ManagedInterpreterGroup> interpreterGroups = new ArrayList<ManagedInterpreterGroup>();
        for (InterpreterSetting interpreterSetting : this.interpreterSettings.values()) {
            interpreterGroups.addAll(interpreterSetting.getAllInterpreterGroups());
        }
        return interpreterGroups;
    }

    public ResourceSet getAllResources() {
        return this.getAllResourcesExcept(null);
    }

    private ResourceSet getAllResourcesExcept(String interpreterGroupExcludsion) {
        ResourceSet resourceSet = new ResourceSet();
        for (ManagedInterpreterGroup intpGroup : this.getAllInterpreterGroup()) {
            if (interpreterGroupExcludsion != null && intpGroup.getId().equals(interpreterGroupExcludsion)) continue;
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool == null) continue;
                resourceSet.addAll((Collection)localPool.getAll());
                continue;
            }
            if (!remoteInterpreterProcess.isRunning()) continue;
            List<String> resourceList = remoteInterpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<List<String>>(){

                @Override
                public List<String> call(RemoteInterpreterService.Client client) throws Exception {
                    return client.resourcePoolGetAll();
                }
            });
            for (String res : resourceList) {
                resourceSet.add((Object)Resource.fromJson((String)res));
            }
        }
        return resourceSet;
    }

    public RecoveryStorage getRecoveryStorage() {
        return this.recoveryStorage;
    }

    public void removeResourcesBelongsToParagraph(String noteId, String paragraphId) {
        for (ManagedInterpreterGroup intpGroup : this.getAllInterpreterGroup()) {
            ResourceSet resourceSet = new ResourceSet();
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool != null) {
                    resourceSet.addAll((Collection)localPool.getAll());
                }
                if (noteId != null) {
                    resourceSet = resourceSet.filterByNoteId(noteId);
                }
                if (paragraphId != null) {
                    resourceSet = resourceSet.filterByParagraphId(paragraphId);
                }
                for (final Resource r : resourceSet) {
                    localPool.remove(r.getResourceId().getNoteId(), r.getResourceId().getParagraphId(), r.getResourceId().getName());
                }
                continue;
            }
            if (!remoteInterpreterProcess.isRunning()) continue;
            List<String> resourceList = remoteInterpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<List<String>>(){

                @Override
                public List<String> call(RemoteInterpreterService.Client client) throws Exception {
                    return client.resourcePoolGetAll();
                }
            });
            for (String res : resourceList) {
                resourceSet.add((Object)Resource.fromJson((String)res));
            }
            if (noteId != null) {
                resourceSet = resourceSet.filterByNoteId(noteId);
            }
            if (paragraphId != null) {
                resourceSet = resourceSet.filterByParagraphId(paragraphId);
            }
            for (final Resource r : resourceSet) {
                remoteInterpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

                    @Override
                    public Void call(RemoteInterpreterService.Client client) throws Exception {
                        client.resourceRemove(r.getResourceId().getNoteId(), r.getResourceId().getParagraphId(), r.getResourceId().getName());
                        return null;
                    }
                });
            }
        }
    }

    public void removeResourcesBelongsToNote(String noteId) {
        this.removeResourcesBelongsToParagraph(noteId, null);
    }

    private void copyDependenciesFromLocalPath(final InterpreterSetting setting) {
        setting.setStatus(InterpreterSetting.Status.DOWNLOADING_DEPENDENCIES);
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<Dependency> deps = setting.getDependencies();
                    if (deps != null) {
                        for (Dependency d : deps) {
                            File destDir = new File(InterpreterSettingManager.this.conf.getRelativeDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_DEP_LOCALREPO));
                            int numSplits = d.getGroupArtifactVersion().split(":").length;
                            if (numSplits >= 3 && numSplits <= 6) continue;
                            InterpreterSettingManager.this.dependencyResolver.copyLocalDependency(d.getGroupArtifactVersion(), new File(destDir, setting.getId()));
                        }
                    }
                    setting.setStatus(InterpreterSetting.Status.READY);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Error while copying deps for interpreter group : %s, go to interpreter setting page click on edit and save it again to make this interpreter work properly.", setting.getGroup()), (Throwable)e);
                    setting.setErrorReason(e.getLocalizedMessage());
                    setting.setStatus(InterpreterSetting.Status.ERROR);
                }
            }
        };
        t.start();
    }

    public List<String> getInterpreterSettingIds() {
        ArrayList<String> settingIdList = new ArrayList<String>();
        for (InterpreterSetting interpreterSetting : this.get()) {
            settingIdList.add(interpreterSetting.getId());
        }
        return settingIdList;
    }

    public InterpreterSetting createNewSetting(String name, String group, List<Dependency> dependencies, InterpreterOption option, Map<String, InterpreterProperty> p) throws IOException {
        if (name.indexOf(".") >= 0) {
            throw new IOException("'.' is invalid for InterpreterSetting name.");
        }
        for (InterpreterSetting interpreterSetting : this.interpreterSettings.values()) {
            if (!interpreterSetting.getName().equals(name)) continue;
            throw new IOException("Interpreter " + name + " already existed");
        }
        InterpreterSetting setting = new InterpreterSetting(this.interpreterSettingTemplates.get(group));
        setting.setName(name);
        setting.setGroup(group);
        setting.appendDependencies(dependencies);
        setting.setInterpreterOption(option);
        setting.setProperties(p);
        this.initInterpreterSetting(setting);
        this.interpreterSettings.put(setting.getId(), setting);
        this.saveToFile();
        return setting;
    }

    @VisibleForTesting
    public void addInterpreterSetting(InterpreterSetting interpreterSetting) {
        this.interpreterSettingTemplates.put(interpreterSetting.getName(), interpreterSetting);
        this.initInterpreterSetting(interpreterSetting);
        this.interpreterSettings.put(interpreterSetting.getId(), interpreterSetting);
    }

    public void setInterpreterBinding(String user, String noteId, List<String> settingIdList) throws IOException {
        LinkedList<String> unBindedSettingIdList = new LinkedList<String>();
        List<String> oldSettingIdList = this.interpreterBindings.get(noteId);
        if (oldSettingIdList != null) {
            for (String oldSettingId : oldSettingIdList) {
                if (settingIdList.contains(oldSettingId)) continue;
                unBindedSettingIdList.add(oldSettingId);
            }
        }
        this.interpreterBindings.put(noteId, settingIdList);
        this.saveToFile();
        for (String settingId : unBindedSettingIdList) {
            InterpreterSetting interpreterSetting = this.interpreterSettings.get(settingId);
            if (!interpreterSetting.getOption().perNoteIsolated() && !interpreterSetting.getOption().perNoteScoped()) continue;
            interpreterSetting.closeInterpreters(user, noteId);
        }
    }

    public List<String> getInterpreterBinding(String noteId) {
        return this.interpreterBindings.get(noteId);
    }

    @VisibleForTesting
    public void closeNote(String user, String noteId) {
        LOGGER.info("Close Note: {}", (Object)noteId);
        List<InterpreterSetting> settings = this.getInterpreterSettings(noteId);
        for (InterpreterSetting setting : settings) {
            setting.closeInterpreters(user, noteId);
        }
    }

    public Map<String, InterpreterSetting> getInterpreterSettingTemplates() {
        return this.interpreterSettingTemplates;
    }

    private URL[] recursiveBuildLibList(File path) throws MalformedURLException {
        Object[] urls = new URL[]{};
        if (path == null || !path.exists()) {
            return urls;
        }
        if (path.getName().startsWith(".")) {
            return urls;
        }
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File f : files) {
                    urls = (URL[])ArrayUtils.addAll((Object[])urls, (Object[])this.recursiveBuildLibList(f));
                }
            }
            return urls;
        }
        return new URL[]{path.toURI().toURL()};
    }

    public List<RemoteRepository> getRepositories() {
        return this.interpreterRepositories;
    }

    public void addRepository(String id, String url, boolean snapshot, Authentication auth, Proxy proxy) throws IOException {
        this.dependencyResolver.addRepo(id, url, snapshot, auth, proxy);
        this.saveToFile();
    }

    public void removeRepository(String id) throws IOException {
        this.dependencyResolver.delRepo(id);
        this.saveToFile();
    }

    public void removeNoteInterpreterSettingBinding(String user, String noteId) throws IOException {
        this.setInterpreterBinding(user, noteId, new ArrayList<String>());
        this.interpreterBindings.remove(noteId);
    }

    public void setPropertyAndRestart(String id, InterpreterOption option, Map<String, InterpreterProperty> properties, List<Dependency> dependencies) throws InterpreterException, IOException {
        InterpreterSetting intpSetting = this.interpreterSettings.get(id);
        if (intpSetting != null) {
            try {
                intpSetting.close();
                intpSetting.setOption(option);
                intpSetting.setProperties(properties);
                intpSetting.setDependencies(dependencies);
                intpSetting.postProcessing();
                this.saveToFile();
            }
            catch (Exception e) {
                this.loadFromFile();
                throw new IOException(e);
            }
        } else {
            throw new InterpreterException("Interpreter setting id " + id + " not found");
        }
    }

    public void restart(String settingId, String noteId, String user) throws InterpreterException {
        InterpreterSetting intpSetting = this.interpreterSettings.get(settingId);
        Preconditions.checkNotNull((Object)intpSetting);
        intpSetting = this.interpreterSettings.get(settingId);
        if (intpSetting == null) {
            throw new InterpreterException("Interpreter setting id " + settingId + " not found");
        }
        intpSetting.setInfos(null);
        this.copyDependenciesFromLocalPath(intpSetting);
        intpSetting.closeInterpreters(user, noteId);
    }

    public void restart(String id) throws InterpreterException {
        this.interpreterSettings.get(id).close();
    }

    public InterpreterSetting get(String id) {
        return this.interpreterSettings.get(id);
    }

    @VisibleForTesting
    public InterpreterSetting getByName(String name) {
        for (InterpreterSetting interpreterSetting : this.interpreterSettings.values()) {
            if (!interpreterSetting.getName().equals(name)) continue;
            return interpreterSetting;
        }
        throw new RuntimeException("No InterpreterSetting: " + name);
    }

    public void remove(String id) throws IOException {
        LOGGER.info("Remove interpreter setting: " + id);
        if (this.interpreterSettings.containsKey(id)) {
            InterpreterSetting intp = this.interpreterSettings.get(id);
            intp.close();
            this.interpreterSettings.remove(id);
            for (List<String> settings : this.interpreterBindings.values()) {
                Iterator<String> it = settings.iterator();
                while (it.hasNext()) {
                    String settingId = it.next();
                    if (!settingId.equals(id)) continue;
                    it.remove();
                }
            }
            this.saveToFile();
        }
        File localRepoDir = new File(this.conf.getInterpreterLocalRepoPath() + "/" + id);
        FileUtils.deleteDirectory((File)localRepoDir);
    }

    public List<InterpreterSetting> get() {
        ArrayList<InterpreterSetting> orderedSettings = new ArrayList<InterpreterSetting>(this.interpreterSettings.values());
        Collections.sort(orderedSettings, new Comparator<InterpreterSetting>(){

            @Override
            public int compare(InterpreterSetting o1, InterpreterSetting o2) {
                int i = InterpreterSettingManager.this.interpreterGroupOrderList.indexOf(o1.getGroup());
                int j = InterpreterSettingManager.this.interpreterGroupOrderList.indexOf(o2.getGroup());
                if (i < 0) {
                    LOGGER.warn("InterpreterGroup " + o1.getGroup() + " is not specified in " + ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_ORDER.getVarName());
                    i = Integer.MAX_VALUE;
                }
                if (j < 0) {
                    LOGGER.warn("InterpreterGroup " + o2.getGroup() + " is not specified in " + ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_ORDER.getVarName());
                    j = Integer.MAX_VALUE;
                }
                if (i < j) {
                    return -1;
                }
                if (i > j) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return orderedSettings;
    }

    @VisibleForTesting
    public List<String> getSettingIds() {
        ArrayList<String> settingIds = new ArrayList<String>();
        for (InterpreterSetting interpreterSetting : this.get()) {
            settingIds.add(interpreterSetting.getId());
        }
        return settingIds;
    }

    public void close(String settingId) {
        this.get(settingId).close();
    }

    public void close() {
        LinkedList<8> closeThreads = new LinkedList<8>();
        for (final InterpreterSetting interpreterSetting : this.interpreterSettings.values()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    interpreterSetting.close();
                }
            };
            t.start();
            closeThreads.add(t);
        }
        for (Thread thread : closeThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LOGGER.error("Can't close interpreterGroup", (Throwable)e);
            }
        }
    }

    @Override
    public Set<String> getRunningInterpreters() {
        HashSet runningInterpreters = Sets.newHashSet();
        for (Map.Entry<String, InterpreterSetting> entry : this.interpreterSettings.entrySet()) {
            for (ManagedInterpreterGroup mig : entry.getValue().getAllInterpreterGroups()) {
                if (null == mig.getRemoteInterpreterProcess()) continue;
                runningInterpreters.add(entry.getKey());
            }
        }
        return runningInterpreters;
    }
}

