/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedInterpreterGroup
extends InterpreterGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedInterpreterGroup.class);
    private InterpreterSetting interpreterSetting;
    private RemoteInterpreterProcess remoteInterpreterProcess;

    ManagedInterpreterGroup(String id, InterpreterSetting interpreterSetting) {
        super(id);
        this.interpreterSetting = interpreterSetting;
    }

    public InterpreterSetting getInterpreterSetting() {
        return this.interpreterSetting;
    }

    public synchronized RemoteInterpreterProcess getOrCreateInterpreterProcess(String userName, Properties properties) throws IOException {
        if (this.remoteInterpreterProcess == null) {
            LOGGER.info("Create InterpreterProcess for InterpreterGroup: " + this.getId());
            this.remoteInterpreterProcess = this.interpreterSetting.createInterpreterProcess(this.id, userName, properties);
            this.remoteInterpreterProcess.start(userName);
            this.interpreterSetting.getLifecycleManager().onInterpreterProcessStarted(this);
            this.remoteInterpreterProcess.getRemoteInterpreterEventPoller().setInterpreterProcess(this.remoteInterpreterProcess);
            this.remoteInterpreterProcess.getRemoteInterpreterEventPoller().setInterpreterGroup(this);
            this.remoteInterpreterProcess.getRemoteInterpreterEventPoller().start();
            this.getInterpreterSetting().getRecoveryStorage().onInterpreterClientStart((InterpreterClient)this.remoteInterpreterProcess);
        }
        return this.remoteInterpreterProcess;
    }

    public RemoteInterpreterProcess getInterpreterProcess() {
        return this.remoteInterpreterProcess;
    }

    public RemoteInterpreterProcess getRemoteInterpreterProcess() {
        return this.remoteInterpreterProcess;
    }

    public synchronized void close() {
        LOGGER.info("Close InterpreterGroup: " + this.id);
        for (String sessionId : this.sessions.keySet()) {
            this.close(sessionId);
        }
    }

    public synchronized void close(String sessionId) {
        LOGGER.info("Close Session: " + sessionId + " for interpreter setting: " + this.interpreterSetting.getName());
        this.close((Collection)this.sessions.remove(sessionId));
        if (this.sessions.isEmpty() && this.interpreterSetting != null) {
            LOGGER.info("Remove this InterpreterGroup: {} as all the sessions are closed", (Object)this.id);
            this.interpreterSetting.removeInterpreterGroup(this.id);
            if (this.remoteInterpreterProcess != null) {
                LOGGER.info("Kill RemoteInterpreterProcess");
                this.remoteInterpreterProcess.stop();
                try {
                    this.interpreterSetting.getRecoveryStorage().onInterpreterClientStop((InterpreterClient)this.remoteInterpreterProcess);
                }
                catch (IOException e) {
                    LOGGER.error("Fail to store recovery data", (Throwable)e);
                }
                this.remoteInterpreterProcess = null;
            }
        }
    }

    private void close(Collection<Interpreter> interpreters) {
        if (interpreters == null) {
            return;
        }
        for (Interpreter interpreter : interpreters) {
            Scheduler scheduler = interpreter.getScheduler();
            for (Job job : scheduler.getJobsRunning()) {
                job.abort();
                job.setStatus(Job.Status.ABORT);
                LOGGER.info("Job " + job.getJobName() + " aborted ");
            }
            for (Job job : scheduler.getJobsWaiting()) {
                job.abort();
                job.setStatus(Job.Status.ABORT);
                LOGGER.info("Job " + job.getJobName() + " aborted ");
            }
            try {
                interpreter.close();
            }
            catch (InterpreterException e) {
                LOGGER.warn("Fail to close interpreter " + interpreter.getClassName(), (Throwable)e);
            }
            if (null == scheduler) continue;
            SchedulerFactory.singleton().removeScheduler(scheduler.getName());
        }
    }

    public synchronized List<Interpreter> getOrCreateSession(String user, String sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            return (List)this.sessions.get(sessionId);
        }
        List<Interpreter> interpreters = this.interpreterSetting.createInterpreters(user, this.id, sessionId);
        for (Interpreter interpreter : interpreters) {
            interpreter.setInterpreterGroup((InterpreterGroup)this);
        }
        LOGGER.info("Create Session: {} in InterpreterGroup: {} for user: {}", new Object[]{sessionId, this.id, user});
        this.sessions.put(sessionId, interpreters);
        return interpreters;
    }
}

