/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.install;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.util.Util;
import org.sonatype.aether.RepositoryException;

public class InstallInterpreter {
    private final File interpreterListFile;
    private final File interpreterBaseDir;
    private final List<AvailableInterpreterInfo> availableInterpreters;
    private final String localRepoDir;
    private URL proxyUrl;
    private String proxyUser;
    private String proxyPassword;

    public InstallInterpreter(File interpreterListFile, File interpreterBaseDir, String localRepoDir) throws IOException {
        this.interpreterListFile = interpreterListFile;
        this.interpreterBaseDir = interpreterBaseDir;
        this.localRepoDir = localRepoDir;
        this.availableInterpreters = new LinkedList<AvailableInterpreterInfo>();
        this.readAvailableInterpreters();
    }

    private void readAvailableInterpreters() throws IOException {
        if (!this.interpreterListFile.isFile()) {
            System.err.println("Can't find interpreter list " + this.interpreterListFile.getAbsolutePath());
            return;
        }
        String text = FileUtils.readFileToString((File)this.interpreterListFile);
        String[] lines = text.split("\n");
        Pattern pattern = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(.*)");
        int lineNo = 0;
        for (String line : lines) {
            ++lineNo;
            if (line == null || line.length() == 0 || line.startsWith("#")) continue;
            Matcher match = pattern.matcher(line);
            if (match.groupCount() != 3) {
                System.err.println("Error on line " + lineNo + ", " + line);
                continue;
            }
            match.find();
            String name = match.group(1);
            String artifact = match.group(2);
            String description = match.group(3);
            this.availableInterpreters.add(new AvailableInterpreterInfo(name, artifact, description));
        }
    }

    public List<AvailableInterpreterInfo> list() {
        for (AvailableInterpreterInfo info : this.availableInterpreters) {
            System.out.println(info.name + "\t\t\t" + info.description);
        }
        return this.availableInterpreters;
    }

    public void installAll() {
        for (AvailableInterpreterInfo info : this.availableInterpreters) {
            this.install(info.name, info.artifact);
        }
    }

    public void install(String[] names) {
        for (String name : names) {
            this.install(name);
        }
    }

    public void install(String name) {
        for (AvailableInterpreterInfo info : this.availableInterpreters) {
            if (!name.equals(info.name)) continue;
            this.install(name, info.artifact);
            return;
        }
        throw new RuntimeException("Can't find interpreter '" + name + "'");
    }

    public void install(String[] names, String[] artifacts) {
        if (names.length != artifacts.length) {
            throw new RuntimeException("Length of given names and artifacts are different");
        }
        for (int i = 0; i < names.length; ++i) {
            this.install(names[i], artifacts[i]);
        }
    }

    public void install(String name, String artifact) {
        File installDir;
        DependencyResolver depResolver = new DependencyResolver(this.localRepoDir);
        if (this.proxyUrl != null) {
            depResolver.setProxy(this.proxyUrl, this.proxyUser, this.proxyPassword);
        }
        if ((installDir = new File(this.interpreterBaseDir, name)).exists()) {
            System.err.println("Directory " + installDir.getAbsolutePath() + " already exists\n\nSkipped");
            return;
        }
        System.out.println("Install " + name + "(" + artifact + ") to " + installDir.getAbsolutePath() + " ... ");
        try {
            depResolver.load(artifact, installDir);
            System.out.println("Interpreter " + name + " installed under " + installDir.getAbsolutePath() + ".");
            InstallInterpreter.startTip();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setProxy(URL proxyUrl, String proxyUser, String proxyPassword) {
        this.proxyUrl = proxyUrl;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
    }

    public static void usage() {
        System.out.println("Options");
        System.out.println("  -l, --list                   List available interpreters");
        System.out.println("  -a, --all                    Install all available interpreters");
        System.out.println("  -n, --name       [NAMES]     Install interpreters (comma separated list)e.g. md,shell,jdbc,python,angular");
        System.out.println("  -t, --artifact   [ARTIFACTS] (Optional with -n) custom artifact names. (comma separated list correspond to --name) e.g. customGroup:customArtifact:customVersion");
        System.out.println("  --proxy-url      [url]       (Optional) proxy url. http(s)://host:port");
        System.out.println("  --proxy-user     [user]      (Optional) proxy user");
        System.out.println("  --proxy-password [password]  (Optional) proxy password");
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            InstallInterpreter.usage();
            return;
        }
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        InstallInterpreter installer = new InstallInterpreter(new File(conf.getInterpreterListPath()), new File(conf.getInterpreterDir()), conf.getInterpreterLocalRepoPath());
        String names = null;
        String artifacts = null;
        URL proxyUrl = null;
        String proxyUser = null;
        String proxyPassword = null;
        boolean all = false;
        block28: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i].toLowerCase(Locale.US)) {
                case "--list": 
                case "-l": {
                    installer.list();
                    System.exit(0);
                    continue block28;
                }
                case "--all": 
                case "-a": {
                    all = true;
                    continue block28;
                }
                case "--name": 
                case "-n": {
                    names = args[++i];
                    continue block28;
                }
                case "--artifact": 
                case "-t": {
                    artifacts = args[++i];
                    continue block28;
                }
                case "--version": 
                case "-v": {
                    Util.getVersion();
                    continue block28;
                }
                case "--proxy-url": {
                    proxyUrl = new URL(args[++i]);
                    continue block28;
                }
                case "--proxy-user": {
                    proxyUser = args[++i];
                    continue block28;
                }
                case "--proxy-password": {
                    proxyPassword = args[++i];
                    continue block28;
                }
                case "--help": 
                case "-h": {
                    InstallInterpreter.usage();
                    System.exit(0);
                    continue block28;
                }
                default: {
                    System.out.println("Unknown option " + arg);
                }
            }
        }
        if (proxyUrl != null) {
            installer.setProxy(proxyUrl, proxyUser, proxyPassword);
        }
        if (all) {
            installer.installAll();
            System.exit(0);
        }
        if (names != null) {
            if (artifacts != null) {
                installer.install(names.split(","), artifacts.split(","));
            } else {
                installer.install(names.split(","));
            }
        }
    }

    private static void startTip() {
        System.out.println("\n1. Restart Zeppelin\n2. Create interpreter setting in 'Interpreter' menu on Zeppelin GUI\n3. Then you can bind the interpreter on your note");
    }

    private static class AvailableInterpreterInfo {
        public final String name;
        public final String artifact;
        public final String description;

        public AvailableInterpreterInfo(String name, String artifact, String description) {
            this.name = name;
            this.artifact = artifact;
            this.description = description;
        }
    }
}

