/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.InterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterManagedProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterRunningProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellScriptLauncher
extends InterpreterLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellScriptLauncher.class);

    public ShellScriptLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    public InterpreterClient launch(InterpreterLaunchContext context) throws IOException {
        InterpreterClient recoveredClient;
        LOGGER.info("Launching Interpreter: " + context.getInterpreterSettingGroup());
        this.properties = context.getProperties();
        InterpreterOption option = context.getOption();
        InterpreterRunner runner = context.getRunner();
        String groupName = context.getInterpreterSettingGroup();
        String name = context.getInterpreterSettingName();
        int connectTimeout = this.zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT);
        if (option.isExistingProcess()) {
            return new RemoteInterpreterRunningProcess(context.getInterpreterSettingName(), connectTimeout, option.getHost(), option.getPort());
        }
        if (this.zConf.isRecoveryEnabled() && (recoveredClient = this.recoveryStorage.getInterpreterClient(context.getInterpreterGroupId())) != null) {
            if (recoveredClient.isRunning()) {
                LOGGER.info("Recover interpreter process: " + recoveredClient.getHost() + ":" + recoveredClient.getPort());
                return recoveredClient;
            }
            LOGGER.warn("Cannot recover interpreter process: " + recoveredClient.getHost() + ":" + recoveredClient.getPort() + ", as it is already terminated.");
        }
        String localRepoPath = this.zConf.getInterpreterLocalRepoPath() + "/" + context.getInterpreterSettingId();
        return new RemoteInterpreterManagedProcess(runner != null ? runner.getPath() : this.zConf.getInterpreterRemoteRunnerPath(), this.zConf.getCallbackPortRange(), this.zConf.getInterpreterPortRange(), this.zConf.getInterpreterDir() + "/" + groupName, localRepoPath, this.buildEnvFromProperties(context), connectTimeout, name, option.isUserImpersonate());
    }

    protected Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) {
        HashMap<String, String> env = new HashMap<String, String>();
        for (Object key : context.getProperties().keySet()) {
            if (!RemoteInterpreterUtils.isEnvString((String)((String)key))) continue;
            env.put((String)key, context.getProperties().getProperty((String)key));
        }
        return env;
    }
}

