/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.ShellScriptLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkInterpreterLauncher
extends ShellScriptLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkInterpreterLauncher.class);

    public SparkInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    @Override
    protected Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) {
        HashMap<String, String> env = new HashMap<String, String>();
        Properties sparkProperties = new Properties();
        String sparkMaster = this.getSparkMaster(this.properties);
        for (String string : this.properties.stringPropertyNames()) {
            if (RemoteInterpreterUtils.isEnvString((String)string)) {
                env.put(string, this.properties.getProperty(string));
            }
            if (!this.isSparkConf(string, this.properties.getProperty(string))) continue;
            sparkProperties.setProperty(string, this.toShellFormat(this.properties.getProperty(string)));
        }
        this.setupPropertiesForPySpark(sparkProperties);
        this.setupPropertiesForSparkR(sparkProperties);
        if (this.isYarnMode() && this.getDeployMode().equals("cluster")) {
            env.put("ZEPPELIN_SPARK_YARN_CLUSTER", "true");
        }
        StringBuilder sparkConfBuilder = new StringBuilder();
        if (sparkMaster != null) {
            sparkConfBuilder.append(" --master " + sparkMaster);
        }
        if (this.isYarnMode() && this.getDeployMode().equals("cluster")) {
            if (sparkProperties.containsKey("spark.files")) {
                sparkProperties.put("spark.files", sparkProperties.getProperty("spark.files") + "," + this.zConf.getConfDir() + "/log4j_yarn_cluster.properties");
            } else {
                sparkProperties.put("spark.files", this.zConf.getConfDir() + "/log4j_yarn_cluster.properties");
            }
        }
        for (String string : sparkProperties.stringPropertyNames()) {
            sparkConfBuilder.append(" --conf " + string + "=" + sparkProperties.getProperty(string));
        }
        String string = System.getenv("ZEPPELIN_IMPERSONATE_SPARK_PROXY_USER");
        if (context.getOption().isUserImpersonate() && (StringUtils.isBlank((CharSequence)string) || !string.equals("false"))) {
            sparkConfBuilder.append(" --proxy-user " + context.getUserName());
        }
        env.put("ZEPPELIN_SPARK_CONF", sparkConfBuilder.toString());
        for (String envName : new String[]{"SPARK_HOME", "SPARK_CONF_DIR", "HADOOP_CONF_DIR"}) {
            String envValue = this.getEnv(envName);
            if (envValue == null) continue;
            env.put(envName, envValue);
        }
        String string2 = this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_KEYTAB);
        String principal = this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_KERBEROS_PRINCIPAL);
        if (!StringUtils.isBlank((CharSequence)string2) && !StringUtils.isBlank((CharSequence)principal)) {
            env.put("ZEPPELIN_SERVER_KERBEROS_KEYTAB", string2);
            env.put("ZEPPELIN_SERVER_KERBEROS_PRINCIPAL", principal);
            LOGGER.info("Run Spark under secure mode with keytab: " + string2 + ", principal: " + principal);
        } else {
            LOGGER.info("Run Spark under non-secure mode as no keytab and principal is specified");
        }
        LOGGER.debug("buildEnvFromProperties: " + env);
        return env;
    }

    private String getEnv(String envName) {
        String env = this.properties.getProperty(envName);
        if (env == null) {
            env = System.getenv(envName);
        }
        return env;
    }

    private boolean isSparkConf(String key, String value) {
        return !StringUtils.isEmpty((CharSequence)key) && key.startsWith("spark.") && !StringUtils.isEmpty((CharSequence)value);
    }

    private void setupPropertiesForPySpark(Properties sparkProperties) {
        if (this.isYarnMode()) {
            sparkProperties.setProperty("spark.yarn.isPython", "true");
        }
    }

    private void mergeSparkProperty(Properties sparkProperties, String propertyName, String propertyValue) {
        if (sparkProperties.containsKey(propertyName)) {
            String oldPropertyValue = sparkProperties.getProperty(propertyName);
            sparkProperties.setProperty(propertyName, oldPropertyValue + "," + propertyValue);
        } else {
            sparkProperties.setProperty(propertyName, propertyValue);
        }
    }

    private void setupPropertiesForSparkR(Properties sparkProperties) {
        String sparkHome = this.getEnv("SPARK_HOME");
        File sparkRBasePath = null;
        if (sparkHome == null) {
            if (!this.getSparkMaster(this.properties).startsWith("local")) {
                throw new RuntimeException("SPARK_HOME is not specified in interpreter-setting for non-local mode, if you specify it in zeppelin-env.sh, please move that into  interpreter setting");
            }
            String zeppelinHome = this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_HOME);
            sparkRBasePath = new File(zeppelinHome, "interpreter" + File.separator + "spark" + File.separator + "R");
        } else {
            sparkRBasePath = new File(sparkHome, "R" + File.separator + "lib");
        }
        File sparkRPath = new File(sparkRBasePath, "sparkr.zip");
        if (sparkRPath.exists() && sparkRPath.isFile()) {
            this.mergeSparkProperty(sparkProperties, "spark.yarn.dist.archives", sparkRPath.getAbsolutePath() + "#sparkr");
        } else {
            LOGGER.warn("sparkr.zip is not found, SparkR may not work.");
        }
    }

    private String getSparkMaster(Properties properties) {
        String master = properties.getProperty("master");
        if (master == null && (master = properties.getProperty("spark.master")) == null) {
            master = "local[*]";
        }
        return master;
    }

    private String getDeployMode() {
        String master = this.getSparkMaster(this.properties);
        if (master.equals("yarn-client")) {
            return "client";
        }
        if (master.equals("yarn-cluster")) {
            return "cluster";
        }
        if (master.startsWith("local")) {
            return "client";
        }
        String deployMode = this.properties.getProperty("spark.submit.deployMode");
        if (deployMode == null) {
            throw new RuntimeException("master is set as yarn, but spark.submit.deployMode is not specified");
        }
        if (!deployMode.equals("client") && !deployMode.equals("cluster")) {
            throw new RuntimeException("Invalid value for spark.submit.deployMode: " + deployMode);
        }
        return deployMode;
    }

    private boolean isYarnMode() {
        return this.getSparkMaster(this.properties).startsWith("yarn");
    }

    private String toShellFormat(String value) {
        if (value.contains("'") && value.contains("\"")) {
            throw new RuntimeException("Spark property value could not contain both \" and '");
        }
        if (value.contains("'")) {
            return "\"" + value + "\"";
        }
        return "'" + value + "'";
    }
}

