/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.lifecycle;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.LifecycleManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutLifecycleManager
implements LifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutLifecycleManager.class);
    private Map<ManagedInterpreterGroup, Long> interpreterGroups = new ConcurrentHashMap<ManagedInterpreterGroup, Long>();
    private long checkInterval;
    private long timeoutThreshold;
    private Timer checkTimer;

    public TimeoutLifecycleManager(ZeppelinConfiguration zConf) {
        this.checkInterval = zConf.getLong(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LIFECYCLE_MANAGER_TIMEOUT_CHECK_INTERVAL);
        this.timeoutThreshold = zConf.getLong(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_LIFECYCLE_MANAGER_TIMEOUT_THRESHOLD);
        this.checkTimer = new Timer(true);
        this.checkTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                for (Map.Entry entry : TimeoutLifecycleManager.this.interpreterGroups.entrySet()) {
                    ManagedInterpreterGroup interpreterGroup = (ManagedInterpreterGroup)((Object)entry.getKey());
                    Long lastTimeUsing = (Long)entry.getValue();
                    if (now - lastTimeUsing <= TimeoutLifecycleManager.this.timeoutThreshold) continue;
                    LOGGER.info("InterpreterGroup {} is timeout.", (Object)interpreterGroup.getId());
                    interpreterGroup.close();
                    TimeoutLifecycleManager.this.interpreterGroups.remove(entry.getKey());
                }
            }
        }, this.checkInterval, this.checkInterval);
        LOGGER.info("TimeoutLifecycleManager is started with checkinterval: " + this.checkInterval + ", timeoutThreshold: " + this.timeoutThreshold);
    }

    @Override
    public void onInterpreterProcessStarted(ManagedInterpreterGroup interpreterGroup) {
        LOGGER.info("Process of InterpreterGroup {} is started", (Object)interpreterGroup.getId());
        this.interpreterGroups.put(interpreterGroup, System.currentTimeMillis());
    }

    @Override
    public void onInterpreterUse(ManagedInterpreterGroup interpreterGroup, String sessionId) {
        LOGGER.debug("InterpreterGroup {} is used in session {}", (Object)interpreterGroup.getId(), (Object)sessionId);
        this.interpreterGroups.put(interpreterGroup, System.currentTimeMillis());
    }
}

