/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventPoller;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterRunningProcess;
import org.apache.zeppelin.notebook.FileSystemStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRecoveryStorage
extends RecoveryStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemRecoveryStorage.class);
    private InterpreterSettingManager interpreterSettingManager;
    private FileSystemStorage fs;
    private Path recoveryDir;

    public FileSystemRecoveryStorage(ZeppelinConfiguration zConf, InterpreterSettingManager interpreterSettingManager) throws IOException {
        super(zConf);
        this.interpreterSettingManager = interpreterSettingManager;
        this.zConf = zConf;
        this.fs = new FileSystemStorage(zConf, zConf.getRecoveryDir());
        LOGGER.info("Creating FileSystem: " + this.fs.getFs().getClass().getName() + " for Zeppelin Recovery.");
        this.recoveryDir = this.fs.makeQualified(new Path(zConf.getRecoveryDir()));
        LOGGER.info("Using folder {} to store recovery data", (Object)this.recoveryDir);
        this.fs.tryMkDir(this.recoveryDir);
    }

    public void onInterpreterClientStart(InterpreterClient client) throws IOException {
        this.save(client.getInterpreterSettingName());
    }

    public void onInterpreterClientStop(InterpreterClient client) throws IOException {
        this.save(client.getInterpreterSettingName());
    }

    private void save(String interpreterSettingName) throws IOException {
        InterpreterSetting interpreterSetting = this.interpreterSettingManager.getInterpreterSettingByName(interpreterSettingName);
        ArrayList<String> recoveryContent = new ArrayList<String>();
        for (ManagedInterpreterGroup interpreterGroup : interpreterSetting.getAllInterpreterGroups()) {
            RemoteInterpreterProcess interpreterProcess = interpreterGroup.getInterpreterProcess();
            if (interpreterProcess == null) continue;
            recoveryContent.add(interpreterGroup.getId() + "\t" + interpreterProcess.getHost() + ":" + interpreterProcess.getPort());
        }
        LOGGER.debug("Updating recovery data for interpreterSetting: " + interpreterSettingName);
        LOGGER.debug("Recovery Data: " + StringUtils.join(recoveryContent, (String)System.lineSeparator()));
        Path recoveryFile = new Path(this.recoveryDir, interpreterSettingName + ".recovery");
        this.fs.writeFile(StringUtils.join(recoveryContent, (String)System.lineSeparator()), recoveryFile, true);
    }

    public Map<String, InterpreterClient> restore() throws IOException {
        HashMap<String, InterpreterClient> clients = new HashMap<String, InterpreterClient>();
        List<Path> paths = this.fs.list(new Path(this.recoveryDir + "/*.recovery"));
        for (Path path : paths) {
            String fileName = path.getName();
            String interpreterSettingName = fileName.substring(0, fileName.length() - ".recovery".length());
            String recoveryContent = this.fs.readFile(path);
            if (StringUtils.isBlank((String)recoveryContent)) continue;
            for (String line : recoveryContent.split(System.lineSeparator())) {
                String[] tokens = line.split("\t");
                String groupId = tokens[0];
                String[] hostPort = tokens[1].split(":");
                int connectTimeout = this.zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_CONNECT_TIMEOUT);
                RemoteInterpreterRunningProcess client = new RemoteInterpreterRunningProcess(interpreterSettingName, connectTimeout, hostPort[0], Integer.parseInt(hostPort[1]));
                if (this.interpreterSettingManager != null) {
                    client.setRemoteInterpreterEventPoller(new RemoteInterpreterEventPoller(this.interpreterSettingManager.getRemoteInterpreterProcessListener(), this.interpreterSettingManager.getAppEventListener()));
                }
                clients.put(groupId, client);
                LOGGER.info("Recovering Interpreter Process: " + hostPort[0] + ":" + hostPort[1]);
            }
        }
        return clients;
    }
}

