/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import java.util.List;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObject;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAngularObjectRegistry
extends AngularObjectRegistry {
    Logger logger = LoggerFactory.getLogger(RemoteAngularObjectRegistry.class);
    private ManagedInterpreterGroup interpreterGroup;

    public RemoteAngularObjectRegistry(String interpreterId, AngularObjectRegistryListener listener, ManagedInterpreterGroup interpreterGroup) {
        super(interpreterId, listener);
        this.interpreterGroup = interpreterGroup;
    }

    private RemoteInterpreterProcess getRemoteInterpreterProcess() {
        return this.interpreterGroup.getRemoteInterpreterProcess();
    }

    public AngularObject addAndNotifyRemoteProcess(final String name, final Object o, final String noteId, final String paragraphId) {
        RemoteInterpreterProcess remoteInterpreterProcess = this.getRemoteInterpreterProcess();
        if (!remoteInterpreterProcess.isRunning()) {
            return super.add(name, o, noteId, paragraphId, true);
        }
        remoteInterpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

            @Override
            public Void call(RemoteInterpreterService.Client client) throws Exception {
                Gson gson = new Gson();
                client.angularObjectAdd(name, noteId, paragraphId, gson.toJson(o));
                return null;
            }
        });
        return super.add(name, o, noteId, paragraphId, true);
    }

    public AngularObject removeAndNotifyRemoteProcess(final String name, final String noteId, final String paragraphId) {
        RemoteInterpreterProcess remoteInterpreterProcess = this.getRemoteInterpreterProcess();
        if (remoteInterpreterProcess == null || !remoteInterpreterProcess.isRunning()) {
            return super.remove(name, noteId, paragraphId);
        }
        remoteInterpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

            @Override
            public Void call(RemoteInterpreterService.Client client) throws Exception {
                client.angularObjectRemove(name, noteId, paragraphId);
                return null;
            }
        });
        return super.remove(name, noteId, paragraphId);
    }

    public void removeAllAndNotifyRemoteProcess(String noteId, String paragraphId) {
        List all = this.getAll(noteId, paragraphId);
        for (AngularObject ao : all) {
            this.removeAndNotifyRemoteProcess(ao.getName(), noteId, paragraphId);
        }
    }

    protected AngularObject createNewAngularObject(String name, Object o, String noteId, String paragraphId) {
        return new RemoteAngularObject(name, o, noteId, paragraphId, this.interpreterGroup, this.getAngularObjectListener());
    }
}

