/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.RemoteZeppelinServerResource;
import org.apache.zeppelin.interpreter.remote.AppendOutputRunner;
import org.apache.zeppelin.interpreter.remote.InvokeResourceMethodEventMessage;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObject;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterContextRunner;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEvent;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEventType;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.interpreter.thrift.ZeppelinServerResourceParagraphRunner;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourceId;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterEventPoller
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInterpreterEventPoller.class);
    private final ScheduledExecutorService appendService = Executors.newSingleThreadScheduledExecutor();
    private final RemoteInterpreterProcessListener listener;
    private final ApplicationEventListener appListener;
    private volatile boolean shutdown;
    private RemoteInterpreterProcess interpreterProcess;
    private ManagedInterpreterGroup interpreterGroup;
    Gson gson = new Gson();

    public RemoteInterpreterEventPoller(RemoteInterpreterProcessListener listener, ApplicationEventListener appListener) {
        this.listener = listener;
        this.appListener = appListener;
        this.shutdown = false;
    }

    public void setInterpreterProcess(RemoteInterpreterProcess interpreterProcess) {
        this.interpreterProcess = interpreterProcess;
    }

    public void setInterpreterGroup(ManagedInterpreterGroup interpreterGroup) {
        this.interpreterGroup = interpreterGroup;
    }

    @Override
    public void run() {
        AppendOutputRunner runner = new AppendOutputRunner(this.listener);
        ScheduledFuture<?> appendFuture = this.appendService.scheduleWithFixedDelay(runner, 0L, AppendOutputRunner.BUFFER_TIME_MS, TimeUnit.MILLISECONDS);
        while (!this.shutdown) {
            if (!this.interpreterProcess.isRunning()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            RemoteInterpreterEvent event = this.interpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<RemoteInterpreterEvent>(){

                @Override
                public RemoteInterpreterEvent call(RemoteInterpreterService.Client client) throws Exception {
                    return client.getEvent();
                }
            });
            AngularObjectRegistry angularObjectRegistry = this.interpreterGroup.getAngularObjectRegistry();
            try {
                String paragraphId;
                String noteId;
                Map outputAppend;
                AngularObject angularObject;
                if (event.getType() != RemoteInterpreterEventType.NO_OP) {
                    logger.debug("Receive message from RemoteInterpreter Process: " + event.toString());
                }
                if (event.getType() == RemoteInterpreterEventType.NO_OP) continue;
                if (event.getType() == RemoteInterpreterEventType.ANGULAR_OBJECT_ADD) {
                    angularObject = AngularObject.fromJson((String)event.getData());
                    angularObjectRegistry.add(angularObject.getName(), angularObject.get(), angularObject.getNoteId(), angularObject.getParagraphId());
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.ANGULAR_OBJECT_UPDATE) {
                    angularObject = AngularObject.fromJson((String)event.getData());
                    AngularObject localAngularObject = angularObjectRegistry.get(angularObject.getName(), angularObject.getNoteId(), angularObject.getParagraphId());
                    if (localAngularObject instanceof RemoteAngularObject) {
                        ((RemoteAngularObject)localAngularObject).set(angularObject.get(), true, false);
                        continue;
                    }
                    localAngularObject.set(angularObject.get());
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.ANGULAR_OBJECT_REMOVE) {
                    angularObject = AngularObject.fromJson((String)event.getData());
                    angularObjectRegistry.remove(angularObject.getName(), angularObject.getNoteId(), angularObject.getParagraphId());
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.RUN_INTERPRETER_CONTEXT_RUNNER) {
                    InterpreterContextRunner runnerFromRemote = (InterpreterContextRunner)this.gson.fromJson(event.getData(), RemoteInterpreterContextRunner.class);
                    this.listener.onRemoteRunParagraph(runnerFromRemote.getNoteId(), runnerFromRemote.getParagraphId());
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.RESOURCE_POOL_GET_ALL) {
                    ResourceSet resourceSet = this.getAllResourcePoolExcept();
                    this.sendResourcePoolResponseGetAll(resourceSet);
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.RESOURCE_GET) {
                    String resourceIdString = event.getData();
                    ResourceId resourceId = ResourceId.fromJson((String)resourceIdString);
                    logger.debug("RESOURCE_GET {} {}", (Object)resourceId.getResourcePoolId(), (Object)resourceId.getName());
                    Object o = this.getResource(resourceId);
                    this.sendResourceResponseGet(resourceId, o);
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.RESOURCE_INVOKE_METHOD) {
                    String message = event.getData();
                    InvokeResourceMethodEventMessage invokeMethodMessage = InvokeResourceMethodEventMessage.fromJson((String)message);
                    Object ret = this.invokeResourceMethod(invokeMethodMessage);
                    this.sendInvokeMethodResult(invokeMethodMessage, ret);
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.OUTPUT_APPEND) {
                    outputAppend = (Map)this.gson.fromJson(event.getData(), new TypeToken<Map<String, Object>>(){}.getType());
                    noteId = (String)outputAppend.get("noteId");
                    paragraphId = (String)outputAppend.get("paragraphId");
                    int index = Integer.parseInt((String)outputAppend.get("index"));
                    String outputToAppend = (String)outputAppend.get("data");
                    String appId = (String)outputAppend.get("appId");
                    if (appId == null) {
                        runner.appendBuffer(noteId, paragraphId, index, outputToAppend);
                        continue;
                    }
                    this.appListener.onOutputAppend(noteId, paragraphId, index, appId, outputToAppend);
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.OUTPUT_UPDATE_ALL) {
                    Map outputUpdate = (Map)this.gson.fromJson(event.getData(), new TypeToken<Map<String, Object>>(){}.getType());
                    noteId = (String)outputUpdate.get("noteId");
                    paragraphId = (String)outputUpdate.get("paragraphId");
                    List messages = (List)outputUpdate.get("messages");
                    if (messages == null) continue;
                    this.listener.onOutputClear(noteId, paragraphId);
                    for (int i = 0; i < messages.size(); ++i) {
                        Map m = (Map)messages.get(i);
                        InterpreterResult.Type type = InterpreterResult.Type.valueOf((String)((String)m.get("type")));
                        String outputToUpdate = (String)m.get("data");
                        this.listener.onOutputUpdated(noteId, paragraphId, i, type, outputToUpdate);
                    }
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.OUTPUT_UPDATE) {
                    outputAppend = (Map)this.gson.fromJson(event.getData(), new TypeToken<Map<String, Object>>(){}.getType());
                    noteId = (String)outputAppend.get("noteId");
                    paragraphId = (String)outputAppend.get("paragraphId");
                    int index = Integer.parseInt((String)outputAppend.get("index"));
                    InterpreterResult.Type type = InterpreterResult.Type.valueOf((String)((String)outputAppend.get("type")));
                    String outputToUpdate = (String)outputAppend.get("data");
                    String appId = (String)outputAppend.get("appId");
                    if (appId == null) {
                        this.listener.onOutputUpdated(noteId, paragraphId, index, type, outputToUpdate);
                        continue;
                    }
                    this.appListener.onOutputUpdated(noteId, paragraphId, index, appId, type, outputToUpdate);
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.APP_STATUS_UPDATE) {
                    Map appStatusUpdate = (Map)this.gson.fromJson(event.getData(), new TypeToken<Map<String, String>>(){}.getType());
                    noteId = (String)appStatusUpdate.get("noteId");
                    paragraphId = (String)appStatusUpdate.get("paragraphId");
                    String appId = (String)appStatusUpdate.get("appId");
                    String status = (String)appStatusUpdate.get("status");
                    this.appListener.onStatusChange(noteId, paragraphId, appId, status);
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.REMOTE_ZEPPELIN_SERVER_RESOURCE) {
                    RemoteZeppelinServerResource reqResourceBody = RemoteZeppelinServerResource.fromJson((String)event.getData());
                    this.progressRemoteZeppelinControlEvent(reqResourceBody.getResourceType(), this.listener, reqResourceBody);
                    continue;
                }
                if (event.getType() == RemoteInterpreterEventType.META_INFOS) {
                    Map metaInfos = (Map)this.gson.fromJson(event.getData(), new TypeToken<Map<String, String>>(){}.getType());
                    String settingId = RemoteInterpreterUtils.getInterpreterSettingId((String)this.interpreterGroup.getId());
                    this.listener.onMetaInfosReceived(settingId, metaInfos);
                    continue;
                }
                if (event.getType() != RemoteInterpreterEventType.PARA_INFOS) continue;
                Map paraInfos = (Map)this.gson.fromJson(event.getData(), new TypeToken<Map<String, String>>(){}.getType());
                noteId = (String)paraInfos.get("noteId");
                String paraId = (String)paraInfos.get("paraId");
                String settingId = RemoteInterpreterUtils.getInterpreterSettingId((String)this.interpreterGroup.getId());
                if (noteId == null || paraId == null || settingId == null) continue;
                this.listener.onParaInfosReceived(noteId, paraId, settingId, paraInfos);
            }
            catch (Exception e) {
                logger.error("Can't handle event " + event, (Throwable)e);
            }
        }
        try {
            this.clearUnreadEvents(this.interpreterProcess.getClient());
        }
        catch (Exception e1) {
            if (this.shutdown) {
                logger.error("Can not get RemoteInterpreterEvent because it is shutdown.");
            }
            logger.error("Can't get RemoteInterpreterEvent", (Throwable)e1);
        }
        if (appendFuture != null) {
            appendFuture.cancel(true);
        }
    }

    private void clearUnreadEvents(RemoteInterpreterService.Client client) throws TException {
        while (client.getEvent().getType() != RemoteInterpreterEventType.NO_OP) {
        }
    }

    private void progressRemoteZeppelinControlEvent(RemoteZeppelinServerResource.Type resourceType, RemoteInterpreterProcessListener remoteWorksEventListener, RemoteZeppelinServerResource reqResourceBody) throws Exception {
        boolean broken = false;
        Gson gson = new Gson();
        final String eventOwnerKey = reqResourceBody.getOwnerKey();
        try {
            if (resourceType == RemoteZeppelinServerResource.Type.PARAGRAPH_RUNNERS) {
                final LinkedList remoteRunners = new LinkedList();
                ZeppelinServerResourceParagraphRunner reqRunnerContext = new ZeppelinServerResourceParagraphRunner();
                Map reqResourceMap = (Map)reqResourceBody.getData();
                String noteId = (String)reqResourceMap.get("noteId");
                String paragraphId = (String)reqResourceMap.get("paragraphId");
                reqRunnerContext.setNoteId(noteId);
                reqRunnerContext.setParagraphId(paragraphId);
                RemoteInterpreterProcessListener.RemoteWorksEventListener callBackEvent = new RemoteInterpreterProcessListener.RemoteWorksEventListener(){

                    @Override
                    public void onFinished(Object resultObject) {
                        if (resultObject != null && resultObject instanceof List) {
                            List runnerList = (List)resultObject;
                            for (InterpreterContextRunner r : runnerList) {
                                remoteRunners.add(new ZeppelinServerResourceParagraphRunner(r.getNoteId(), r.getParagraphId()));
                            }
                            final RemoteZeppelinServerResource resResource = new RemoteZeppelinServerResource();
                            resResource.setOwnerKey(eventOwnerKey);
                            resResource.setResourceType(RemoteZeppelinServerResource.Type.PARAGRAPH_RUNNERS);
                            resResource.setData((Object)remoteRunners);
                            RemoteInterpreterEventPoller.this.interpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

                                @Override
                                public Void call(RemoteInterpreterService.Client client) throws Exception {
                                    client.onReceivedZeppelinResource(resResource.toJson());
                                    return null;
                                }
                            });
                        }
                    }

                    @Override
                    public void onError() {
                        logger.info("onGetParagraphRunners onError");
                    }
                };
                remoteWorksEventListener.onGetParagraphRunners(reqRunnerContext.getNoteId(), reqRunnerContext.getParagraphId(), callBackEvent);
            }
        }
        catch (Exception e) {
            logger.error("Can't get RemoteInterpreterEvent", (Throwable)e);
            this.waitQuietly();
        }
    }

    private void sendResourcePoolResponseGetAll(final ResourceSet resourceSet) {
        this.interpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

            @Override
            public Void call(RemoteInterpreterService.Client client) throws Exception {
                LinkedList<String> resourceList = new LinkedList<String>();
                for (Resource r : resourceSet) {
                    resourceList.add(r.toJson());
                }
                client.resourcePoolResponseGetAll(resourceList);
                return null;
            }
        });
    }

    private ResourceSet getAllResourcePoolExcept() {
        ResourceSet resourceSet = new ResourceSet();
        for (ManagedInterpreterGroup intpGroup : this.interpreterGroup.getInterpreterSetting().getInterpreterSettingManager().getAllInterpreterGroup()) {
            if (intpGroup.getId().equals(this.interpreterGroup.getId())) continue;
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool == null) continue;
                resourceSet.addAll((Collection)localPool.getAll());
                continue;
            }
            if (!this.interpreterProcess.isRunning()) continue;
            List<String> resourceList = remoteInterpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<List<String>>(){

                @Override
                public List<String> call(RemoteInterpreterService.Client client) throws Exception {
                    return client.resourcePoolGetAll();
                }
            });
            for (String res : resourceList) {
                resourceSet.add((Object)Resource.fromJson((String)res));
            }
        }
        return resourceSet;
    }

    private void sendResourceResponseGet(final ResourceId resourceId, final Object o) {
        this.interpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

            @Override
            public Void call(RemoteInterpreterService.Client client) throws Exception {
                String rid = resourceId.toJson();
                ByteBuffer obj = o == null ? ByteBuffer.allocate(0) : Resource.serializeObject((Object)o);
                client.resourceResponseGet(rid, obj);
                return null;
            }
        });
    }

    private Object getResource(final ResourceId resourceId) {
        ManagedInterpreterGroup intpGroup = this.interpreterGroup.getInterpreterSetting().getInterpreterSettingManager().getInterpreterGroupById(resourceId.getResourcePoolId());
        if (intpGroup == null) {
            return null;
        }
        RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
        ByteBuffer buffer = remoteInterpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<ByteBuffer>(){

            @Override
            public ByteBuffer call(RemoteInterpreterService.Client client) throws Exception {
                return client.resourceGet(resourceId.getNoteId(), resourceId.getParagraphId(), resourceId.getName());
            }
        });
        try {
            Object o = Resource.deserializeObject((ByteBuffer)buffer);
            return o;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void sendInvokeMethodResult(final InvokeResourceMethodEventMessage message, final Object o) {
        this.interpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

            @Override
            public Void call(RemoteInterpreterService.Client client) throws Exception {
                String invokeMessage = message.toJson();
                ByteBuffer obj = o == null ? ByteBuffer.allocate(0) : Resource.serializeObject((Object)o);
                client.resourceResponseInvokeMethod(invokeMessage, obj);
                return null;
            }
        });
    }

    private Object invokeResourceMethod(final InvokeResourceMethodEventMessage message) {
        final ResourceId resourceId = message.resourceId;
        ManagedInterpreterGroup intpGroup = this.interpreterGroup.getInterpreterSetting().getInterpreterSettingManager().getInterpreterGroupById(resourceId.getResourcePoolId());
        if (intpGroup == null) {
            return null;
        }
        RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
        if (remoteInterpreterProcess == null) {
            ResourcePool localPool = intpGroup.getResourcePool();
            if (localPool != null) {
                Resource res = localPool.get(resourceId.getName());
                if (res != null) {
                    try {
                        return res.invokeMethod(message.methodName, message.getParamTypes(), message.params, message.returnResourceName);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
                logger.error("Can't invoke method {} on null object", (Object)message.methodName);
                return null;
            }
            logger.error("no resource pool");
            return null;
        }
        if (this.interpreterProcess.isRunning()) {
            ByteBuffer res = this.interpreterProcess.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<ByteBuffer>(){

                @Override
                public ByteBuffer call(RemoteInterpreterService.Client client) throws Exception {
                    return client.resourceInvokeMethod(resourceId.getNoteId(), resourceId.getParagraphId(), resourceId.getName(), message.toJson());
                }
            });
            try {
                return Resource.deserializeObject((ByteBuffer)res);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitQuietly() {
        try {
            RemoteInterpreterEventPoller remoteInterpreterEventPoller = this;
            synchronized (remoteInterpreterEventPoller) {
                this.wait(1000L);
            }
        }
        catch (InterruptedException ignored) {
            logger.info("Error in RemoteInterpreterEventPoller while waitQuietly : ", (Throwable)ignored);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        RemoteInterpreterEventPoller remoteInterpreterEventPoller = this;
        synchronized (remoteInterpreterEventPoller) {
            this.notify();
        }
    }
}

