/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.CallbackInfo;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterCallbackService;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterManagedProcess
extends RemoteInterpreterProcess
implements ExecuteResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInterpreterManagedProcess.class);
    private final String interpreterRunner;
    private final String callbackPortRange;
    private final String interpreterPortRange;
    private DefaultExecutor executor;
    private ExecuteWatchdog watchdog;
    private AtomicBoolean running = new AtomicBoolean(false);
    private TServer callbackServer;
    private String host = null;
    private int port = -1;
    private final String interpreterDir;
    private final String localRepoDir;
    private final String interpreterSettingName;
    private final boolean isUserImpersonated;
    private Map<String, String> env;

    public RemoteInterpreterManagedProcess(String intpRunner, String callbackPortRange, String interpreterPortRange, String intpDir, String localRepoDir, Map<String, String> env, int connectTimeout, String interpreterSettingName, boolean isUserImpersonated) {
        super(connectTimeout);
        this.interpreterRunner = intpRunner;
        this.callbackPortRange = callbackPortRange;
        this.interpreterPortRange = interpreterPortRange;
        this.env = env;
        this.interpreterDir = intpDir;
        this.localRepoDir = localRepoDir;
        this.interpreterSettingName = interpreterSettingName;
        this.isUserImpersonated = isUserImpersonated;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String userName) {
        String callbackHost;
        int callbackPort;
        TServerSocket tSocket = null;
        try {
            tSocket = RemoteInterpreterUtils.createTServerSocket((String)this.callbackPortRange);
            callbackPort = tSocket.getServerSocket().getLocalPort();
            callbackHost = RemoteInterpreterUtils.findAvailableHostAddress();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        logger.info("Thrift server for callback will start. Port: {}", (Object)callbackPort);
        try {
            this.callbackServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)tSocket).processor((TProcessor)new RemoteInterpreterCallbackService.Processor(new RemoteInterpreterCallbackService.Iface(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void callback(CallbackInfo callbackInfo) throws TException {
                    logger.info("RemoteInterpreterServer Registered: {}", (Object)callbackInfo);
                    RemoteInterpreterManagedProcess.this.host = callbackInfo.getHost();
                    RemoteInterpreterManagedProcess.this.port = callbackInfo.getPort();
                    RemoteInterpreterManagedProcess.this.running.set(true);
                    AtomicBoolean atomicBoolean = RemoteInterpreterManagedProcess.this.running;
                    synchronized (atomicBoolean) {
                        RemoteInterpreterManagedProcess.this.running.notify();
                    }
                }
            })));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    RemoteInterpreterManagedProcess.this.callbackServer.serve();
                }
            }).start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    if (RemoteInterpreterManagedProcess.this.callbackServer.isServing()) {
                        RemoteInterpreterManagedProcess.this.callbackServer.stop();
                    }
                }
            }));
            while (!this.callbackServer.isServing()) {
                logger.debug("callbackServer is not serving");
                Thread.sleep(500L);
            }
            logger.debug("callbackServer is serving now");
        }
        catch (InterruptedException e) {
            logger.warn("", (Throwable)e);
        }
        CommandLine cmdLine = CommandLine.parse((String)this.interpreterRunner);
        cmdLine.addArgument("-d", false);
        cmdLine.addArgument(this.interpreterDir, false);
        cmdLine.addArgument("-c", false);
        cmdLine.addArgument(callbackHost, false);
        cmdLine.addArgument("-p", false);
        cmdLine.addArgument(Integer.toString(callbackPort), false);
        cmdLine.addArgument("-r", false);
        cmdLine.addArgument(this.interpreterPortRange, false);
        if (this.isUserImpersonated && !userName.equals("anonymous")) {
            cmdLine.addArgument("-u", false);
            cmdLine.addArgument(userName, false);
        }
        cmdLine.addArgument("-l", false);
        cmdLine.addArgument(this.localRepoDir, false);
        cmdLine.addArgument("-g", false);
        cmdLine.addArgument(this.interpreterSettingName, false);
        this.executor = new DefaultExecutor();
        ByteArrayOutputStream cmdOut = new ByteArrayOutputStream();
        ProcessLogOutputStream processOutput = new ProcessLogOutputStream(logger);
        processOutput.setOutputStream(cmdOut);
        this.executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)processOutput)));
        this.watchdog = new ExecuteWatchdog(-1L);
        this.executor.setWatchdog(this.watchdog);
        try {
            Map procEnv = EnvironmentUtils.getProcEnvironment();
            procEnv.putAll(this.env);
            logger.info("Run interpreter process {}", (Object)cmdLine);
            this.executor.execute(cmdLine, procEnv, (ExecuteResultHandler)this);
        }
        catch (IOException e) {
            this.running.set(false);
            throw new RuntimeException(e);
        }
        try {
            AtomicBoolean e = this.running;
            synchronized (e) {
                if (!this.running.get()) {
                    this.running.wait(this.getConnectTimeout() * 2);
                }
            }
            if (!this.running.get()) {
                this.callbackServer.stop();
                throw new RuntimeException(new String(cmdOut.toByteArray()));
            }
        }
        catch (InterruptedException e) {
            logger.error("Remote interpreter is not accessible");
        }
        processOutput.setOutputStream(null);
    }

    public void stop() {
        this.getRemoteInterpreterEventPoller().shutdown();
        if (this.callbackServer.isServing()) {
            this.callbackServer.stop();
        }
        if (this.isRunning()) {
            logger.info("Kill interpreter process");
            try {
                this.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

                    @Override
                    public Void call(RemoteInterpreterService.Client client) throws Exception {
                        client.shutdown();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                logger.warn("ignore the exception when shutting down");
            }
            this.watchdog.destroyProcess();
        }
        this.executor = null;
        this.watchdog = null;
        this.running.set(false);
        logger.info("Remote process terminated");
    }

    public void onProcessComplete(int exitValue) {
        logger.info("Interpreter process exited {}", (Object)exitValue);
        this.running.set(false);
    }

    public void onProcessFailed(ExecuteException e) {
        logger.info("Interpreter process failed {}", (Throwable)e);
        this.running.set(false);
    }

    @VisibleForTesting
    public Map<String, String> getEnv() {
        return this.env;
    }

    @VisibleForTesting
    public String getLocalRepoDir() {
        return this.localRepoDir;
    }

    @VisibleForTesting
    public String getInterpreterDir() {
        return this.interpreterDir;
    }

    public String getInterpreterSettingName() {
        return this.interpreterSettingName;
    }

    @VisibleForTesting
    public String getInterpreterRunner() {
        return this.interpreterRunner;
    }

    @VisibleForTesting
    public boolean isUserImpersonated() {
        return this.isUserImpersonated;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    private static class ProcessLogOutputStream
    extends LogOutputStream {
        private Logger logger;
        OutputStream out;

        public ProcessLogOutputStream(Logger logger) {
            this.logger = logger;
        }

        protected void processLine(String s, int i) {
            this.logger.debug(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b) throws IOException {
            super.write(b);
            if (this.out != null) {
                ProcessLogOutputStream processLogOutputStream = this;
                synchronized (processLogOutputStream) {
                    if (this.out != null) {
                        this.out.write(b);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int offset, int len) throws IOException {
            super.write(b, offset, len);
            if (this.out != null) {
                ProcessLogOutputStream processLogOutputStream = this;
                synchronized (processLogOutputStream) {
                    if (this.out != null) {
                        this.out.write(b, offset, len);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOutputStream(OutputStream out) {
            ProcessLogOutputStream processLogOutputStream = this;
            synchronized (processLogOutputStream) {
                this.out = out;
            }
        }
    }
}

