/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.thrift.TException;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.remote.ClientFactory;
import org.apache.zeppelin.interpreter.remote.InterpreterContextRunnerPool;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventPoller;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteInterpreterProcess
implements InterpreterClient {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInterpreterProcess.class);
    private GenericObjectPool<RemoteInterpreterService.Client> clientPool;
    private RemoteInterpreterEventPoller remoteInterpreterEventPoller;
    private final InterpreterContextRunnerPool interpreterContextRunnerPool = new InterpreterContextRunnerPool();
    private int connectTimeout;

    public RemoteInterpreterProcess(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public RemoteInterpreterEventPoller getRemoteInterpreterEventPoller() {
        return this.remoteInterpreterEventPoller;
    }

    public void setRemoteInterpreterEventPoller(RemoteInterpreterEventPoller eventPoller) {
        this.remoteInterpreterEventPoller = eventPoller;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public synchronized RemoteInterpreterService.Client getClient() throws Exception {
        if (this.clientPool == null || this.clientPool.isClosed()) {
            this.clientPool = new GenericObjectPool((PooledObjectFactory)new ClientFactory(this.getHost(), this.getPort()));
        }
        return (RemoteInterpreterService.Client)this.clientPool.borrowObject();
    }

    private void releaseClient(RemoteInterpreterService.Client client) {
        this.releaseClient(client, false);
    }

    private void releaseClient(RemoteInterpreterService.Client client, boolean broken) {
        if (broken) {
            this.releaseBrokenClient(client);
        } else {
            try {
                this.clientPool.returnObject((Object)client);
            }
            catch (Exception e) {
                logger.warn("exception occurred during releasing thrift client", (Throwable)e);
            }
        }
    }

    private void releaseBrokenClient(RemoteInterpreterService.Client client) {
        try {
            this.clientPool.invalidateObject((Object)client);
        }
        catch (Exception e) {
            logger.warn("exception occurred during releasing thrift client", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteAngularObject(String name, String noteId, String paragraphId, Object o) {
        RemoteInterpreterService.Client client = null;
        try {
            client = this.getClient();
        }
        catch (NullPointerException e) {
            logger.info("NullPointerException in RemoteInterpreterProcess while updateRemoteAngularObject getClient, remote process not started", (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.error("Can't update angular object", (Throwable)e);
        }
        boolean broken = false;
        try {
            Gson gson = new Gson();
            client.angularObjectUpdate(name, noteId, paragraphId, gson.toJson(o));
        }
        catch (TException e) {
            broken = true;
            logger.error("Can't update angular object", (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error("Remote interpreter process not started", (Throwable)e);
            return;
        }
        finally {
            if (client != null) {
                this.releaseClient(client, broken);
            }
        }
    }

    public InterpreterContextRunnerPool getInterpreterContextRunnerPool() {
        return this.interpreterContextRunnerPool;
    }

    public <T> T callRemoteFunction(RemoteFunction<T> func) {
        RemoteInterpreterService.Client client = null;
        boolean broken = false;
        try {
            client = this.getClient();
            if (client != null) {
                T t = func.call(client);
                return t;
            }
        }
        catch (TException e) {
            broken = true;
            throw new RuntimeException(e);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        finally {
            if (client != null) {
                this.releaseClient(client, broken);
            }
        }
        return null;
    }

    public static interface RemoteFunction<T> {
        public T call(RemoteInterpreterService.Client var1) throws Exception;
    }
}

