/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterRunningProcess
extends RemoteInterpreterProcess {
    private final Logger logger = LoggerFactory.getLogger(RemoteInterpreterRunningProcess.class);
    private final String host;
    private final int port;
    private final String interpreterSettingName;

    public RemoteInterpreterRunningProcess(String interpreterSettingName, int connectTimeout, String host, int port) {
        super(connectTimeout);
        this.interpreterSettingName = interpreterSettingName;
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getInterpreterSettingName() {
        return this.interpreterSettingName;
    }

    public void start(String userName) {
    }

    public void stop() {
        if (System.getenv("ZEPPELIN_FORCE_STOP") != null && this.isRunning()) {
            this.logger.info("Kill interpreter process");
            try {
                this.callRemoteFunction(new RemoteInterpreterProcess.RemoteFunction<Void>(){

                    @Override
                    public Void call(RemoteInterpreterService.Client client) throws Exception {
                        client.shutdown();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn("ignore the exception when shutting down interpreter process.", (Throwable)e);
            }
        }
    }

    public boolean isRunning() {
        return RemoteInterpreterUtils.checkIfRemoteEndpointAccessible((String)this.getHost(), (int)this.getPort());
    }
}

