/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import org.apache.zeppelin.helium.HeliumPackage;

public class ApplicationState {
    Status status = Status.UNLOADED;
    String id;
    HeliumPackage pkg;
    String output;

    public ApplicationState(String id, HeliumPackage pkg) {
        this.id = id;
        this.pkg = pkg;
    }

    public void resetStatus() {
        if (this.status != Status.ERROR) {
            this.status = Status.UNLOADED;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ApplicationState) {
            return this.pkg.equals((Object)((ApplicationState)o).getHeliumPackage());
        }
        if (o instanceof HeliumPackage) {
            return this.pkg.equals((Object)((HeliumPackage)o));
        }
        return false;
    }

    public int hashCode() {
        return this.pkg.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public synchronized void appendOutput(String output) {
        this.output = this.output == null ? output : this.output + output;
    }

    public HeliumPackage getHeliumPackage() {
        return this.pkg;
    }

    public static enum Status {
        LOADING,
        LOADED,
        UNLOADING,
        UNLOADED,
        ERROR;

    }
}

