/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.zeppelin.notebook.FolderListener;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Folder {
    public static final String ROOT_FOLDER_ID = "/";
    public static final String TRASH_FOLDER_ID = "~Trash";
    public static final String TRASH_FOLDER_CONFLICT_INFIX = " ";
    private String id;
    private Folder parent;
    private Map<String, Folder> children = new LinkedHashMap<String, Folder>();
    private final Map<String, Note> notes = new LinkedHashMap<String, Note>();
    private List<FolderListener> listeners = new LinkedList<FolderListener>();
    private static final Logger logger = LoggerFactory.getLogger(Folder.class);

    public Folder(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.isRoot()) {
            return ROOT_FOLDER_ID;
        }
        String path = this.getId();
        int lastSlashIndex = path.lastIndexOf(ROOT_FOLDER_ID);
        if (lastSlashIndex < 0) {
            return path;
        }
        return path.substring(lastSlashIndex + 1);
    }

    public String getParentFolderId() {
        if (this.isRoot()) {
            return ROOT_FOLDER_ID;
        }
        int lastSlashIndex = this.getId().lastIndexOf(ROOT_FOLDER_ID);
        if (lastSlashIndex < 0) {
            return ROOT_FOLDER_ID;
        }
        return this.getId().substring(0, lastSlashIndex);
    }

    public static String normalizeFolderId(String id) {
        id = id.trim();
        id = id.replace("\\", ROOT_FOLDER_ID);
        while (id.contains("///")) {
            id = id.replaceAll("///", ROOT_FOLDER_ID);
        }
        if ((id = id.replaceAll("//", ROOT_FOLDER_ID)).equals(ROOT_FOLDER_ID)) {
            return ROOT_FOLDER_ID;
        }
        if (id.charAt(0) == '/') {
            id = id.substring(1);
        }
        if (id.charAt(id.length() - 1) == '/') {
            id = id.substring(0, id.length() - 1);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String newId) {
        if (this.isRoot()) {
            return;
        }
        String oldId = this.getId();
        this.id = Folder.normalizeFolderId(newId);
        logger.info("Rename {} to {}", (Object)oldId, (Object)this.getId());
        Map<String, Note> map = this.notes;
        synchronized (map) {
            for (Note note : this.notes.values()) {
                String noteName = note.getNameWithoutPath();
                String newNotePath = newId.equals(ROOT_FOLDER_ID) ? noteName : newId + ROOT_FOLDER_ID + noteName;
                note.setName(newNotePath);
            }
        }
        for (Folder child : this.children.values()) {
            child.rename(this.getId() + ROOT_FOLDER_ID + child.getName());
        }
        this.notifyRenamed(oldId);
    }

    public void merge(Folder folder) {
        logger.info("Merge {} into {}", (Object)folder.getId(), (Object)this.getId());
        this.addNotes(folder.getNotes());
    }

    public void addFolderListener(FolderListener listener) {
        this.listeners.add(listener);
    }

    public void notifyRenamed(String oldFolderId) {
        for (FolderListener listener : this.listeners) {
            listener.onFolderRenamed(this, oldFolderId);
        }
    }

    public Folder getParent() {
        return this.parent;
    }

    public Map<String, Folder> getChildren() {
        return this.children;
    }

    public void setParent(Folder parent) {
        logger.info("Set parent of {} to {}", (Object)this.getId(), (Object)parent.getId());
        this.parent = parent;
    }

    public void addChild(Folder child) {
        if (child == this) {
            return;
        }
        this.children.put(child.getId(), child);
    }

    public void removeChild(String folderId) {
        logger.info("Remove child {} from {}", (Object)folderId, (Object)this.getId());
        this.children.remove(folderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNote(Note note) {
        logger.info("Add note {} to folder {}", (Object)note.getId(), (Object)this.getId());
        Map<String, Note> map = this.notes;
        synchronized (map) {
            this.notes.put(note.getId(), note);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotes(List<Note> newNotes) {
        Map<String, Note> map = this.notes;
        synchronized (map) {
            for (Note note : newNotes) {
                this.notes.put(note.getId(), note);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(Note note) {
        logger.info("Remove note {} from folder {}", (Object)note.getId(), (Object)this.getId());
        Map<String, Note> map = this.notes;
        synchronized (map) {
            this.notes.remove(note.getId());
        }
    }

    public List<Note> getNotes() {
        return new LinkedList<Note>(this.notes.values());
    }

    public List<Note> getNotesRecursively() {
        List<Note> notes = this.getNotes();
        for (Folder child : this.children.values()) {
            notes.addAll(child.getNotesRecursively());
        }
        return notes;
    }

    public List<Note> getNotesRecursively(Set<String> userAndRoles, NotebookAuthorization notebookAuthorization) {
        HashSet entities = Sets.newHashSet();
        if (userAndRoles != null) {
            entities.addAll(userAndRoles);
        }
        ArrayList<Note> notes = new ArrayList<Note>();
        for (Note note : this.getNotes()) {
            if (!notebookAuthorization.isOwner(note.getId(), entities)) continue;
            notes.add(note);
        }
        for (Folder child : this.children.values()) {
            notes.addAll(child.getNotesRecursively(userAndRoles, notebookAuthorization));
        }
        return notes;
    }

    public int countNotes() {
        return this.notes.size();
    }

    public boolean hasChild() {
        return this.children.size() > 0;
    }

    boolean isRoot() {
        return this.getId().equals(ROOT_FOLDER_ID);
    }

    public boolean isTrash() {
        if (this.isRoot()) {
            return false;
        }
        return this.getId().split(ROOT_FOLDER_ID)[0].equals(TRASH_FOLDER_ID);
    }
}

