/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.zeppelin.notebook.Folder;
import org.apache.zeppelin.notebook.FolderListener;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteNameListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderView
implements NoteNameListener,
FolderListener {
    private final Map<String, Folder> folders = new LinkedHashMap<String, Folder>();
    private final Map<Note, Folder> index = new LinkedHashMap<Note, Folder>();
    private static final Logger logger = LoggerFactory.getLogger(FolderView.class);

    public Folder getFolder(String folderId) {
        String normalizedFolderId = Folder.normalizeFolderId(folderId);
        return this.folders.get(normalizedFolderId);
    }

    public Folder renameFolder(String oldFolderId, String newFolderId) {
        String normOldFolderId = Folder.normalizeFolderId(oldFolderId);
        String normNewFolderId = Folder.normalizeFolderId(newFolderId);
        if (!this.hasFolder(normOldFolderId)) {
            return null;
        }
        if (oldFolderId.equals("/")) {
            return null;
        }
        if (normOldFolderId.equals(normNewFolderId)) {
            return this.getFolder(normOldFolderId);
        }
        logger.info("Rename {} to {}", (Object)normOldFolderId, (Object)normNewFolderId);
        Folder oldFolder = this.getFolder(normOldFolderId);
        this.removeFolder(oldFolderId);
        oldFolder.rename(normNewFolderId);
        return oldFolder;
    }

    public Folder getFolderOf(Note note) {
        return this.index.get(note);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNote(Note note) {
        if (note.isNameEmpty()) {
            return;
        }
        String folderId = note.getFolderId();
        Folder folder = this.getOrCreateFolder(folderId);
        folder.addNote(note);
        Map<Note, Folder> map = this.index;
        synchronized (map) {
            this.index.put(note, folder);
        }
    }

    private Folder getOrCreateFolder(String folderId) {
        if (this.folders.containsKey(folderId)) {
            return this.folders.get(folderId);
        }
        return this.createFolder(folderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Folder createFolder(String folderId) {
        folderId = Folder.normalizeFolderId(folderId);
        Folder newFolder = new Folder(folderId);
        newFolder.addFolderListener(this);
        logger.info("Create folder {}", (Object)folderId);
        Map<String, Folder> map = this.folders;
        synchronized (map) {
            this.folders.put(folderId, newFolder);
        }
        Folder parentFolder = this.getOrCreateFolder(newFolder.getParentFolderId());
        newFolder.setParent(parentFolder);
        parentFolder.addChild(newFolder);
        return newFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFolder(String folderId) {
        Folder removedFolder;
        Map<String, Folder> map = this.folders;
        synchronized (map) {
            removedFolder = this.folders.remove(folderId);
        }
        if (removedFolder != null) {
            logger.info("Remove folder {}", (Object)folderId);
            Folder parent = removedFolder.getParent();
            parent.removeChild(folderId);
            this.removeFolderIfEmpty(parent.getId());
        }
    }

    private void removeFolderIfEmpty(String folderId) {
        if (!this.hasFolder(folderId)) {
            return;
        }
        Folder folder = this.getFolder(folderId);
        if (folder.countNotes() == 0 && !folder.hasChild()) {
            logger.info("Folder {} is empty", (Object)folder.getId());
            this.removeFolder(folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(Note note) {
        if (!this.index.containsKey(note)) {
            return;
        }
        Folder folder = this.index.get(note);
        folder.removeNote(note);
        this.removeFolderIfEmpty(folder.getId());
        Map<Note, Folder> map = this.index;
        synchronized (map) {
            this.index.remove(note);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Object, Folder> map = this.folders;
        synchronized (map) {
            this.folders.clear();
        }
        map = this.index;
        synchronized (map) {
            this.index.clear();
        }
    }

    public boolean hasFolder(String folderId) {
        return this.getFolder(folderId) != null;
    }

    public boolean hasNote(Note note) {
        return this.index.containsKey(note);
    }

    public int countFolders() {
        return this.folders.size();
    }

    public int countNotes() {
        int count = 0;
        for (Folder folder : this.folders.values()) {
            count += folder.countNotes();
        }
        return count;
    }

    @Override
    public void onNoteNameChanged(Note note, String oldName) {
        if (note.isNameEmpty()) {
            return;
        }
        logger.info("Note name changed: {} -> {}", (Object)oldName, (Object)note.getName());
        if (!this.index.containsKey(note)) {
            this.putNote(note);
        } else {
            Folder folder = this.index.get(note);
            if (folder.getId().equals(note.getFolderId())) {
                return;
            }
            this.removeNote(note);
            this.putNote(note);
        }
    }

    @Override
    public void onFolderRenamed(Folder folder, String oldFolderId) {
        if (this.getFolder(folder.getId()) == folder) {
            return;
        }
        logger.info("folder renamed: {} -> {}", (Object)oldFolderId, (Object)folder.getId());
        if (this.getFolder(oldFolderId) == folder) {
            this.folders.remove(oldFolderId);
        }
        Folder newFolder = this.getOrCreateFolder(folder.getId());
        newFolder.merge(folder);
        for (Note note : folder.getNotes()) {
            this.index.put(note, newFolder);
        }
    }
}

