/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.completer.CompletionType;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterInfo;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.notebook.ApplicationState;
import org.apache.zeppelin.notebook.JobListenerFactory;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteNameListener;
import org.apache.zeppelin.notebook.NotebookImportDeserializer;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.utility.IdHashes;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Note
implements ParagraphJobListener,
JsonSerializable {
    private static final Logger logger = LoggerFactory.getLogger(Note.class);
    private static final long serialVersionUID = 7920699076577612429L;
    private static Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").registerTypeAdapter(Date.class, (Object)new NotebookImportDeserializer()).registerTypeAdapterFactory((TypeAdapterFactory)Input.TypeAdapterFactory).create();
    private static final ScheduledThreadPoolExecutor delayedPersistThreadPool = new ScheduledThreadPoolExecutor(0);
    final List<Paragraph> paragraphs = new LinkedList<Paragraph>();
    private String name = "";
    private String id;
    private Map<String, Object> noteParams = new HashMap<String, Object>();
    private LinkedHashMap<String, Input> noteForms = new LinkedHashMap();
    private transient ZeppelinConfiguration conf = ZeppelinConfiguration.create();
    private Map<String, List<AngularObject>> angularObjects = new HashMap<String, List<AngularObject>>();
    private transient InterpreterFactory factory;
    private transient InterpreterSettingManager interpreterSettingManager;
    private transient JobListenerFactory jobListenerFactory;
    private transient NotebookRepo repo;
    private transient SearchService index;
    private transient ScheduledFuture delayedPersist;
    private transient Object delayedPersistLock = new Object();
    private transient NoteEventListener noteEventListener;
    private transient Credentials credentials;
    private transient NoteNameListener noteNameListener;
    private Map<String, Object> config = new HashMap<String, Object>();
    private Map<String, Object> info = new HashMap<String, Object>();

    public Note() {
        this.generateId();
    }

    public Note(NotebookRepo repo, InterpreterFactory factory, InterpreterSettingManager interpreterSettingManager, JobListenerFactory jlFactory, SearchService noteIndex, Credentials credentials, NoteEventListener noteEventListener) {
        this.repo = repo;
        this.factory = factory;
        this.interpreterSettingManager = interpreterSettingManager;
        this.jobListenerFactory = jlFactory;
        this.index = noteIndex;
        this.noteEventListener = noteEventListener;
        this.credentials = credentials;
        this.generateId();
    }

    private void generateId() {
        this.id = IdHashes.generateId();
    }

    public boolean isPersonalizedMode() {
        Object v = this.getConfig().get("personalizedMode");
        return null != v && "true".equals(v);
    }

    public void setPersonalizedMode(Boolean value) {
        String valueString = "";
        valueString = value != false ? "true" : "false";
        this.getConfig().put("personalizedMode", valueString);
        this.clearUserParagraphs(value);
    }

    private void clearUserParagraphs(boolean isPersonalized) {
        if (!isPersonalized) {
            for (Paragraph p : this.paragraphs) {
                p.clearUserParagraphs();
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.isNameEmpty()) {
            this.name = this.getId();
        }
        return this.name;
    }

    public Map<String, Object> getNoteParams() {
        return this.noteParams;
    }

    public void setNoteParams(Map<String, Object> noteParams) {
        this.noteParams = noteParams;
    }

    public LinkedHashMap<String, Input> getNoteForms() {
        return this.noteForms;
    }

    public void setNoteForms(LinkedHashMap<String, Input> noteForms) {
        this.noteForms = noteForms;
    }

    public String getNameWithoutPath() {
        String notePath = this.getName();
        int lastSlashIndex = notePath.lastIndexOf("/");
        if (lastSlashIndex < 0) {
            return notePath;
        }
        return notePath.substring(lastSlashIndex + 1);
    }

    public String getFolderId() {
        int lastSlashIndex;
        String notePath = this.getName();
        if (notePath.charAt(0) == '/') {
            notePath = notePath.substring(1);
        }
        if ((lastSlashIndex = notePath.lastIndexOf("/")) < 0) {
            return "/";
        }
        String folderId = notePath.substring(0, lastSlashIndex);
        return folderId;
    }

    public boolean isNameEmpty() {
        return this.name.trim().isEmpty();
    }

    private String normalizeNoteName(String name) {
        name = name.trim();
        name = name.replace("\\", "/");
        while (name.contains("///")) {
            name = name.replaceAll("///", "/");
        }
        if ((name = name.replaceAll("//", "/")).length() == 0) {
            name = "/";
        }
        return name;
    }

    public void setName(String name) {
        String oldName = this.name;
        if (name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            name = this.normalizeNoteName(name);
        }
        this.name = name;
        if (this.noteNameListener != null && !oldName.equals(name)) {
            this.noteNameListener.onNoteNameChanged(this, oldName);
        }
    }

    public void setNoteNameListener(NoteNameListener listener) {
        this.noteNameListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterpreterFactory(InterpreterFactory factory) {
        this.factory = factory;
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                p.setInterpreterFactory(factory);
            }
        }
    }

    void setInterpreterSettingManager(InterpreterSettingManager interpreterSettingManager) {
        this.interpreterSettingManager = interpreterSettingManager;
    }

    public void initializeJobListenerForParagraph(Paragraph paragraph) {
        Note paragraphNote = paragraph.getNote();
        if (!paragraphNote.getId().equals(this.getId())) {
            throw new IllegalArgumentException(String.format("The paragraph %s from note %s does not belong to note %s", paragraph.getId(), paragraphNote.getId(), this.getId()));
        }
        boolean foundParagraph = false;
        for (Paragraph ownParagraph : this.paragraphs) {
            if (!paragraph.getId().equals(ownParagraph.getId())) continue;
            paragraph.setListener(this.jobListenerFactory.getParagraphJobListener(this));
            foundParagraph = true;
        }
        if (!foundParagraph) {
            throw new IllegalArgumentException(String.format("Cannot find paragraph %s from note %s", paragraph.getId(), paragraphNote.getId()));
        }
    }

    void setJobListenerFactory(JobListenerFactory jobListenerFactory) {
        this.jobListenerFactory = jobListenerFactory;
    }

    void setNotebookRepo(NotebookRepo repo) {
        this.repo = repo;
    }

    public Boolean isCronSupported(ZeppelinConfiguration config) {
        if (config.isZeppelinNotebookCronEnable().booleanValue()) {
            config.getZeppelinNotebookCronFolders();
            if (config.getZeppelinNotebookCronFolders() == null) {
                return true;
            }
            for (String folder : config.getZeppelinNotebookCronFolders().split(",")) {
                folder = folder.replaceAll("\\*", "\\.*").replaceAll("\\?", "\\.");
                if (!this.getName().matches(folder)) continue;
                return true;
            }
        }
        return false;
    }

    public void setCronSupported(ZeppelinConfiguration config) {
        this.getConfig().put("isZeppelinNotebookCronEnable", this.isCronSupported(config));
    }

    public void setIndex(SearchService index) {
        this.index = index;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    Map<String, List<AngularObject>> getAngularObjects() {
        return this.angularObjects;
    }

    public Paragraph addNewParagraph(AuthenticationInfo authenticationInfo) {
        return this.insertNewParagraph(this.paragraphs.size(), authenticationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCloneParagraph(Paragraph srcParagraph, AuthenticationInfo subject) {
        Paragraph newParagraph = new Paragraph(srcParagraph.getId(), this, this, this.factory);
        HashMap<String, Object> config = new HashMap<String, Object>(srcParagraph.getConfig());
        Map param = srcParagraph.settings.getParams();
        LinkedHashMap form = srcParagraph.settings.getForms();
        logger.debug("srcParagraph user: " + srcParagraph.getUser());
        newParagraph.setAuthenticationInfo(subject);
        newParagraph.setConfig(config);
        newParagraph.settings.setParams(param);
        newParagraph.settings.setForms(form);
        newParagraph.setText(srcParagraph.getText());
        newParagraph.setTitle(srcParagraph.getTitle());
        logger.debug("newParagraph user: " + newParagraph.getUser());
        try {
            Gson gson = new Gson();
            String resultJson = gson.toJson(srcParagraph.getReturn());
            InterpreterResult result = InterpreterResult.fromJson((String)resultJson);
            newParagraph.setReturn(result, null);
        }
        catch (Exception e) {
            logger.warn("Paragraph " + srcParagraph.getId() + " has a result with exception. " + e.getMessage());
        }
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            this.paragraphs.add(newParagraph);
        }
        if (this.noteEventListener != null) {
            this.noteEventListener.onParagraphCreate(newParagraph);
        }
    }

    public Paragraph insertNewParagraph(int index, AuthenticationInfo authenticationInfo) {
        Paragraph paragraph = this.createParagraph(index, authenticationInfo);
        this.insertParagraph(paragraph, index);
        return paragraph;
    }

    private Paragraph createParagraph(int index, AuthenticationInfo authenticationInfo) {
        Paragraph p = new Paragraph(this, this, this.factory);
        p.setAuthenticationInfo(authenticationInfo);
        this.setParagraphMagic(p, index);
        return p;
    }

    public void addParagraph(Paragraph paragraph) {
        this.insertParagraph(paragraph, this.paragraphs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertParagraph(Paragraph paragraph, int index) {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            this.paragraphs.add(index, paragraph);
        }
        if (this.noteEventListener != null) {
            this.noteEventListener.onParagraphCreate(paragraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paragraph removeParagraph(String user, String paragraphId) {
        this.removeAllAngularObjectInParagraph(user, paragraphId);
        this.interpreterSettingManager.removeResourcesBelongsToParagraph(this.getId(), paragraphId);
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            Iterator<Paragraph> i = this.paragraphs.iterator();
            while (i.hasNext()) {
                Paragraph p = i.next();
                if (!p.getId().equals(paragraphId)) continue;
                this.index.deleteIndexDoc(this, p);
                i.remove();
                if (this.noteEventListener != null) {
                    this.noteEventListener.onParagraphRemove(p);
                }
                return p;
            }
        }
        return null;
    }

    public void clearParagraphOutputFields(Paragraph p) {
        p.setReturn(null, null);
        p.clearRuntimeInfo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paragraph clearPersonalizedParagraphOutput(String paragraphId, String user) {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                if (!p.getId().equals(paragraphId)) continue;
                p = p.getUserParagraphMap().get(user);
                this.clearParagraphOutputFields(p);
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paragraph clearParagraphOutput(String paragraphId) {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                if (!p.getId().equals(paragraphId)) continue;
                this.clearParagraphOutputFields(p);
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllParagraphOutput() {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                p.setReturn(null, null);
            }
        }
    }

    public void moveParagraph(String paragraphId, int index) {
        this.moveParagraph(paragraphId, index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveParagraph(String paragraphId, int index, boolean throwWhenIndexIsOutOfBound) {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            Paragraph p = null;
            if (index < 0 || index >= this.paragraphs.size()) {
                if (throwWhenIndexIsOutOfBound) {
                    throw new IndexOutOfBoundsException("paragraph size is " + this.paragraphs.size() + " , index is " + index);
                }
                return;
            }
            for (int i = 0; i < this.paragraphs.size(); ++i) {
                if (!this.paragraphs.get(i).getId().equals(paragraphId)) continue;
                int oldIndex = i;
                if (oldIndex == index) {
                    return;
                }
                p = this.paragraphs.remove(i);
            }
            if (p != null) {
                this.paragraphs.add(index, p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastParagraph(String paragraphId) {
        if (!this.paragraphs.isEmpty()) {
            List<Paragraph> list = this.paragraphs;
            synchronized (list) {
                if (paragraphId.equals(this.paragraphs.get(this.paragraphs.size() - 1).getId())) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public int getParagraphCount() {
        return this.paragraphs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paragraph getParagraph(String paragraphId) {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                if (!p.getId().equals(paragraphId)) continue;
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paragraph getLastParagraph() {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            return this.paragraphs.get(this.paragraphs.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> generateParagraphsInfo() {
        LinkedList<Map<String, String>> paragraphsInfo = new LinkedList<Map<String, String>>();
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                Map<String, String> info = this.populateParagraphInfo(p);
                paragraphsInfo.add(info);
            }
        }
        return paragraphsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> generateSingleParagraphInfo(String paragraphId) {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                if (!p.getId().equals(paragraphId)) continue;
                return this.populateParagraphInfo(p);
            }
            return new HashMap<String, String>();
        }
    }

    private Map<String, String> populateParagraphInfo(Paragraph p) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("id", p.getId());
        info.put("status", p.getStatus().toString());
        if (p.getDateStarted() != null) {
            info.put("started", p.getDateStarted().toString());
        }
        if (p.getDateFinished() != null) {
            info.put("finished", p.getDateFinished().toString());
        }
        if (p.getStatus().isRunning()) {
            info.put("progress", String.valueOf(p.progress()));
        } else {
            info.put("progress", String.valueOf(100));
        }
        return info;
    }

    private void setParagraphMagic(Paragraph p, int index) {
        String replName;
        if (this.paragraphs.size() > 0 && p.isValidInterpreter(replName = index == 0 ? this.paragraphs.get(0).getIntpText() : this.paragraphs.get(index - 1).getIntpText()) && StringUtils.isNotEmpty((String)replName)) {
            p.setText("%" + replName + "\n");
        }
    }

    public synchronized void runAll() {
        String cronExecutingUser = (String)this.getConfig().get("cronExecutingUser");
        String cronExecutingRoles = (String)this.getConfig().get("cronExecutingRoles");
        if (null == cronExecutingUser) {
            cronExecutingUser = "anonymous";
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo(cronExecutingUser, StringUtils.isEmpty((String)cronExecutingRoles) ? null : cronExecutingRoles, null);
        this.runAll(authenticationInfo, true);
    }

    public void runAll(AuthenticationInfo authenticationInfo, boolean blocking) {
        for (Paragraph p : this.getParagraphs()) {
            if (!p.isEnabled()) continue;
            p.setAuthenticationInfo(authenticationInfo);
            if (this.run(p.getId(), blocking)) continue;
            logger.warn("Skip running the remain notes because paragraph {} fails", (Object)p.getId());
            break;
        }
    }

    public boolean run(String paragraphId) {
        return this.run(paragraphId, false);
    }

    public boolean run(String paragraphId, boolean blocking) {
        Paragraph p = this.getParagraph(paragraphId);
        p.setListener(this.jobListenerFactory.getParagraphJobListener(this));
        return p.execute(blocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTerminated() {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                if (p.isTerminated()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRunningOrPending() {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            for (Paragraph p : this.paragraphs) {
                Job.Status status = p.getStatus();
                if (!status.isRunning() && !status.isPending()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTrash() {
        String path = this.getName();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path.split("/")[0].equals("~Trash");
    }

    public List<InterpreterCompletion> completion(String paragraphId, String buffer, int cursor) {
        Paragraph p = this.getParagraph(paragraphId);
        p.setListener(this.jobListenerFactory.getParagraphJobListener(this));
        return p.completion(buffer, cursor);
    }

    public List<InterpreterCompletion> getInterpreterCompletion() {
        LinkedList<InterpreterCompletion> completion = new LinkedList<InterpreterCompletion>();
        for (InterpreterSetting intp : this.interpreterSettingManager.getInterpreterSettings(this.getId())) {
            List<InterpreterInfo> intInfo = intp.getInterpreterInfos();
            if (intInfo.size() > 1) {
                for (InterpreterInfo info : intInfo) {
                    String name = intp.getName() + "." + info.getName();
                    completion.add(new InterpreterCompletion(name, name, CompletionType.setting.name()));
                }
                continue;
            }
            completion.add(new InterpreterCompletion(intp.getName(), intp.getName(), CompletionType.setting.name()));
        }
        return completion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Paragraph> getParagraphs() {
        List<Paragraph> list = this.paragraphs;
        synchronized (list) {
            return new LinkedList<Paragraph>(this.paragraphs);
        }
    }

    private void snapshotAngularObjectRegistry(String user) {
        this.angularObjects = new HashMap<String, List<AngularObject>>();
        List<InterpreterSetting> settings = this.interpreterSettingManager.getInterpreterSettings(this.getId());
        if (settings == null || settings.size() == 0) {
            return;
        }
        for (InterpreterSetting setting : settings) {
            ManagedInterpreterGroup intpGroup = setting.getInterpreterGroup(user, this.id);
            if (intpGroup == null) continue;
            AngularObjectRegistry registry = intpGroup.getAngularObjectRegistry();
            this.angularObjects.put(intpGroup.getId(), registry.getAllWithGlobal(this.id));
        }
    }

    private void removeAllAngularObjectInParagraph(String user, String paragraphId) {
        this.angularObjects = new HashMap<String, List<AngularObject>>();
        List<InterpreterSetting> settings = this.interpreterSettingManager.getInterpreterSettings(this.getId());
        if (settings == null || settings.size() == 0) {
            return;
        }
        for (InterpreterSetting setting : settings) {
            List<ApplicationState> appStates;
            if (setting.getInterpreterGroup(user, this.id) == null) continue;
            ManagedInterpreterGroup intpGroup = setting.getInterpreterGroup(user, this.id);
            AngularObjectRegistry registry = intpGroup.getAngularObjectRegistry();
            if (registry instanceof RemoteAngularObjectRegistry) {
                ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(this.id, paragraphId);
                appStates = this.getParagraph(paragraphId).getAllApplicationStates();
                if (appStates == null) continue;
                for (ApplicationState app : appStates) {
                    ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(this.id, app.getId());
                }
                continue;
            }
            registry.removeAll(this.id, paragraphId);
            appStates = this.getParagraph(paragraphId).getAllApplicationStates();
            if (appStates == null) continue;
            for (ApplicationState app : appStates) {
                registry.removeAll(this.id, app.getId());
            }
        }
    }

    public void persist(AuthenticationInfo subject) throws IOException {
        Preconditions.checkNotNull((Object)subject, (Object)"AuthenticationInfo should not be null");
        this.stopDelayedPersistTimer();
        this.snapshotAngularObjectRegistry(subject.getUser());
        this.index.updateIndexDoc(this);
        this.repo.save(this, subject);
    }

    public void persist(int maxDelaySec, AuthenticationInfo subject) {
        this.startDelayedPersistTimer(maxDelaySec, subject);
    }

    void unpersist(AuthenticationInfo subject) throws IOException {
        this.repo.remove(this.getId(), subject);
    }

    public Note getUserNote(String user) {
        Note newNote = new Note();
        newNote.name = this.getName();
        newNote.id = this.getId();
        newNote.config = this.getConfig();
        newNote.angularObjects = this.getAngularObjects();
        for (Paragraph p : this.paragraphs) {
            Paragraph newParagraph = p.getUserParagraph(user);
            if (null == newParagraph) {
                newParagraph = p.cloneParagraphForUser(user);
            }
            newNote.paragraphs.add(newParagraph);
        }
        return newNote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDelayedPersistTimer(int maxDelaySec, final AuthenticationInfo subject) {
        Object object = this.delayedPersistLock;
        synchronized (object) {
            if (this.delayedPersist != null) {
                return;
            }
            this.delayedPersist = delayedPersistThreadPool.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        Note.this.persist(subject);
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }, (long)maxDelaySec, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDelayedPersistTimer() {
        Object object = this.delayedPersistLock;
        synchronized (object) {
            if (this.delayedPersist == null) {
                return;
            }
            this.delayedPersist.cancel(false);
        }
    }

    public Map<String, Object> getConfig() {
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public Map<String, Object> getInfo() {
        if (this.info == null) {
            this.info = new HashMap<String, Object>();
        }
        return this.info;
    }

    public void setInfo(Map<String, Object> info) {
        this.info = info;
    }

    public void beforeStatusChange(Job job, Job.Status before, Job.Status after) {
        ParagraphJobListener listener;
        if (this.jobListenerFactory != null && (listener = this.jobListenerFactory.getParagraphJobListener(this)) != null) {
            listener.beforeStatusChange(job, before, after);
        }
    }

    public void afterStatusChange(Job job, Job.Status before, Job.Status after) {
        ParagraphJobListener listener;
        if (this.jobListenerFactory != null && (listener = this.jobListenerFactory.getParagraphJobListener(this)) != null) {
            listener.afterStatusChange(job, before, after);
        }
        if (this.noteEventListener != null) {
            this.noteEventListener.onParagraphStatusChange((Paragraph)job, after);
        }
    }

    public void onProgressUpdate(Job job, int progress) {
        ParagraphJobListener listener;
        if (this.jobListenerFactory != null && (listener = this.jobListenerFactory.getParagraphJobListener(this)) != null) {
            listener.onProgressUpdate(job, progress);
        }
    }

    @Override
    public void onOutputAppend(Paragraph paragraph, int idx, String output) {
        ParagraphJobListener listener;
        if (this.jobListenerFactory != null && (listener = this.jobListenerFactory.getParagraphJobListener(this)) != null) {
            listener.onOutputAppend(paragraph, idx, output);
        }
    }

    @Override
    public void onOutputUpdate(Paragraph paragraph, int idx, InterpreterResultMessage msg) {
        ParagraphJobListener listener;
        if (this.jobListenerFactory != null && (listener = this.jobListenerFactory.getParagraphJobListener(this)) != null) {
            listener.onOutputUpdate(paragraph, idx, msg);
        }
    }

    @Override
    public void onOutputUpdateAll(Paragraph paragraph, List<InterpreterResultMessage> msgs) {
        ParagraphJobListener listener;
        if (this.jobListenerFactory != null && (listener = this.jobListenerFactory.getParagraphJobListener(this)) != null) {
            listener.onOutputUpdateAll(paragraph, msgs);
        }
    }

    void setNoteEventListener(NoteEventListener noteEventListener) {
        this.noteEventListener = noteEventListener;
    }

    boolean hasInterpreterBinded() {
        return !this.interpreterSettingManager.getInterpreterSettings(this.getId()).isEmpty();
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static Note fromJson(String json) {
        Note note = (Note)gson.fromJson(json, Note.class);
        Note.convertOldInput(note);
        note.postProcessParagraphs();
        return note;
    }

    public void postProcessParagraphs() {
        for (Paragraph p : this.paragraphs) {
            List<ApplicationState> appStates;
            p.clearRuntimeInfos();
            p.parseText();
            if (p.getStatus() == Job.Status.PENDING || p.getStatus() == Job.Status.RUNNING) {
                p.setStatus(Job.Status.ABORT);
            }
            if ((appStates = p.getAllApplicationStates()) == null) continue;
            for (ApplicationState app : appStates) {
                if (app.getStatus() == ApplicationState.Status.ERROR) continue;
                app.setStatus(ApplicationState.Status.UNLOADED);
            }
        }
    }

    private static void convertOldInput(Note note) {
        for (Paragraph p : note.paragraphs) {
            p.settings.convertOldInput();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        if (this.paragraphs != null ? !this.paragraphs.equals(note.paragraphs) : note.paragraphs != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(note.id) : note.id != null) {
            return false;
        }
        if (this.angularObjects != null ? !this.angularObjects.equals(note.angularObjects) : note.angularObjects != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(note.config) : note.config != null) {
            return false;
        }
        return this.info != null ? this.info.equals(note.info) : note.info == null;
    }

    public int hashCode() {
        int result = this.paragraphs != null ? this.paragraphs.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.angularObjects != null ? this.angularObjects.hashCode() : 0);
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        result = 31 * result + (this.info != null ? this.info.hashCode() : 0);
        return result;
    }

    @VisibleForTesting
    public static Gson getGson() {
        return gson;
    }

    static {
        delayedPersistThreadPool.setRemoveOnCancelPolicy(true);
    }
}

