/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObjectRegistry;
import org.apache.zeppelin.notebook.ApplicationState;
import org.apache.zeppelin.notebook.Folder;
import org.apache.zeppelin.notebook.FolderView;
import org.apache.zeppelin.notebook.JobListenerFactory;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.notebook.NotebookEventListener;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notebook
implements NoteEventListener {
    private static final Logger logger = LoggerFactory.getLogger(Notebook.class);
    @Deprecated
    private SchedulerFactory schedulerFactory;
    private InterpreterFactory replFactory;
    private InterpreterSettingManager interpreterSettingManager;
    private final Map<String, Note> notes = new LinkedHashMap<String, Note>();
    private final FolderView folders = new FolderView();
    private ZeppelinConfiguration conf;
    private StdSchedulerFactory quertzSchedFact;
    Scheduler quartzSched;
    private JobListenerFactory jobListenerFactory;
    private NotebookRepo notebookRepo;
    private SearchService noteSearchService;
    private NotebookAuthorization notebookAuthorization;
    private final List<NotebookEventListener> notebookEventListeners = Collections.synchronizedList(new LinkedList());
    private Credentials credentials;

    public Notebook(ZeppelinConfiguration conf, NotebookRepo notebookRepo, SchedulerFactory schedulerFactory, InterpreterFactory replFactory, InterpreterSettingManager interpreterSettingManager, JobListenerFactory jobListenerFactory, SearchService noteSearchService, NotebookAuthorization notebookAuthorization, Credentials credentials) throws IOException, SchedulerException {
        this.conf = conf;
        this.notebookRepo = notebookRepo;
        this.schedulerFactory = schedulerFactory;
        this.replFactory = replFactory;
        this.interpreterSettingManager = interpreterSettingManager;
        this.jobListenerFactory = jobListenerFactory;
        this.noteSearchService = noteSearchService;
        this.notebookAuthorization = notebookAuthorization;
        this.credentials = credentials;
        this.quertzSchedFact = new StdSchedulerFactory();
        this.quartzSched = this.quertzSchedFact.getScheduler();
        this.quartzSched.start();
        CronJob.notebook = this;
        AuthenticationInfo anonymous = AuthenticationInfo.ANONYMOUS;
        this.loadAllNotes(anonymous);
        if (this.noteSearchService != null) {
            long start = System.nanoTime();
            logger.info("Notebook indexing started...");
            noteSearchService.addIndexDocs(this.notes.values());
            logger.info("Notebook indexing finished: {} indexed in {}s", (Object)this.notes.size(), (Object)TimeUnit.NANOSECONDS.toSeconds(start - System.nanoTime()));
        }
    }

    public Note createNote(AuthenticationInfo subject) throws IOException {
        Preconditions.checkNotNull((Object)subject, (Object)"AuthenticationInfo should not be null");
        Note note = this.conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AUTO_INTERPRETER_BINDING) ? this.createNote(this.interpreterSettingManager.getInterpreterSettingIds(), subject) : this.createNote(null, subject);
        this.noteSearchService.addIndexDoc(note);
        return note;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Note createNote(List<String> interpreterIds, AuthenticationInfo subject) throws IOException {
        Note note = new Note(this.notebookRepo, this.replFactory, this.interpreterSettingManager, this.jobListenerFactory, this.noteSearchService, this.credentials, this);
        note.setNoteNameListener(this.folders);
        Map<String, Note> map = this.notes;
        synchronized (map) {
            this.notes.put(note.getId(), note);
        }
        if (interpreterIds != null) {
            this.bindInterpretersToNote(subject.getUser(), note.getId(), interpreterIds);
        }
        this.notebookAuthorization.setNewNotePermissions(note.getId(), subject);
        this.noteSearchService.addIndexDoc(note);
        note.persist(subject);
        this.fireNoteCreateEvent(note);
        return note;
    }

    public String exportNote(String noteId) throws IOException, IllegalArgumentException {
        Note note = this.getNote(noteId);
        if (note == null) {
            throw new IllegalArgumentException(noteId + " not found");
        }
        return note.toJson();
    }

    public Note importNote(String sourceJson, String noteName, AuthenticationInfo subject) throws IOException {
        Note newNote;
        try {
            Note oldNote = Note.fromJson(sourceJson);
            this.convertFromSingleResultToMultipleResultsFormat(oldNote);
            newNote = this.createNote(subject);
            if (noteName != null) {
                newNote.setName(noteName);
            } else {
                newNote.setName(oldNote.getName());
            }
            newNote.setCronSupported(this.getConf());
            List<Paragraph> paragraphs = oldNote.getParagraphs();
            for (Paragraph p : paragraphs) {
                newNote.addCloneParagraph(p, subject);
            }
            this.notebookAuthorization.setNewNotePermissions(newNote.getId(), subject);
            newNote.persist(subject);
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
            throw e;
        }
        return newNote;
    }

    public Note cloneNote(String sourceNoteId, String newNoteName, AuthenticationInfo subject) throws IOException, CloneNotSupportedException, IllegalArgumentException {
        Note sourceNote = this.getNote(sourceNoteId);
        if (sourceNote == null) {
            throw new IllegalArgumentException(sourceNoteId + "not found");
        }
        Note newNote = this.createNote(subject);
        if (newNoteName != null) {
            newNote.setName(newNoteName);
        } else {
            newNote.setName("Note " + newNote.getId());
        }
        newNote.setCronSupported(this.getConf());
        List<String> boundInterpreterSettingsIds = this.getBindedInterpreterSettingsIds(sourceNote.getId());
        this.bindInterpretersToNote(subject.getUser(), newNote.getId(), boundInterpreterSettingsIds);
        List<Paragraph> paragraphs = sourceNote.getParagraphs();
        for (Paragraph p : paragraphs) {
            newNote.addCloneParagraph(p, subject);
        }
        this.noteSearchService.addIndexDoc(newNote);
        newNote.persist(subject);
        return newNote;
    }

    public void bindInterpretersToNote(String user, String id, List<String> interpreterSettingIds) throws IOException {
        Note note = this.getNote(id);
        if (note != null) {
            List<InterpreterSetting> currentBindings = this.interpreterSettingManager.getInterpreterSettings(id);
            for (InterpreterSetting setting : currentBindings) {
                if (interpreterSettingIds.contains(setting.getId())) continue;
                this.fireUnbindInterpreter(note, setting);
            }
            this.interpreterSettingManager.setInterpreterBinding(user, note.getId(), interpreterSettingIds);
        }
    }

    List<String> getBindedInterpreterSettingsIds(String id) {
        Note note = this.getNote(id);
        if (note != null) {
            return this.interpreterSettingManager.getInterpreterBinding(note.getId());
        }
        return new LinkedList<String>();
    }

    public List<InterpreterSetting> getBindedInterpreterSettings(String id) {
        Note note = this.getNote(id);
        if (note != null) {
            return this.interpreterSettingManager.getInterpreterSettings(note.getId());
        }
        return new LinkedList<InterpreterSetting>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Note getNote(String id) {
        Map<String, Note> map = this.notes;
        synchronized (map) {
            return this.notes.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder getFolder(String folderId) {
        FolderView folderView = this.folders;
        synchronized (folderView) {
            return this.folders.getFolder(folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFolder(String folderId) {
        FolderView folderView = this.folders;
        synchronized (folderView) {
            return this.folders.hasFolder(folderId);
        }
    }

    public void moveNoteToTrash(String noteId) {
        try {
            this.interpreterSettingManager.setInterpreterBinding("", noteId, new ArrayList<String>());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(String id, AuthenticationInfo subject) {
        Note note;
        Preconditions.checkNotNull((Object)subject, (Object)"AuthenticationInfo should not be null");
        Map<String, Note> map = this.notes;
        synchronized (map) {
            note = this.notes.remove(id);
            this.folders.removeNote(note);
        }
        try {
            this.interpreterSettingManager.removeNoteInterpreterSettingBinding(subject.getUser(), id);
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        this.noteSearchService.deleteIndexDocs(note);
        this.notebookAuthorization.removeNote(id);
        for (InterpreterSetting settings : this.interpreterSettingManager.get()) {
            List<ApplicationState> appStates;
            ManagedInterpreterGroup interpreterGroup = settings.getInterpreterGroup(subject.getUser(), id);
            if (interpreterGroup == null) continue;
            AngularObjectRegistry registry = interpreterGroup.getAngularObjectRegistry();
            if (registry instanceof RemoteAngularObjectRegistry) {
                for (Paragraph p : note.getParagraphs()) {
                    ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(id, p.getId());
                    appStates = p.getAllApplicationStates();
                    if (appStates == null) continue;
                    for (ApplicationState app : appStates) {
                        ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(id, app.getId());
                    }
                }
                ((RemoteAngularObjectRegistry)registry).removeAllAndNotifyRemoteProcess(id, null);
                continue;
            }
            for (Paragraph p : note.getParagraphs()) {
                registry.removeAll(id, p.getId());
                appStates = p.getAllApplicationStates();
                if (appStates == null) continue;
                for (ApplicationState app : appStates) {
                    registry.removeAll(id, app.getId());
                }
            }
            registry.removeAll(id, null);
        }
        this.interpreterSettingManager.removeResourcesBelongsToNote(id);
        this.fireNoteRemoveEvent(note);
        try {
            note.unpersist(subject);
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
    }

    public NotebookRepoWithVersionControl.Revision checkpointNote(String noteId, String checkpointMessage, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo().booleanValue()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).checkpoint(noteId, checkpointMessage, subject);
        }
        return null;
    }

    public List<NotebookRepoWithVersionControl.Revision> listRevisionHistory(String noteId, AuthenticationInfo subject) {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo().booleanValue()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).revisionHistory(noteId, subject);
        }
        return null;
    }

    public Note setNoteRevision(String noteId, String revisionId, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo().booleanValue()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).setNoteRevision(noteId, revisionId, subject);
        }
        return null;
    }

    public Note getNoteByRevision(String noteId, String revisionId, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo().booleanValue()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).get(noteId, revisionId, subject);
        }
        return null;
    }

    public void convertFromSingleResultToMultipleResultsFormat(Note note) {
        for (Paragraph p : note.paragraphs) {
            Object ret = p.getPreviousResultFormat();
            if (ret != null && p.results != null) continue;
            try {
                if (ret != null && ret instanceof Map) {
                    Map r = (Map)ret;
                    if (!r.containsKey("code") || !r.containsKey("msg") || !r.containsKey("type")) continue;
                    InterpreterResult.Code code = InterpreterResult.Code.valueOf((String)((String)r.get("code")));
                    InterpreterResult.Type type = InterpreterResult.Type.valueOf((String)((String)r.get("type")));
                    String msg = (String)r.get("msg");
                    InterpreterResult result = new InterpreterResult(code, msg);
                    if (result.message().size() == 1) {
                        result = new InterpreterResult(code);
                        result.add(type, msg);
                    }
                    p.setResult(result);
                    Map<String, Object> config = p.getConfig();
                    Object graph = config.remove("graph");
                    Object apps = config.remove("apps");
                    Object helium = config.remove("helium");
                    LinkedList results = new LinkedList();
                    for (int i = 0; i < result.message().size(); ++i) {
                        if (i == result.message().size() - 1) {
                            HashMap<String, Object> res = new HashMap<String, Object>();
                            res.put("graph", graph);
                            res.put("apps", apps);
                            res.put("helium", helium);
                            results.add(res);
                            continue;
                        }
                        results.add(new HashMap());
                    }
                    config.put("results", results);
                    continue;
                }
                if (ret != null || p.getConfig() == null || p.getConfig().get("graph") == null || !(p.getConfig().get("graph") instanceof Map) || ((Map)p.getConfig().get("graph")).get("mode").equals("table")) continue;
                Map<String, Object> config = p.getConfig();
                Object graph = config.remove("graph");
                Object apps = config.remove("apps");
                Object helium = config.remove("helium");
                LinkedList results = new LinkedList();
                HashMap<String, Object> res = new HashMap<String, Object>();
                res.put("graph", graph);
                res.put("apps", apps);
                res.put("helium", helium);
                results.add(res);
                config.put("results", results);
            }
            catch (Exception e) {
                logger.error("Conversion failure", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Note loadNoteFromRepo(String id, AuthenticationInfo subject) {
        Note note = null;
        try {
            note = this.notebookRepo.get(id, subject);
        }
        catch (IOException e) {
            logger.error("Failed to load " + id, (Throwable)e);
        }
        if (note == null) {
            return null;
        }
        this.convertFromSingleResultToMultipleResultsFormat(note);
        note.setIndex(this.noteSearchService);
        note.setCredentials(this.credentials);
        note.setInterpreterFactory(this.replFactory);
        note.setInterpreterSettingManager(this.interpreterSettingManager);
        note.setJobListenerFactory(this.jobListenerFactory);
        note.setNotebookRepo(this.notebookRepo);
        note.setCronSupported(this.getConf());
        HashMap<String, SnapshotAngularObject> angularObjectSnapshot = new HashMap<String, SnapshotAngularObject>();
        Date lastUpdatedDate = new Date(0L);
        for (Paragraph p : note.getParagraphs()) {
            p.setNote(note);
            if (p.getDateFinished() != null && lastUpdatedDate.before(p.getDateFinished())) {
                lastUpdatedDate = p.getDateFinished();
            }
            p.clearRuntimeInfo(null);
        }
        Map<String, List<AngularObject>> savedObjects = note.getAngularObjects();
        if (savedObjects != null) {
            for (String intpGroupName : savedObjects.keySet()) {
                List<AngularObject> objectList = savedObjects.get(intpGroupName);
                for (AngularObject object : objectList) {
                    SnapshotAngularObject snapshot = (SnapshotAngularObject)angularObjectSnapshot.get(object.getName());
                    if (snapshot != null && !snapshot.getLastUpdate().before(lastUpdatedDate)) continue;
                    angularObjectSnapshot.put(object.getName(), new SnapshotAngularObject(intpGroupName, object, lastUpdatedDate));
                }
            }
        }
        note.setNoteEventListener(this);
        note.setNoteNameListener(this.folders);
        Iterator iterator = this.notes;
        synchronized (iterator) {
            this.notes.put(note.getId(), note);
            this.folders.putNote(note);
            this.refreshCron(note.getId());
        }
        for (String name : angularObjectSnapshot.keySet()) {
            SnapshotAngularObject snapshot = (SnapshotAngularObject)angularObjectSnapshot.get(name);
            List<InterpreterSetting> settings = this.interpreterSettingManager.get();
            for (InterpreterSetting setting : settings) {
                ManagedInterpreterGroup intpGroup = setting.getInterpreterGroup(subject.getUser(), note.getId());
                if (intpGroup == null || !intpGroup.getId().equals(snapshot.getIntpGroupId())) continue;
                AngularObjectRegistry registry = intpGroup.getAngularObjectRegistry();
                String noteId = snapshot.getAngularObject().getNoteId();
                String paragraphId = snapshot.getAngularObject().getParagraphId();
                registry.add(name, snapshot.getAngularObject().get(), noteId, paragraphId);
            }
        }
        return note;
    }

    void loadAllNotes(AuthenticationInfo subject) throws IOException {
        List<NoteInfo> noteInfos = this.notebookRepo.list(subject);
        for (NoteInfo info : noteInfos) {
            this.loadNoteFromRepo(info.getId(), subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAllNotes(AuthenticationInfo subject) throws IOException {
        NotebookRepoSync mainRepo;
        Object object = this.notes;
        synchronized (object) {
            this.notes.clear();
        }
        object = this.folders;
        synchronized (object) {
            this.folders.clear();
        }
        if (this.notebookRepo instanceof NotebookRepoSync && (mainRepo = (NotebookRepoSync)this.notebookRepo).getRepoCount() > 1) {
            mainRepo.sync(subject);
        }
        List<NoteInfo> noteInfos = this.notebookRepo.list(subject);
        for (NoteInfo info : noteInfos) {
            this.loadNoteFromRepo(info.getId(), subject);
        }
    }

    public Folder renameFolder(String oldFolderId, String newFolderId) {
        return this.folders.renameFolder(oldFolderId, newFolderId);
    }

    public List<Note> getNotesUnderFolder(String folderId) {
        return this.folders.getFolder(folderId).getNotesRecursively();
    }

    public List<Note> getNotesUnderFolder(String folderId, Set<String> userAndRoles) {
        return this.folders.getFolder(folderId).getNotesRecursively(userAndRoles, this.notebookAuthorization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Note> getAllNotes() {
        Map<String, Note> map = this.notes;
        synchronized (map) {
            ArrayList<Note> noteList = new ArrayList<Note>(this.notes.values());
            Collections.sort(noteList, new Comparator<Note>(){

                @Override
                public int compare(Note note1, Note note2) {
                    String name1 = note1.getId();
                    if (note1.getName() != null) {
                        name1 = note1.getName();
                    }
                    String name2 = note2.getId();
                    if (note2.getName() != null) {
                        name2 = note2.getName();
                    }
                    return name1.compareTo(name2);
                }
            });
            return noteList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Note> getAllNotes(Set<String> userAndRoles) {
        final HashSet entities = Sets.newHashSet();
        if (userAndRoles != null) {
            entities.addAll(userAndRoles);
        }
        Map<String, Note> map = this.notes;
        synchronized (map) {
            return FluentIterable.from(this.notes.values()).filter((Predicate)new Predicate<Note>(){

                public boolean apply(Note input) {
                    return input != null && Notebook.this.notebookAuthorization.isReader(input.getId(), entities);
                }
            }).toSortedList((Comparator)new Comparator<Note>(){

                @Override
                public int compare(Note note1, Note note2) {
                    String name1 = note1.getId();
                    if (note1.getName() != null) {
                        name1 = note1.getName();
                    }
                    String name2 = note2.getId();
                    if (note2.getName() != null) {
                        name2 = note2.getName();
                    }
                    return name1.compareTo(name2);
                }
            });
        }
    }

    private Map<String, Object> getParagraphForJobManagerItem(Paragraph paragraph) {
        HashMap<String, Object> paragraphItem = new HashMap<String, Object>();
        paragraphItem.put("id", paragraph.getId());
        String paragraphName = paragraph.getTitle();
        if (paragraphName != null) {
            paragraphItem.put("name", paragraphName);
        } else {
            paragraphItem.put("name", paragraph.getId());
        }
        paragraphItem.put("status", paragraph.getStatus().toString());
        return paragraphItem;
    }

    private long getUnixTimeLastRunParagraph(Paragraph paragraph) {
        Date paragaraphDate = paragraph.getDateStarted();
        if (paragaraphDate == null) {
            paragaraphDate = paragraph.getDateFinished();
        } else if (paragraph.getDateFinished() != null && paragraph.getDateFinished().after(paragaraphDate)) {
            paragaraphDate = paragraph.getDateFinished();
        }
        if (paragaraphDate == null) {
            paragaraphDate = paragraph.getDateCreated();
        }
        Date lastRunningDate = paragaraphDate;
        long lastRunningUnixTime = lastRunningDate.getTime();
        return lastRunningUnixTime;
    }

    public List<Map<String, Object>> getJobListByParagraphId(String paragraphId) {
        String gotNoteId = null;
        List<Note> notes = this.getAllNotes();
        for (Note note : notes) {
            Paragraph p = note.getParagraph(paragraphId);
            if (p == null) continue;
            gotNoteId = note.getId();
        }
        return this.getJobListByNoteId(gotNoteId);
    }

    public List<Map<String, Object>> getJobListByNoteId(String noteId) {
        String CRON_TYPE_NOTE_KEYWORD = "cron";
        long lastRunningUnixTime = 0L;
        boolean isNoteRunning = false;
        Note jobNote = this.getNote(noteId);
        LinkedList<Map<String, Object>> notesInfo = new LinkedList<Map<String, Object>>();
        if (jobNote == null) {
            return notesInfo;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("noteId", jobNote.getId());
        String noteName = jobNote.getName();
        if (noteName != null && !noteName.equals("")) {
            info.put("noteName", jobNote.getName());
        } else {
            info.put("noteName", "Note " + jobNote.getId());
        }
        if (jobNote.getConfig().containsKey("cron") && !jobNote.getConfig().get("cron").equals("")) {
            info.put("noteType", "cron");
        } else {
            info.put("noteType", "normal");
        }
        LinkedList<Map<String, Object>> paragraphsInfo = new LinkedList<Map<String, Object>>();
        for (Paragraph paragraph : jobNote.getParagraphs()) {
            if (paragraph.getStatus().isRunning()) {
                isNoteRunning = true;
            }
            Map<String, Object> paragraphItem = this.getParagraphForJobManagerItem(paragraph);
            lastRunningUnixTime = this.getUnixTimeLastRunParagraph(paragraph);
            paragraphsInfo.add(paragraphItem);
        }
        String interpreterGroupName = null;
        if (this.interpreterSettingManager.getInterpreterSettings(jobNote.getId()) != null && this.interpreterSettingManager.getInterpreterSettings(jobNote.getId()).size() >= 1) {
            interpreterGroupName = this.interpreterSettingManager.getInterpreterSettings(jobNote.getId()).get(0).getName();
        }
        info.put("interpreter", interpreterGroupName);
        info.put("isRunningJob", isNoteRunning);
        info.put("unixTimeLastRun", lastRunningUnixTime);
        info.put("paragraphs", paragraphsInfo);
        notesInfo.add(info);
        return notesInfo;
    }

    public List<Map<String, Object>> getJobListByUnixTime(boolean needsReload, long lastUpdateServerUnixTime, AuthenticationInfo subject) {
        String CRON_TYPE_NOTE_KEYWORD = "cron";
        if (needsReload) {
            try {
                this.reloadAllNotes(subject);
            }
            catch (IOException e) {
                logger.error("Fail to reload notes from repository");
            }
        }
        List<Note> notes = this.getAllNotes();
        LinkedList<Map<String, Object>> notesInfo = new LinkedList<Map<String, Object>>();
        for (Note note : notes) {
            boolean isNoteRunning = false;
            boolean isUpdateNote = false;
            long lastRunningUnixTime = 0L;
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("noteId", note.getId());
            String noteName = note.getName();
            if (noteName != null && !noteName.equals("")) {
                info.put("noteName", note.getName());
            } else {
                info.put("noteName", "Note " + note.getId());
            }
            if (note.getConfig().containsKey("cron") && !note.getConfig().get("cron").equals("")) {
                info.put("noteType", "cron");
            } else {
                info.put("noteType", "normal");
            }
            LinkedList<Map<String, Object>> paragraphsInfo = new LinkedList<Map<String, Object>>();
            for (Paragraph paragraph : note.getParagraphs()) {
                if (paragraph.getStatus().isRunning()) {
                    isNoteRunning = true;
                    isUpdateNote = true;
                }
                Map<String, Object> paragraphItem = this.getParagraphForJobManagerItem(paragraph);
                lastRunningUnixTime = Math.max(this.getUnixTimeLastRunParagraph(paragraph), lastRunningUnixTime);
                if (lastRunningUnixTime > lastUpdateServerUnixTime) {
                    isUpdateNote = true;
                }
                paragraphsInfo.add(paragraphItem);
            }
            String interpreterGroupName = null;
            if (this.interpreterSettingManager.getInterpreterSettings(note.getId()) != null && this.interpreterSettingManager.getInterpreterSettings(note.getId()).size() >= 1) {
                interpreterGroupName = this.interpreterSettingManager.getInterpreterSettings(note.getId()).get(0).getName();
            }
            if (!isUpdateNote && !isNoteRunning) continue;
            info.put("interpreter", interpreterGroupName);
            info.put("isRunningJob", isNoteRunning);
            info.put("unixTimeLastRun", lastRunningUnixTime);
            info.put("paragraphs", paragraphsInfo);
            notesInfo.add(info);
        }
        return notesInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCron(String id) {
        this.removeCron(id);
        Map<String, Note> map = this.notes;
        synchronized (map) {
            Note note = this.notes.get(id);
            if (note == null || note.isTrash()) {
                return;
            }
            Map<String, Object> config = note.getConfig();
            if (config == null) {
                return;
            }
            if (!note.isCronSupported(this.getConf()).booleanValue()) {
                logger.warn("execution of the cron job is skipped cron is not enabled from Zeppelin server");
                return;
            }
            String cronExpr = (String)note.getConfig().get("cron");
            if (cronExpr == null || cronExpr.trim().length() == 0) {
                return;
            }
            JobDetail newJob = JobBuilder.newJob(CronJob.class).withIdentity(id, "note").usingJobData("noteId", id).build();
            Map<String, Object> info = note.getInfo();
            info.put("cron", null);
            CronTrigger trigger = null;
            try {
                trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger_" + id, "note").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpr)).forJob(id, "note").build();
            }
            catch (Exception e) {
                logger.error("Error", (Throwable)e);
                info.put("cron", e.getMessage());
            }
            try {
                if (trigger != null) {
                    this.quartzSched.scheduleJob(newJob, (Trigger)trigger);
                }
            }
            catch (SchedulerException e) {
                logger.error("Error", (Throwable)e);
                info.put("cron", "Scheduler Exception");
            }
        }
    }

    public void removeCron(String id) {
        try {
            this.quartzSched.deleteJob(new JobKey(id, "note"));
        }
        catch (SchedulerException e) {
            logger.error("Can't remove quertz " + id, (Throwable)e);
        }
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.replFactory;
    }

    public InterpreterSettingManager getInterpreterSettingManager() {
        return this.interpreterSettingManager;
    }

    public NotebookAuthorization getNotebookAuthorization() {
        return this.notebookAuthorization;
    }

    public ZeppelinConfiguration getConf() {
        return this.conf;
    }

    public void close() {
        this.notebookRepo.close();
        this.noteSearchService.close();
    }

    public void addNotebookEventListener(NotebookEventListener listener) {
        this.notebookEventListeners.add(listener);
    }

    private void fireNoteCreateEvent(Note note) {
        for (NotebookEventListener listener : this.notebookEventListeners) {
            listener.onNoteCreate(note);
        }
    }

    private void fireNoteRemoveEvent(Note note) {
        for (NotebookEventListener listener : this.notebookEventListeners) {
            listener.onNoteRemove(note);
        }
    }

    private void fireUnbindInterpreter(Note note, InterpreterSetting setting) {
        for (NotebookEventListener listener : this.notebookEventListeners) {
            listener.onUnbindInterpreter(note, setting);
        }
    }

    public Boolean isRevisionSupported() {
        if (this.notebookRepo instanceof NotebookRepoSync) {
            return ((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo();
        }
        if (this.notebookRepo instanceof NotebookRepoWithVersionControl) {
            return true;
        }
        return false;
    }

    @Override
    public void onParagraphRemove(Paragraph p) {
        for (NotebookEventListener listener : this.notebookEventListeners) {
            listener.onParagraphRemove(p);
        }
    }

    @Override
    public void onParagraphCreate(Paragraph p) {
        for (NotebookEventListener listener : this.notebookEventListeners) {
            listener.onParagraphCreate(p);
        }
    }

    @Override
    public void onParagraphStatusChange(Paragraph p, Job.Status status) {
        for (NotebookEventListener listener : this.notebookEventListeners) {
            listener.onParagraphStatusChange(p, status);
        }
    }

    public static class CronJob
    implements Job {
        public static Notebook notebook;

        public void execute(JobExecutionContext context) throws JobExecutionException {
            String noteId = context.getJobDetail().getJobDataMap().getString("noteId");
            Note note = notebook.getNote(noteId);
            if (note.isRunningOrPending()) {
                logger.warn("execution of the cron job is skipped because there is a running or pending paragraph (note id: {})", (Object)noteId);
                return;
            }
            if (!note.isCronSupported(notebook.getConf()).booleanValue()) {
                logger.warn("execution of the cron job is skipped cron is not enabled from Zeppelin server");
                return;
            }
            note.runAll();
            boolean releaseResource = false;
            String cronExecutingUser = null;
            try {
                Map<String, Object> config = note.getConfig();
                if (config != null) {
                    if (config.containsKey("releaseresource")) {
                        releaseResource = (Boolean)config.get("releaseresource");
                    }
                    cronExecutingUser = (String)config.get("cronExecutingUser");
                }
            }
            catch (ClassCastException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (releaseResource) {
                for (InterpreterSetting setting : notebook.getInterpreterSettingManager().getInterpreterSettings(note.getId())) {
                    try {
                        notebook.getInterpreterSettingManager().restart(setting.getId(), noteId, cronExecutingUser != null ? cronExecutingUser : "anonymous");
                    }
                    catch (InterpreterException e) {
                        logger.error("Fail to restart interpreter: " + setting.getId(), (Throwable)e);
                    }
                }
            }
        }
    }

    private class SnapshotAngularObject {
        String intpGroupId;
        AngularObject angularObject;
        Date lastUpdate;

        SnapshotAngularObject(String intpGroupId, AngularObject angularObject, Date lastUpdate) {
            this.intpGroupId = intpGroupId;
            this.angularObject = angularObject;
            this.lastUpdate = lastUpdate;
        }

        String getIntpGroupId() {
            return this.intpGroupId;
        }

        AngularObject getAngularObject() {
            return this.angularObject;
        }

        Date getLastUpdate() {
            return this.lastUpdate;
        }
    }
}

