/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NotebookAuthorizationInfoSaving;
import org.apache.zeppelin.storage.ConfigStorage;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookAuthorization {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookAuthorization.class);
    private static NotebookAuthorization instance = null;
    private static Map<String, Map<String, Set<String>>> authInfo = new HashMap<String, Map<String, Set<String>>>();
    private static Map<String, Set<String>> userRoles = new HashMap<String, Set<String>>();
    private static ZeppelinConfiguration conf;
    private static ConfigStorage configStorage;

    private NotebookAuthorization() {
    }

    public static NotebookAuthorization init(ZeppelinConfiguration config) {
        if (instance == null) {
            instance = new NotebookAuthorization();
            conf = config;
            try {
                configStorage = ConfigStorage.getInstance(config);
                NotebookAuthorization.loadFromFile();
            }
            catch (IOException e) {
                LOG.error("Error loading NotebookAuthorization", (Throwable)e);
            }
        }
        return instance;
    }

    public static NotebookAuthorization getInstance() {
        if (instance == null) {
            LOG.warn("Notebook authorization module was called without initialization, initializing with default configuration");
            NotebookAuthorization.init(ZeppelinConfiguration.create());
        }
        return instance;
    }

    private static void loadFromFile() throws IOException {
        NotebookAuthorizationInfoSaving info = configStorage.loadNotebookAuthorization();
        if (info != null) {
            authInfo = info.authInfo;
        }
    }

    public void setRoles(String user, Set<String> roles) {
        if (StringUtils.isBlank((String)user)) {
            LOG.warn("Setting roles for empty user");
            return;
        }
        roles = this.validateUser(roles);
        userRoles.put(user, roles);
    }

    public Set<String> getRoles(String user) {
        HashSet roles = Sets.newHashSet();
        if (userRoles.containsKey(user)) {
            roles.addAll((Collection)userRoles.get(user));
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        Map<String, Map<String, Set<String>>> map = authInfo;
        synchronized (map) {
            NotebookAuthorizationInfoSaving info = new NotebookAuthorizationInfoSaving();
            info.authInfo = authInfo;
            try {
                configStorage.save(info);
            }
            catch (IOException e) {
                LOG.error("Error saving notebook authorization file", (Throwable)e);
            }
        }
    }

    public boolean isPublic() {
        return conf.isNotebookPublic();
    }

    private Set<String> validateUser(Set<String> users) {
        HashSet<String> returnUser = new HashSet<String>();
        for (String user : users) {
            if (user.trim().isEmpty()) continue;
            returnUser.add(user.trim());
        }
        return returnUser;
    }

    public void setOwners(String noteId, Set<String> entities) {
        Map<String, Set<String>> noteAuthInfo = authInfo.get(noteId);
        entities = this.validateUser(entities);
        if (noteAuthInfo == null) {
            noteAuthInfo = new LinkedHashMap<String, Set<String>>();
            noteAuthInfo.put("owners", new LinkedHashSet<String>(entities));
            noteAuthInfo.put("readers", new LinkedHashSet());
            noteAuthInfo.put("runners", new LinkedHashSet());
            noteAuthInfo.put("writers", new LinkedHashSet());
        } else {
            noteAuthInfo.put("owners", new LinkedHashSet<String>(entities));
        }
        authInfo.put(noteId, noteAuthInfo);
        this.saveToFile();
    }

    public void setReaders(String noteId, Set<String> entities) {
        Map<String, Set<String>> noteAuthInfo = authInfo.get(noteId);
        entities = this.validateUser(entities);
        if (noteAuthInfo == null) {
            noteAuthInfo = new LinkedHashMap<String, Set<String>>();
            noteAuthInfo.put("owners", new LinkedHashSet());
            noteAuthInfo.put("readers", new LinkedHashSet<String>(entities));
            noteAuthInfo.put("runners", new LinkedHashSet());
            noteAuthInfo.put("writers", new LinkedHashSet());
        } else {
            noteAuthInfo.put("readers", new LinkedHashSet<String>(entities));
        }
        authInfo.put(noteId, noteAuthInfo);
        this.saveToFile();
    }

    public void setRunners(String noteId, Set<String> entities) {
        Map<String, Set<String>> noteAuthInfo = authInfo.get(noteId);
        entities = this.validateUser(entities);
        if (noteAuthInfo == null) {
            noteAuthInfo = new LinkedHashMap<String, Set<String>>();
            noteAuthInfo.put("owners", new LinkedHashSet());
            noteAuthInfo.put("readers", new LinkedHashSet());
            noteAuthInfo.put("runners", new LinkedHashSet<String>(entities));
            noteAuthInfo.put("writers", new LinkedHashSet());
        } else {
            noteAuthInfo.put("runners", new LinkedHashSet<String>(entities));
        }
        authInfo.put(noteId, noteAuthInfo);
        this.saveToFile();
    }

    public void setWriters(String noteId, Set<String> entities) {
        Map<String, Set<String>> noteAuthInfo = authInfo.get(noteId);
        entities = this.validateUser(entities);
        if (noteAuthInfo == null) {
            noteAuthInfo = new LinkedHashMap<String, Set<String>>();
            noteAuthInfo.put("owners", new LinkedHashSet());
            noteAuthInfo.put("readers", new LinkedHashSet());
            noteAuthInfo.put("runners", new LinkedHashSet());
            noteAuthInfo.put("writers", new LinkedHashSet<String>(entities));
        } else {
            noteAuthInfo.put("writers", new LinkedHashSet<String>(entities));
        }
        authInfo.put(noteId, noteAuthInfo);
        this.saveToFile();
    }

    private Set<String> checkCaseAndConvert(Set<String> entities) {
        if (conf.isUsernameForceLowerCase()) {
            HashSet<String> set2 = new HashSet<String>();
            for (String name : entities) {
                set2.add(name.toLowerCase());
            }
            return set2;
        }
        return entities;
    }

    public Set<String> getOwners(String noteId) {
        Map<String, Set<String>> noteAuthInfo = authInfo.get(noteId);
        Set<Object> entities = null;
        entities = noteAuthInfo == null ? new HashSet() : ((entities = noteAuthInfo.get("owners")) == null ? new HashSet() : this.checkCaseAndConvert(entities));
        return entities;
    }

    public Set<String> getReaders(String noteId) {
        Map<String, Set<String>> noteAuthInfo = authInfo.get(noteId);
        Set<Object> entities = null;
        entities = noteAuthInfo == null ? new HashSet() : ((entities = noteAuthInfo.get("readers")) == null ? new HashSet() : this.checkCaseAndConvert(entities));
        return entities;
    }

    public Set<String> getRunners(String noteId) {
        Map<String, Set<String>> noteAuthInfo = authInfo.get(noteId);
        Set<Object> entities = null;
        entities = noteAuthInfo == null ? new HashSet() : ((entities = noteAuthInfo.get("runners")) == null ? new HashSet() : this.checkCaseAndConvert(entities));
        return entities;
    }

    public Set<String> getWriters(String noteId) {
        Map<String, Set<String>> noteAuthInfo = authInfo.get(noteId);
        Set<Object> entities = null;
        entities = noteAuthInfo == null ? new HashSet() : ((entities = noteAuthInfo.get("writers")) == null ? new HashSet() : this.checkCaseAndConvert(entities));
        return entities;
    }

    public boolean isOwner(String noteId, Set<String> entities) {
        return this.isMember(entities, this.getOwners(noteId)) || this.isAdmin(entities);
    }

    public boolean isWriter(String noteId, Set<String> entities) {
        return this.isMember(entities, this.getWriters(noteId)) || this.isMember(entities, this.getOwners(noteId)) || this.isAdmin(entities);
    }

    public boolean isReader(String noteId, Set<String> entities) {
        return this.isMember(entities, this.getReaders(noteId)) || this.isMember(entities, this.getOwners(noteId)) || this.isMember(entities, this.getWriters(noteId)) || this.isMember(entities, this.getRunners(noteId)) || this.isAdmin(entities);
    }

    public boolean isRunner(String noteId, Set<String> entities) {
        return this.isMember(entities, this.getRunners(noteId)) || this.isMember(entities, this.getWriters(noteId)) || this.isMember(entities, this.getOwners(noteId)) || this.isAdmin(entities);
    }

    private boolean isAdmin(Set<String> entities) {
        String adminRole = conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_OWNER_ROLE);
        if (StringUtils.isBlank((String)adminRole)) {
            return false;
        }
        return entities.contains(adminRole);
    }

    private boolean isMember(Set<String> a, Set<String> b) {
        HashSet<String> intersection = new HashSet<String>(b);
        intersection.retainAll(a);
        return b.isEmpty() || intersection.size() > 0;
    }

    public boolean isOwner(Set<String> userAndRoles, String noteId) {
        if (conf.isAnonymousAllowed()) {
            LOG.debug("Zeppelin runs in anonymous mode, everybody is owner");
            return true;
        }
        if (userAndRoles == null) {
            return false;
        }
        return this.isOwner(noteId, userAndRoles);
    }

    public boolean hasWriteAuthorization(Set<String> userAndRoles, String noteId) {
        if (conf.isAnonymousAllowed()) {
            LOG.debug("Zeppelin runs in anonymous mode, everybody is writer");
            return true;
        }
        if (userAndRoles == null) {
            return false;
        }
        return this.isWriter(noteId, userAndRoles);
    }

    public boolean hasReadAuthorization(Set<String> userAndRoles, String noteId) {
        if (conf.isAnonymousAllowed()) {
            LOG.debug("Zeppelin runs in anonymous mode, everybody is reader");
            return true;
        }
        if (userAndRoles == null) {
            return false;
        }
        return this.isReader(noteId, userAndRoles);
    }

    public boolean hasRunAuthorization(Set<String> userAndRoles, String noteId) {
        if (conf.isAnonymousAllowed()) {
            LOG.debug("Zeppelin runs in anonymous mode, everybody is runner");
            return true;
        }
        if (userAndRoles == null) {
            return false;
        }
        return this.isRunner(noteId, userAndRoles);
    }

    public void removeNote(String noteId) {
        authInfo.remove(noteId);
        this.saveToFile();
    }

    public List<NoteInfo> filterByUser(List<NoteInfo> notes, AuthenticationInfo subject) {
        final HashSet entities = Sets.newHashSet();
        if (subject != null) {
            entities.add(subject.getUser());
        }
        return FluentIterable.from(notes).filter((Predicate)new Predicate<NoteInfo>(){

            public boolean apply(NoteInfo input) {
                return input != null && NotebookAuthorization.this.isReader(input.getId(), entities);
            }
        }).toList();
    }

    public void setNewNotePermissions(String noteId, AuthenticationInfo subject) {
        if (!AuthenticationInfo.isAnonymous((AuthenticationInfo)subject)) {
            if (this.isPublic()) {
                Set<String> owners = this.getOwners(noteId);
                owners.add(subject.getUser());
                this.setOwners(noteId, owners);
            } else {
                Set<String> entities = this.getOwners(noteId);
                entities.add(subject.getUser());
                this.setOwners(noteId, entities);
                entities = this.getReaders(noteId);
                entities.add(subject.getUser());
                this.setReaders(noteId, entities);
                entities = this.getRunners(noteId);
                entities.add(subject.getUser());
                this.setRunners(noteId, entities);
                entities = this.getWriters(noteId);
                entities.add(subject.getUser());
                this.setWriters(noteId, entities);
            }
        }
    }
}

