/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.notebook.ApplicationState;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.ParagraphRuntimeInfo;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.user.UserCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paragraph
extends Job
implements Cloneable,
JsonSerializable {
    private static Logger logger = LoggerFactory.getLogger(Paragraph.class);
    private static Pattern REPL_PATTERN = Pattern.compile("(\\s*)%([\\w\\.]+).*", 32);
    private transient InterpreterFactory interpreterFactory;
    private transient Interpreter interpreter;
    private transient Note note;
    private transient AuthenticationInfo authenticationInfo;
    private transient Map<String, Paragraph> userParagraphMap = Maps.newHashMap();
    private String title;
    private String text;
    private transient String intpText;
    private transient String scriptText;
    private String user;
    private Date dateUpdated;
    private Map<String, Object> config = new HashMap<String, Object>();
    public GUI settings = new GUI();
    volatile Object results;
    volatile Object result;
    private Map<String, ParagraphRuntimeInfo> runtimeInfos;
    private final List<ApplicationState> apps = new LinkedList<ApplicationState>();

    @VisibleForTesting
    Paragraph() {
        super(Paragraph.generateId(), null);
    }

    public Paragraph(String paragraphId, Note note, JobListener listener, InterpreterFactory interpreterFactory) {
        super(paragraphId, Paragraph.generateId(), listener);
        this.note = note;
        this.interpreterFactory = interpreterFactory;
    }

    public Paragraph(Note note, JobListener listener, InterpreterFactory interpreterFactory) {
        super(Paragraph.generateId(), listener);
        this.note = note;
        this.interpreterFactory = interpreterFactory;
    }

    private static String generateId() {
        return "paragraph_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt();
    }

    public Map<String, Paragraph> getUserParagraphMap() {
        return this.userParagraphMap;
    }

    public Paragraph getUserParagraph(String user) {
        if (!this.userParagraphMap.containsKey(user)) {
            this.cloneParagraphForUser(user);
        }
        return this.userParagraphMap.get(user);
    }

    public synchronized void setResult(Object results) {
        this.results = results;
    }

    public Paragraph cloneParagraphForUser(String user) {
        Paragraph p = new Paragraph();
        p.interpreterFactory = this.interpreterFactory;
        p.note = this.note;
        p.settings.setParams((Map)Maps.newHashMap((Map)this.settings.getParams()));
        p.settings.setForms(Maps.newLinkedHashMap((Map)this.settings.getForms()));
        p.setConfig(Maps.newHashMap(this.config));
        if (this.getAuthenticationInfo() != null) {
            p.setAuthenticationInfo(this.getAuthenticationInfo());
        }
        p.setTitle(this.getTitle());
        p.setText(this.getText());
        p.setResult(this.getReturn());
        p.setStatus(Job.Status.READY);
        p.setId(this.getId());
        this.addUser(p, user);
        return p;
    }

    public void clearUserParagraphs() {
        this.userParagraphMap.clear();
    }

    public void addUser(Paragraph p, String user) {
        this.userParagraphMap.put(user, p);
    }

    public String getUser() {
        return this.user;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.dateUpdated = new Date();
        this.parseText();
    }

    public void parseText() {
        if (this.text != null) {
            Matcher matcher = REPL_PATTERN.matcher(this.text);
            if (matcher.matches()) {
                String headingSpace = matcher.group(1);
                this.intpText = matcher.group(2);
                this.scriptText = this.text.substring(headingSpace.length() + this.intpText.length() + 1).trim();
            } else {
                this.intpText = "";
                this.scriptText = this.text.trim();
            }
        }
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
        this.user = authenticationInfo.getUser();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIntpText() {
        return this.intpText;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setNote(Note note) {
        this.note = note;
    }

    public Note getNote() {
        return this.note;
    }

    public boolean isEnabled() {
        Boolean enabled = (Boolean)this.config.get("enabled");
        return enabled == null || enabled != false;
    }

    public Interpreter getBindedInterpreter() throws InterpreterNotFoundException {
        return this.interpreterFactory.getInterpreter(this.user, this.note.getId(), this.intpText);
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public List<InterpreterCompletion> completion(String buffer, int cursor) {
        int idx;
        String[] lines = buffer.split(System.getProperty("line.separator"));
        if (lines.length > 0 && lines[0].startsWith("%") && cursor <= lines[0].trim().length() && ((idx = lines[0].indexOf(32)) < 0 || idx > 0 && cursor <= idx)) {
            return this.note.getInterpreterCompletion();
        }
        try {
            this.interpreter = this.getBindedInterpreter();
        }
        catch (InterpreterNotFoundException e) {
            return null;
        }
        this.setText(buffer);
        cursor = this.calculateCursorPosition(buffer, cursor);
        InterpreterContext interpreterContext = this.getInterpreterContextWithoutRunner(null);
        try {
            if (this.interpreter != null) {
                return this.interpreter.completion(this.scriptText, cursor, interpreterContext);
            }
            return null;
        }
        catch (InterpreterException e) {
            throw new RuntimeException("Fail to get completion", e);
        }
    }

    public int calculateCursorPosition(String buffer, int cursor) {
        if (this.scriptText.isEmpty()) {
            return 0;
        }
        int countCharactersBeforeScript = buffer.indexOf(this.scriptText);
        if (countCharactersBeforeScript > 0) {
            cursor -= countCharactersBeforeScript;
        }
        return cursor;
    }

    public void setInterpreterFactory(InterpreterFactory factory) {
        this.interpreterFactory = factory;
    }

    public InterpreterResult getResult() {
        return (InterpreterResult)this.getReturn();
    }

    public synchronized Object getReturn() {
        return this.results;
    }

    public Object getPreviousResultFormat() {
        return this.result;
    }

    public int progress() {
        try {
            if (this.interpreter != null) {
                return this.interpreter.getProgress(this.getInterpreterContext(null));
            }
            return 0;
        }
        catch (InterpreterException e) {
            throw new RuntimeException("Fail to get progress", e);
        }
    }

    public Map<String, Object> info() {
        return null;
    }

    private boolean hasPermission(List<String> userAndRoles, List<String> intpUsersAndRoles) {
        if (1 > intpUsersAndRoles.size()) {
            return true;
        }
        HashSet<String> intersection = new HashSet<String>(intpUsersAndRoles);
        intersection.retainAll(userAndRoles);
        return intpUsersAndRoles.isEmpty() || intersection.size() > 0;
    }

    public boolean isBlankParagraph() {
        return Strings.isNullOrEmpty((String)this.scriptText);
    }

    public boolean execute(boolean blocking) {
        if (this.isBlankParagraph()) {
            logger.info("skip to run blank paragraph. {}", (Object)this.getId());
            this.setStatus(Job.Status.FINISHED);
            return true;
        }
        this.clearRuntimeInfo(null);
        try {
            this.interpreter = this.getBindedInterpreter();
            this.setStatus(Job.Status.READY);
            if (this.getConfig().get("enabled") == null || ((Boolean)this.getConfig().get("enabled")).booleanValue()) {
                this.setAuthenticationInfo(this.getAuthenticationInfo());
                this.interpreter.getScheduler().submit((Job)this);
            }
            if (blocking) {
                while (!this.getStatus().isCompleted()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.getStatus() == Job.Status.FINISHED;
            }
            return true;
        }
        catch (InterpreterNotFoundException e) {
            InterpreterResult intpResult = new InterpreterResult(InterpreterResult.Code.ERROR);
            this.setReturn(intpResult, (Throwable)((Object)e));
            this.setStatus(Job.Status.ERROR);
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object jobRun() throws Throwable {
        Object angularRegistry;
        logger.info("Run paragraph [paragraph_id: {}, interpreter: {}, note_id: {}, user: {}]", new Object[]{this.getId(), this.intpText, this.note.getId(), this.authenticationInfo.getUser()});
        this.interpreter = this.getBindedInterpreter();
        if (this.interpreter == null) {
            logger.error("Can not find interpreter name " + this.intpText);
            throw new RuntimeException("Can not find interpreter for " + this.intpText);
        }
        InterpreterSetting interpreterSetting = ((ManagedInterpreterGroup)this.interpreter.getInterpreterGroup()).getInterpreterSetting();
        if (interpreterSetting != null) {
            interpreterSetting.waitForReady();
        }
        if (this.hasUser() && this.note.hasInterpreterBinded() && interpreterSetting != null && this.interpreterHasUser(interpreterSetting) && !this.isUserAuthorizedToAccessInterpreter(interpreterSetting.getOption())) {
            logger.error("{} has no permission for {} ", (Object)this.authenticationInfo.getUser(), (Object)this.intpText);
            return new InterpreterResult(InterpreterResult.Code.ERROR, this.authenticationInfo.getUser() + " has no permission for " + this.intpText);
        }
        for (Paragraph p : this.userParagraphMap.values()) {
            p.setText(this.getText());
        }
        String script = this.scriptText;
        if (this.interpreter.getFormType() == Interpreter.FormType.NATIVE) {
            this.settings.clear();
        } else if (this.interpreter.getFormType() == Interpreter.FormType.SIMPLE) {
            LinkedHashMap inputs = Input.extractSimpleQueryForm((String)script, (boolean)false);
            LinkedHashMap noteInputs = Input.extractSimpleQueryForm((String)script, (boolean)true);
            angularRegistry = this.interpreter.getInterpreterGroup().getAngularObjectRegistry();
            String scriptBody = this.extractVariablesFromAngularRegistry(script, inputs, (AngularObjectRegistry)angularRegistry);
            this.settings.setForms(inputs);
            if (!noteInputs.isEmpty()) {
                if (!this.note.getNoteForms().isEmpty()) {
                    LinkedHashMap<String, Input> currentNoteForms = this.note.getNoteForms();
                    for (String s : noteInputs.keySet()) {
                        if (currentNoteForms.containsKey(s)) continue;
                        currentNoteForms.put(s, (Input)noteInputs.get(s));
                    }
                } else {
                    this.note.setNoteForms(noteInputs);
                }
            }
            script = Input.getSimpleQuery(this.note.getNoteParams(), (String)scriptBody, (boolean)true);
            script = Input.getSimpleQuery((Map)this.settings.getParams(), (String)script, (boolean)false);
        }
        logger.debug("RUN : " + script);
        try {
            InterpreterContext context = this.getInterpreterContext();
            InterpreterContext.set((InterpreterContext)context);
            InterpreterResult ret = this.interpreter.interpret(script, context);
            if (this.interpreter.getFormType() == Interpreter.FormType.NATIVE) {
                this.note.setNoteParams(context.getNoteGui().getParams());
                this.note.setNoteForms(context.getNoteGui().getForms());
            }
            if (InterpreterResult.Code.KEEP_PREVIOUS_RESULT == ret.code()) {
                angularRegistry = this.getReturn();
                return angularRegistry;
            }
            context.out.flush();
            List resultMessages = context.out.toInterpreterResultMessage();
            resultMessages.addAll(ret.message());
            InterpreterResult res = new InterpreterResult(ret.code(), resultMessages);
            Paragraph p = this.getUserParagraph(this.getUser());
            if (null != p) {
                p.setResult(res);
                p.settings.setParams(this.settings.getParams());
            }
            InterpreterResult interpreterResult = res;
            return interpreterResult;
        }
        finally {
            InterpreterContext.remove();
        }
    }

    private boolean hasUser() {
        return this.user != null;
    }

    private boolean interpreterHasUser(InterpreterSetting interpreterSetting) {
        return interpreterSetting.getOption().permissionIsSet() && interpreterSetting.getOption().getOwners() != null;
    }

    private boolean isUserAuthorizedToAccessInterpreter(InterpreterOption intpOpt) {
        return intpOpt.permissionIsSet() && this.hasPermission(this.authenticationInfo.getUsersAndRoles(), intpOpt.getOwners());
    }

    protected boolean jobAbort() {
        if (this.interpreter == null) {
            return true;
        }
        Scheduler scheduler = this.interpreter.getScheduler();
        if (scheduler == null) {
            return true;
        }
        Job job = scheduler.removeFromWaitingQueue(this.getId());
        if (job != null) {
            job.setStatus(Job.Status.ABORT);
        } else {
            try {
                this.interpreter.cancel(this.getInterpreterContextWithoutRunner(null));
            }
            catch (InterpreterException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private InterpreterContext getInterpreterContext() {
        final Paragraph self = this;
        return this.getInterpreterContext(new InterpreterOutput(new InterpreterOutputListener(){

            public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
                ((ParagraphJobListener)Paragraph.this.getListener()).onOutputAppend(self, index, new String(line));
            }

            public void onUpdate(int index, InterpreterResultMessageOutput out) {
                try {
                    ((ParagraphJobListener)Paragraph.this.getListener()).onOutputUpdate(self, index, out.toInterpreterResultMessage());
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }

            public void onUpdateAll(InterpreterOutput out) {
                try {
                    List messages = out.toInterpreterResultMessage();
                    ((ParagraphJobListener)Paragraph.this.getListener()).onOutputUpdateAll(self, messages);
                    this.updateParagraphResult(messages);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }

            private void updateParagraphResult(List<InterpreterResultMessage> msgs) {
                InterpreterResult result = new InterpreterResult(InterpreterResult.Code.SUCCESS, msgs);
                Paragraph.this.setReturn(result, null);
            }
        }));
    }

    private InterpreterContext getInterpreterContextWithoutRunner(InterpreterOutput output) {
        AngularObjectRegistry registry = null;
        ResourcePool resourcePool = null;
        if (this.interpreter != null) {
            registry = this.interpreter.getInterpreterGroup().getAngularObjectRegistry();
            resourcePool = this.interpreter.getInterpreterGroup().getResourcePool();
        }
        LinkedList runners = new LinkedList();
        Paragraph self = this;
        Credentials credentials = this.note.getCredentials();
        this.setAuthenticationInfo(new AuthenticationInfo(this.getUser()));
        if (this.authenticationInfo.getUser() != null) {
            UserCredentials userCredentials = credentials.getUserCredentials(this.authenticationInfo.getUser());
            this.authenticationInfo.setUserCredentials(userCredentials);
        }
        InterpreterContext interpreterContext = new InterpreterContext(this.note.getId(), this.getId(), this.intpText, this.getTitle(), this.getText(), this.getAuthenticationInfo(), this.getConfig(), this.settings, this.getNoteGui(), registry, resourcePool, runners, output);
        return interpreterContext;
    }

    private InterpreterContext getInterpreterContext(InterpreterOutput output) {
        AngularObjectRegistry registry = null;
        ResourcePool resourcePool = null;
        if (this.interpreter != null) {
            registry = this.interpreter.getInterpreterGroup().getAngularObjectRegistry();
            resourcePool = this.interpreter.getInterpreterGroup().getResourcePool();
        }
        LinkedList<ParagraphRunner> runners = new LinkedList<ParagraphRunner>();
        for (Paragraph p : this.note.getParagraphs()) {
            runners.add(new ParagraphRunner(this.note, this.note.getId(), p.getId()));
        }
        Paragraph self = this;
        Credentials credentials = this.note.getCredentials();
        if (this.authenticationInfo != null) {
            UserCredentials userCredentials = credentials.getUserCredentials(this.authenticationInfo.getUser());
            this.authenticationInfo.setUserCredentials(userCredentials);
        }
        InterpreterContext interpreterContext = new InterpreterContext(this.note.getId(), this.getId(), this.intpText, this.getTitle(), this.getText(), this.getAuthenticationInfo(), this.getConfig(), this.settings, this.getNoteGui(), registry, resourcePool, runners, output);
        return interpreterContext;
    }

    public InterpreterContextRunner getInterpreterContextRunner() {
        return new ParagraphRunner(this.note, this.note.getId(), this.getId());
    }

    public void setStatusToUserParagraph(Job.Status status) {
        String user = this.getUser();
        if (null != user) {
            this.getUserParagraph(this.getUser()).setStatus(status);
        }
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public void setReturn(InterpreterResult value, Throwable t) {
        this.setResult(value);
        this.setException(t);
    }

    public Object clone() throws CloneNotSupportedException {
        Paragraph paraClone = (Paragraph)this.clone();
        return paraClone;
    }

    private String getApplicationId(HeliumPackage pkg) {
        return "app_" + this.getNote().getId() + "-" + this.getId() + pkg.getName().replaceAll("\\.", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationState createOrGetApplicationState(HeliumPackage pkg) {
        List<ApplicationState> list = this.apps;
        synchronized (list) {
            for (ApplicationState as : this.apps) {
                if (!as.equals(pkg)) continue;
                return as;
            }
            String appId = this.getApplicationId(pkg);
            ApplicationState appState = new ApplicationState(appId, pkg);
            this.apps.add(appState);
            return appState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationState getApplicationState(String appId) {
        List<ApplicationState> list = this.apps;
        synchronized (list) {
            for (ApplicationState as : this.apps) {
                if (!as.getId().equals(appId)) continue;
                return as;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationState> getAllApplicationStates() {
        List<ApplicationState> list = this.apps;
        synchronized (list) {
            return new LinkedList<ApplicationState>(this.apps);
        }
    }

    String extractVariablesFromAngularRegistry(String scriptBody, Map<String, Input> inputs, AngularObjectRegistry angularRegistry) {
        String noteId = this.getNote().getId();
        String paragraphId = this.getId();
        HashSet<String> keys = new HashSet<String>(inputs.keySet());
        for (String varName : keys) {
            AngularObject paragraphScoped = angularRegistry.get(varName, noteId, paragraphId);
            AngularObject noteScoped = angularRegistry.get(varName, noteId, null);
            AngularObject angularObject = paragraphScoped != null ? paragraphScoped : noteScoped;
            if (angularObject == null) continue;
            inputs.remove(varName);
            String pattern = "[$][{]\\s*" + varName + "\\s*(?:=[^}]+)?[}]";
            scriptBody = scriptBody.replaceAll(pattern, angularObject.get().toString());
        }
        return scriptBody;
    }

    public boolean isValidInterpreter(String replName) {
        try {
            return this.interpreterFactory.getInterpreter(this.user, this.note.getId(), replName) != null;
        }
        catch (InterpreterNotFoundException e) {
            return false;
        }
    }

    public void updateRuntimeInfos(String label, String tooltip, Map<String, String> infos, String group, String intpSettingId) {
        if (this.runtimeInfos == null) {
            this.runtimeInfos = new HashMap<String, ParagraphRuntimeInfo>();
        }
        if (infos != null) {
            for (String key : infos.keySet()) {
                ParagraphRuntimeInfo info = this.runtimeInfos.get(key);
                if (info == null) {
                    info = new ParagraphRuntimeInfo(key, label, tooltip, group, intpSettingId);
                    this.runtimeInfos.put(key, info);
                }
                info.addValue(infos.get(key));
            }
        }
    }

    public void clearRuntimeInfo(String settingId) {
        if (settingId != null && this.runtimeInfos != null) {
            Set<String> keys = this.runtimeInfos.keySet();
            if (keys.size() > 0) {
                ArrayList<String> infosToRemove = new ArrayList<String>();
                for (String key : keys) {
                    ParagraphRuntimeInfo paragraphRuntimeInfo = this.runtimeInfos.get(key);
                    if (!paragraphRuntimeInfo.getInterpreterSettingId().equals(settingId)) continue;
                    infosToRemove.add(key);
                }
                if (infosToRemove.size() > 0) {
                    for (String info : infosToRemove) {
                        this.runtimeInfos.remove(info);
                    }
                }
            }
        } else {
            this.runtimeInfos = null;
        }
    }

    public void clearRuntimeInfos() {
        if (this.runtimeInfos != null) {
            this.runtimeInfos.clear();
        }
    }

    public Map<String, ParagraphRuntimeInfo> getRuntimeInfos() {
        return this.runtimeInfos;
    }

    private GUI getNoteGui() {
        GUI gui = new GUI();
        gui.setParams(this.note.getNoteParams());
        gui.setForms(this.note.getNoteForms());
        return gui;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Paragraph paragraph = (Paragraph)o;
        if (this.title != null ? !this.title.equals(paragraph.title) : paragraph.title != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(paragraph.text) : paragraph.text != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(paragraph.user) : paragraph.user != null) {
            return false;
        }
        if (this.dateUpdated != null ? !this.dateUpdated.equals(paragraph.dateUpdated) : paragraph.dateUpdated != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(paragraph.config) : paragraph.config != null) {
            return false;
        }
        if (this.settings != null ? !this.settings.equals((Object)paragraph.settings) : paragraph.settings != null) {
            return false;
        }
        if (this.results != null ? !this.results.equals(paragraph.results) : paragraph.results != null) {
            return false;
        }
        if (this.result != null ? !this.result.equals(paragraph.result) : paragraph.result != null) {
            return false;
        }
        return this.runtimeInfos != null ? this.runtimeInfos.equals(paragraph.runtimeInfos) : paragraph.runtimeInfos == null;
    }

    public int hashCode() {
        int result1 = super.hashCode();
        result1 = 31 * result1 + (this.title != null ? this.title.hashCode() : 0);
        result1 = 31 * result1 + (this.text != null ? this.text.hashCode() : 0);
        result1 = 31 * result1 + (this.user != null ? this.user.hashCode() : 0);
        result1 = 31 * result1 + (this.dateUpdated != null ? this.dateUpdated.hashCode() : 0);
        result1 = 31 * result1 + (this.config != null ? this.config.hashCode() : 0);
        result1 = 31 * result1 + (this.settings != null ? this.settings.hashCode() : 0);
        result1 = 31 * result1 + (this.results != null ? this.results.hashCode() : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        result1 = 31 * result1 + (this.runtimeInfos != null ? this.runtimeInfos.hashCode() : 0);
        return result1;
    }

    public String toJson() {
        return Note.getGson().toJson((Object)this);
    }

    public static Paragraph fromJson(String json) {
        return (Paragraph)Note.getGson().fromJson(json, Paragraph.class);
    }

    static class ParagraphRunner
    extends InterpreterContextRunner {
        private transient Note note;

        public ParagraphRunner(Note note, String noteId, String paragraphId) {
            super(noteId, paragraphId);
            this.note = note;
        }

        public void run() {
            this.note.run(this.getParagraphId(), false);
        }
    }
}

