/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.file.CloudFile;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileDirectory;
import com.microsoft.azure.storage.file.CloudFileShare;
import com.microsoft.azure.storage.file.FileInputStream;
import com.microsoft.azure.storage.file.ListFileItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.notebook.repo.S3NotebookRepo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureNotebookRepo
implements NotebookRepo {
    private static final Logger LOG = LoggerFactory.getLogger(S3NotebookRepo.class);
    private final ZeppelinConfiguration conf;
    private final String user;
    private final String shareName;
    private final CloudFileDirectory rootDir;

    public AzureNotebookRepo(ZeppelinConfiguration conf) throws URISyntaxException, InvalidKeyException, StorageException {
        this.conf = conf;
        this.user = conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_USER);
        this.shareName = conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_SHARE);
        CloudStorageAccount account = CloudStorageAccount.parse((String)conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_CONNECTION_STRING));
        CloudFileClient client = account.createCloudFileClient();
        CloudFileShare share = client.getShareReference(this.shareName);
        share.createIfNotExists();
        CloudFileDirectory userDir = StringUtils.isBlank((String)this.user) ? share.getRootDirectoryReference() : share.getRootDirectoryReference().getDirectoryReference(this.user);
        userDir.createIfNotExists();
        this.rootDir = userDir.getDirectoryReference("notebook");
        this.rootDir.createIfNotExists();
    }

    @Override
    public List<NoteInfo> list(AuthenticationInfo subject) throws IOException {
        LinkedList<NoteInfo> infos = new LinkedList<NoteInfo>();
        NoteInfo info = null;
        for (ListFileItem item : this.rootDir.listFilesAndDirectories()) {
            if (item.getClass() != CloudFileDirectory.class) continue;
            CloudFileDirectory dir = (CloudFileDirectory)item;
            try {
                if (!dir.getFileReference("note.json").exists() || (info = new NoteInfo(this.getNote(dir.getName()))) == null) continue;
                infos.add(info);
            }
            catch (StorageException | URISyntaxException e) {
                String msg = "Error enumerating notebooks from Azure storage";
                LOG.error(msg, e);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return infos;
    }

    private Note getNote(String noteId) throws IOException {
        FileInputStream ins = null;
        try {
            CloudFileDirectory dir = this.rootDir.getDirectoryReference(noteId);
            CloudFile file = dir.getFileReference("note.json");
            ins = file.openRead();
        }
        catch (StorageException | URISyntaxException e) {
            String msg = String.format("Error reading notebook %s from Azure storage", noteId);
            LOG.error(msg, e);
            throw new IOException(msg, e);
        }
        String json = IOUtils.toString((InputStream)ins, (String)this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ENCODING));
        ins.close();
        return Note.fromJson(json);
    }

    @Override
    public Note get(String noteId, AuthenticationInfo subject) throws IOException {
        return this.getNote(noteId);
    }

    @Override
    public void save(Note note, AuthenticationInfo subject) throws IOException {
        String json = note.toJson();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(output);
        writer.write(json);
        ((Writer)writer).close();
        output.close();
        byte[] buffer = output.toByteArray();
        try {
            CloudFileDirectory dir = this.rootDir.getDirectoryReference(note.getId());
            dir.createIfNotExists();
            CloudFile cloudFile = dir.getFileReference("note.json");
            cloudFile.uploadFromByteArray(buffer, 0, buffer.length);
        }
        catch (StorageException | URISyntaxException e) {
            String msg = String.format("Error saving notebook %s to Azure storage", note.getId());
            LOG.error(msg, e);
            throw new IOException(msg, e);
        }
    }

    private void delete(ListFileItem item) throws StorageException {
        if (item.getClass() == CloudFileDirectory.class) {
            CloudFileDirectory dir = (CloudFileDirectory)item;
            for (ListFileItem subItem : dir.listFilesAndDirectories()) {
                this.delete(subItem);
            }
            dir.deleteIfExists();
        } else if (item.getClass() == CloudFile.class) {
            CloudFile file = (CloudFile)item;
            file.deleteIfExists();
        }
    }

    @Override
    public void remove(String noteId, AuthenticationInfo subject) throws IOException {
        try {
            CloudFileDirectory dir = this.rootDir.getDirectoryReference(noteId);
            this.delete((ListFileItem)dir);
        }
        catch (StorageException | URISyntaxException e) {
            String msg = String.format("Error deleting notebook %s from Azure storage", noteId);
            LOG.error(msg, e);
            throw new IOException(msg, e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOG.warn("Method not implemented");
        return Collections.emptyList();
    }

    @Override
    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOG.warn("Method not implemented");
    }
}

