/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.FileSystemStorage;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemNotebookRepo
implements NotebookRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemNotebookRepo.class);
    private FileSystemStorage fs;
    private Path notebookDir;

    public FileSystemNotebookRepo(ZeppelinConfiguration zConf) throws IOException {
        this.fs = new FileSystemStorage(zConf, zConf.getNotebookDir());
        LOGGER.info("Creating FileSystem: " + this.fs.getFs().getClass().getName() + " for Zeppelin Notebook.");
        this.notebookDir = this.fs.makeQualified(new Path(zConf.getNotebookDir()));
        LOGGER.info("Using folder {} to store notebook", (Object)this.notebookDir);
        this.fs.tryMkDir(this.notebookDir);
    }

    @Override
    public List<NoteInfo> list(AuthenticationInfo subject) throws IOException {
        List<Path> notePaths = this.fs.list(new Path(this.notebookDir, "*/note.json"));
        ArrayList<NoteInfo> noteInfos = new ArrayList<NoteInfo>();
        for (Path path : notePaths) {
            NoteInfo noteInfo = new NoteInfo(path.getParent().getName(), "", null);
            noteInfos.add(noteInfo);
        }
        return noteInfos;
    }

    @Override
    public Note get(String noteId, AuthenticationInfo subject) throws IOException {
        String content = this.fs.readFile(new Path(this.notebookDir.toString() + "/" + noteId + "/note.json"));
        return Note.fromJson(content);
    }

    @Override
    public void save(Note note, AuthenticationInfo subject) throws IOException {
        this.fs.writeFile(note.toJson(), new Path(this.notebookDir.toString() + "/" + note.getId() + "/note.json"), true);
    }

    @Override
    public void remove(String noteId, AuthenticationInfo subject) throws IOException {
        this.fs.delete(new Path(this.notebookDir.toString() + "/" + noteId));
    }

    @Override
    public void close() {
        LOGGER.warn("close is not implemented for HdfsNotebookRepo");
    }

    @Override
    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOGGER.warn("getSettings is not implemented for HdfsNotebookRepo");
        return null;
    }

    @Override
    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOGGER.warn("updateSettings is not implemented for HdfsNotebookRepo");
    }
}

