/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.notebook.repo.VFSNotebookRepo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitNotebookRepo
extends VFSNotebookRepo
implements NotebookRepoWithVersionControl {
    private static final Logger LOG = LoggerFactory.getLogger(GitNotebookRepo.class);
    private String localPath = this.getRootDir().getName().getPath();
    private Git git;

    public GitNotebookRepo(ZeppelinConfiguration conf) throws IOException {
        super(conf);
        LOG.info("Opening a git repo at '{}'", (Object)this.localPath);
        FileRepository localRepo = new FileRepository(Joiner.on((String)File.separator).join((Object)this.localPath, (Object)".git", new Object[0]));
        if (!localRepo.getDirectory().exists()) {
            LOG.info("Git repo {} does not exist, creating a new one", (Object)localRepo.getDirectory());
            localRepo.create();
        }
        this.git = new Git((Repository)localRepo);
    }

    @Override
    public synchronized void save(Note note, AuthenticationInfo subject) throws IOException {
        super.save(note, subject);
    }

    @Override
    public NotebookRepoWithVersionControl.Revision checkpoint(String pattern, String commitMessage, AuthenticationInfo subject) {
        NotebookRepoWithVersionControl.Revision revision = NotebookRepoWithVersionControl.Revision.EMPTY;
        try {
            List gitDiff = this.git.diff().call();
            if (!gitDiff.isEmpty()) {
                LOG.debug("Changes found for pattern '{}': {}", (Object)pattern, (Object)gitDiff);
                DirCache added = this.git.add().addFilepattern(pattern).call();
                LOG.debug("{} changes are about to be commited", (Object)added.getEntryCount());
                RevCommit commit = this.git.commit().setMessage(commitMessage).call();
                revision = new NotebookRepoWithVersionControl.Revision(commit.getName(), commit.getShortMessage(), commit.getCommitTime());
            } else {
                LOG.debug("No changes found {}", (Object)pattern);
            }
        }
        catch (GitAPIException e) {
            LOG.error("Failed to add+commit {} to Git", (Object)pattern, (Object)e);
        }
        return revision;
    }

    @Override
    public synchronized Note get(String noteId, String revId, AuthenticationInfo subject) throws IOException {
        Note note = null;
        RevCommit stash = null;
        try {
            boolean modified;
            List gitDiff = this.git.diff().setPathFilter((TreeFilter)PathFilter.create((String)noteId)).call();
            boolean bl = modified = !gitDiff.isEmpty();
            if (modified) {
                stash = this.git.stashCreate().call();
                Collection stashes = this.git.stashList().call();
                LOG.debug("Created stash : {}, stash size : {}", (Object)stash, (Object)stashes.size());
            }
            ObjectId head = this.git.getRepository().resolve("HEAD");
            this.git.checkout().setStartPoint(revId).addPath(noteId).call();
            note = super.get(noteId, subject);
            this.git.checkout().setStartPoint(head.getName()).addPath(noteId).call();
            if (modified && stash != null) {
                ObjectId applied = this.git.stashApply().setStashRef(stash.getName()).call();
                ObjectId dropped = this.git.stashDrop().setStashRef(0).call();
                Collection stashes = this.git.stashList().call();
                LOG.debug("Stash applied as : {}, and dropped : {}, stash size: {}", new Object[]{applied, dropped, stashes.size()});
            }
        }
        catch (GitAPIException e) {
            LOG.error("Failed to return note from revision \"{}\"", (Object)revId, (Object)e);
        }
        return note;
    }

    @Override
    public List<NotebookRepoWithVersionControl.Revision> revisionHistory(String noteId, AuthenticationInfo subject) {
        ArrayList history = Lists.newArrayList();
        LOG.debug("Listing history for {}:", (Object)noteId);
        try {
            Iterable logs = this.git.log().addPath(noteId).call();
            for (RevCommit log : logs) {
                history.add(new NotebookRepoWithVersionControl.Revision(log.getName(), log.getShortMessage(), log.getCommitTime()));
                LOG.debug(" - ({},{},{})", new Object[]{log.getName(), log.getCommitTime(), log.getFullMessage()});
            }
        }
        catch (NoHeadException e) {
            LOG.warn("No Head found for {}, {}", (Object)noteId, (Object)e.getMessage());
        }
        catch (GitAPIException e) {
            LOG.error("Failed to get logs for {}", (Object)noteId, (Object)e);
        }
        return history;
    }

    @Override
    public Note setNoteRevision(String noteId, String revId, AuthenticationInfo subject) throws IOException {
        Note revisionNote = this.get(noteId, revId, subject);
        if (revisionNote != null) {
            this.save(revisionNote, subject);
        }
        return revisionNote;
    }

    @Override
    public void close() {
        this.git.getRepository().close();
    }

    protected Git getGit() {
        return this.git;
    }

    void setGit(Git git) {
        this.git = git;
    }
}

