/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3NotebookRepo
implements NotebookRepo {
    private static final Logger LOG = LoggerFactory.getLogger(S3NotebookRepo.class);
    private final AmazonS3 s3client;
    private final String bucketName;
    private final String user;
    private final boolean useServerSideEncryption;
    private final ZeppelinConfiguration conf;

    public S3NotebookRepo(ZeppelinConfiguration conf) throws IOException {
        this.conf = conf;
        this.bucketName = conf.getS3BucketName();
        this.user = conf.getS3User();
        this.useServerSideEncryption = conf.isS3ServerSideEncryption();
        DefaultAWSCredentialsProviderChain credentialsProvider = new DefaultAWSCredentialsProviderChain();
        CryptoConfiguration cryptoConf = new CryptoConfiguration();
        String keyRegion = conf.getS3KMSKeyRegion();
        if (StringUtils.isNotBlank((CharSequence)keyRegion)) {
            cryptoConf.setAwsKmsRegion(Region.getRegion((Regions)Regions.fromName((String)keyRegion)));
        }
        ClientConfiguration cliConf = this.createClientConfiguration();
        String kmsKeyID = conf.getS3KMSKeyID();
        if (kmsKeyID != null) {
            KMSEncryptionMaterialsProvider emp = new KMSEncryptionMaterialsProvider(kmsKeyID);
            this.s3client = new AmazonS3EncryptionClient((AWSCredentialsProvider)credentialsProvider, (EncryptionMaterialsProvider)emp, cliConf, cryptoConf);
        } else if (conf.getS3EncryptionMaterialsProviderClass() != null) {
            EncryptionMaterialsProvider emp = this.createCustomProvider(conf);
            this.s3client = new AmazonS3EncryptionClient((AWSCredentialsProvider)credentialsProvider, emp, cliConf, cryptoConf);
        } else {
            this.s3client = new AmazonS3Client((AWSCredentialsProvider)credentialsProvider, cliConf);
        }
        this.s3client.setEndpoint(conf.getS3Endpoint());
    }

    private EncryptionMaterialsProvider createCustomProvider(ZeppelinConfiguration conf) throws IOException {
        EncryptionMaterialsProvider emp;
        String empClassname = conf.getS3EncryptionMaterialsProviderClass();
        try {
            Object empInstance = Class.forName(empClassname).newInstance();
            if (!(empInstance instanceof EncryptionMaterialsProvider)) {
                throw new IOException("Class " + empClassname + " does not implement " + EncryptionMaterialsProvider.class.getName());
            }
            emp = (EncryptionMaterialsProvider)empInstance;
        }
        catch (Exception e) {
            throw new IOException("Unable to instantiate encryption materials provider class " + empClassname + ": " + e, e);
        }
        return emp;
    }

    private ClientConfiguration createClientConfiguration() {
        ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
        ClientConfiguration config = configFactory.getConfig();
        String s3SignerOverride = this.conf.getS3SignerOverride();
        if (StringUtils.isNotBlank((CharSequence)s3SignerOverride)) {
            config.setSignerOverride(s3SignerOverride);
        }
        return config;
    }

    @Override
    public List<NoteInfo> list(AuthenticationInfo subject) throws IOException {
        LinkedList<NoteInfo> infos = new LinkedList<NoteInfo>();
        try {
            ObjectListing objectListing;
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(this.user + "/notebook");
            do {
                objectListing = this.s3client.listObjects(listObjectsRequest);
                for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                    NoteInfo info;
                    if (!objectSummary.getKey().endsWith("note.json") || (info = this.getNoteInfo(objectSummary.getKey())) == null) continue;
                    infos.add(info);
                }
                listObjectsRequest.setMarker(objectListing.getNextMarker());
            } while (objectListing.isTruncated());
        }
        catch (AmazonClientException ace) {
            throw new IOException("Unable to list objects in S3: " + (Object)((Object)ace), ace);
        }
        return infos;
    }

    private Note getNote(String key) throws IOException {
        S3Object s3object;
        try {
            s3object = this.s3client.getObject(new GetObjectRequest(this.bucketName, key));
        }
        catch (AmazonClientException ace) {
            throw new IOException("Unable to retrieve object from S3: " + (Object)((Object)ace), ace);
        }
        try (S3ObjectInputStream ins = s3object.getObjectContent();){
            String json = IOUtils.toString((InputStream)ins, (String)this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ENCODING));
            Note note = Note.fromJson(json);
            return note;
        }
    }

    private NoteInfo getNoteInfo(String key) throws IOException {
        Note note = this.getNote(key);
        return new NoteInfo(note);
    }

    @Override
    public Note get(String noteId, AuthenticationInfo subject) throws IOException {
        return this.getNote(this.user + "/notebook/" + noteId + "/note.json");
    }

    @Override
    public void save(Note note, AuthenticationInfo subject) throws IOException {
        String json = note.toJson();
        String key = this.user + "/notebook/" + note.getId() + "/note.json";
        File file = File.createTempFile("note", "json");
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            writer.write(json);
            ((Writer)writer).close();
            PutObjectRequest putRequest = new PutObjectRequest(this.bucketName, key, file);
            if (this.useServerSideEncryption) {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                putRequest.setMetadata(objectMetadata);
            }
            this.s3client.putObject(putRequest);
        }
        catch (AmazonClientException ace) {
            throw new IOException("Unable to store note in S3: " + (Object)((Object)ace), ace);
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
    }

    @Override
    public void remove(String noteId, AuthenticationInfo subject) throws IOException {
        String key = this.user + "/notebook/" + noteId;
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(key);
        try {
            ObjectListing objects = this.s3client.listObjects(listObjectsRequest);
            do {
                for (S3ObjectSummary objectSummary : objects.getObjectSummaries()) {
                    this.s3client.deleteObject(this.bucketName, objectSummary.getKey());
                }
            } while ((objects = this.s3client.listNextBatchOfObjects(objects)).isTruncated());
        }
        catch (AmazonClientException ace) {
            throw new IOException("Unable to remove note in S3: " + (Object)((Object)ace), ace);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOG.warn("Method not implemented");
        return Collections.emptyList();
    }

    @Override
    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOG.warn("Method not implemented");
    }
}

