/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.Instance;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.UserSessionContainer;
import org.apache.zeppelin.notebook.repo.zeppelinhub.rest.ZeppelinhubRestApiHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTokenContainer {
    private static final Logger LOG = LoggerFactory.getLogger(UserTokenContainer.class);
    private static UserTokenContainer instance = null;
    private ConcurrentMap<String, String> userTokens = new ConcurrentHashMap<String, String>();
    private final ZeppelinhubRestApiHandler restApiClient;
    private String defaultToken;

    public static UserTokenContainer init(ZeppelinhubRestApiHandler restClient, String defaultToken) {
        if (instance == null) {
            instance = new UserTokenContainer(restClient, defaultToken);
        }
        return instance;
    }

    private UserTokenContainer(ZeppelinhubRestApiHandler restClient, String defaultToken) {
        this.restApiClient = restClient;
        this.defaultToken = defaultToken;
    }

    public static UserTokenContainer getInstance() {
        return instance;
    }

    public void setUserToken(String username, String token) {
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)token)) {
            LOG.warn("Can't set empty user token");
            return;
        }
        this.userTokens.put(username, token);
    }

    public String getUserToken(String principal) {
        if (StringUtils.isBlank((String)principal) || "anonymous".equals(principal)) {
            if (StringUtils.isBlank((String)this.defaultToken)) {
                return "";
            }
            this.userTokens.putIfAbsent(principal, this.defaultToken);
            return this.defaultToken;
        }
        String token = (String)this.userTokens.get(principal);
        if (StringUtils.isBlank((String)token)) {
            String ticket = UserSessionContainer.instance.getSession(principal);
            try {
                token = this.getDefaultZeppelinInstanceToken(ticket);
                if (StringUtils.isBlank((String)token)) {
                    if (!StringUtils.isBlank((String)this.defaultToken)) {
                        token = this.defaultToken;
                    }
                } else {
                    this.userTokens.putIfAbsent(principal, token);
                }
            }
            catch (IOException e) {
                LOG.error("Cannot get user token", (Throwable)e);
                token = "";
            }
        }
        return token;
    }

    public String getExistingUserToken(String principal) {
        if (StringUtils.isBlank((String)principal) || "anonymous".equals(principal)) {
            return "";
        }
        String token = (String)this.userTokens.get(principal);
        if (token == null) {
            return "";
        }
        return token;
    }

    public String removeUserToken(String username) {
        return (String)this.userTokens.remove(username);
    }

    public String getDefaultZeppelinInstanceToken(String ticket) throws IOException {
        List<Instance> instances = this.getUserInstances(ticket);
        if (instances.isEmpty()) {
            return "";
        }
        String token = instances.get((int)0).token;
        LOG.debug("The following instance has been assigned {} with token {}", (Object)instances.get((int)0).name, (Object)token);
        return token;
    }

    public List<Instance> getUserInstances(String ticket) throws IOException {
        if (StringUtils.isBlank((String)ticket)) {
            return Collections.emptyList();
        }
        return this.restApiClient.getInstances(ticket);
    }

    public List<String> getAllTokens() {
        return new ArrayList<String>(this.userTokens.values());
    }

    public Map<String, String> getAllUserTokens() {
        return new HashMap<String, String>(this.userTokens);
    }
}

