/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket;

import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.ZeppelinClient;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.ZeppelinhubClient;
import org.apache.zeppelin.notebook.socket.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private final ZeppelinhubClient zeppelinhubClient;
    private final ZeppelinClient zeppelinClient;
    private static Client instance = null;
    private static final int MB = 0x100000;
    private static final int MAXIMUM_NOTE_SIZE = 0x4000000;

    public static Client initialize(String zeppelinUri, String zeppelinhubUri, String token, ZeppelinConfiguration conf) {
        if (instance == null) {
            instance = new Client(zeppelinUri, zeppelinhubUri, token, conf);
        }
        return instance;
    }

    public static Client getInstance() {
        return instance;
    }

    private Client(String zeppelinUri, String zeppelinhubUri, String token, ZeppelinConfiguration conf) {
        LOG.debug("Init Client");
        this.zeppelinhubClient = ZeppelinhubClient.initialize(zeppelinhubUri, token);
        this.zeppelinClient = ZeppelinClient.initialize(zeppelinUri, token, conf);
    }

    public void start() {
        if (this.zeppelinhubClient != null) {
            this.zeppelinhubClient.start();
        }
        if (this.zeppelinClient != null) {
            this.zeppelinClient.start();
        }
    }

    public void stop() {
        if (this.zeppelinhubClient != null) {
            this.zeppelinhubClient.stop();
        }
        if (this.zeppelinClient != null) {
            this.zeppelinClient.stop();
        }
    }

    public void relayToZeppelinHub(String message, String token) {
        this.zeppelinhubClient.send(message, token);
    }

    public void relayToZeppelin(Message message, String noteId) {
        this.zeppelinClient.send(message, noteId);
    }

    public static int getMaxNoteSize() {
        return 0x4000000;
    }
}

