/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.UserTokenContainer;
import org.apache.zeppelin.notebook.repo.zeppelinhub.security.Authentication;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.Client;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.listener.WatcherWebsocket;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.listener.ZeppelinWebsocket;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.protocol.ZeppelinhubMessage;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.scheduler.SchedulerService;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.scheduler.ZeppelinHeartbeat;
import org.apache.zeppelin.notebook.socket.Message;
import org.apache.zeppelin.util.WatcherSecurityKey;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZeppelinClient.class);
    private final URI zeppelinWebsocketUrl;
    private final WebSocketClient wsClient;
    private ConcurrentHashMap<String, Session> notesConnection;
    private static Session watcherSession;
    private static ZeppelinClient instance;
    private SchedulerService schedulerService;
    private Authentication authModule;
    private static final int MIN = 60;
    private static final String ORIGIN = "Origin";
    private static final Set<String> actionable;

    public static ZeppelinClient initialize(String zeppelinUrl, String token, ZeppelinConfiguration conf) {
        if (instance == null) {
            instance = new ZeppelinClient(zeppelinUrl, token, conf);
        }
        return instance;
    }

    public static ZeppelinClient getInstance() {
        return instance;
    }

    private ZeppelinClient(String zeppelinUrl, String token, ZeppelinConfiguration conf) {
        this.zeppelinWebsocketUrl = URI.create(zeppelinUrl);
        this.wsClient = this.createNewWebsocketClient();
        this.notesConnection = new ConcurrentHashMap();
        this.schedulerService = SchedulerService.getInstance();
        this.authModule = Authentication.initialize(token, conf);
        if (this.authModule != null) {
            SchedulerService.getInstance().addOnce(this.authModule, 10);
        }
        LOG.info("Initialized Zeppelin websocket client on {}", (Object)this.zeppelinWebsocketUrl);
    }

    private WebSocketClient createNewWebsocketClient() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        WebSocketClient client = new WebSocketClient(sslContextFactory);
        client.setMaxIdleTimeout(300000L);
        client.setMaxTextMessageBufferSize(Client.getMaxNoteSize());
        client.getPolicy().setMaxTextMessageSize(Client.getMaxNoteSize());
        return client;
    }

    public void start() {
        try {
            if (this.wsClient != null) {
                this.wsClient.start();
                this.addRoutines();
            } else {
                LOG.warn("Cannot start zeppelin websocket client - isn't initialized");
            }
        }
        catch (Exception e) {
            LOG.error("Cannot start Zeppelin websocket client", (Throwable)e);
        }
    }

    private void addRoutines() {
        this.schedulerService.add(ZeppelinHeartbeat.newInstance(this), 10, 60);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                int time = 0;
                while (time < 300) {
                    watcherSession = ZeppelinClient.this.openWatcherSession();
                    if (watcherSession != null) break;
                    try {
                        Thread.sleep(5000L);
                        time += 5;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, 5000L);
    }

    public void stop() {
        try {
            if (this.wsClient != null) {
                this.removeAllConnections();
                this.wsClient.stop();
            } else {
                LOG.warn("Cannot stop zeppelin websocket client - isn't initialized");
            }
            if (watcherSession != null) {
                watcherSession.close();
            }
        }
        catch (Exception e) {
            LOG.error("Cannot stop Zeppelin websocket client", (Throwable)e);
        }
    }

    public String serialize(Message zeppelinMsg) {
        if (this.credentialsAvailable()) {
            zeppelinMsg.principal = this.authModule.getPrincipal();
            zeppelinMsg.ticket = this.authModule.getTicket();
            zeppelinMsg.roles = this.authModule.getRoles();
        }
        String msg = zeppelinMsg.toJson();
        return msg;
    }

    private boolean credentialsAvailable() {
        return Authentication.getInstance() != null && Authentication.getInstance().isAuthenticated();
    }

    public Message deserialize(String zeppelinMessage) {
        if (StringUtils.isBlank((CharSequence)zeppelinMessage)) {
            return null;
        }
        try {
            return Message.fromJson(zeppelinMessage);
        }
        catch (Exception e) {
            LOG.error("Fail to parse zeppelinMessage", (Throwable)e);
            return null;
        }
    }

    private Session openWatcherSession() {
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("X-Watcher-Key", WatcherSecurityKey.getKey());
        request.setHeader(ORIGIN, "*");
        WatcherWebsocket socket = WatcherWebsocket.createInstace();
        Future future = null;
        Session session = null;
        try {
            future = this.wsClient.connect((Object)socket, this.zeppelinWebsocketUrl, request);
            session = (Session)future.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.error("Couldn't establish websocket connection to Zeppelin ", (Throwable)e);
            return session;
        }
        return session;
    }

    public void send(Message msg, String noteId) {
        Session noteSession = this.getZeppelinConnection(noteId, msg.principal, msg.ticket);
        if (!this.isSessionOpen(noteSession)) {
            LOG.error("Cannot open websocket connection to Zeppelin note {}", (Object)noteId);
            return;
        }
        noteSession.getRemote().sendStringByFuture(this.serialize(msg));
    }

    public Session getZeppelinConnection(String noteId, String principal, String ticket) {
        if (StringUtils.isBlank((CharSequence)noteId)) {
            LOG.warn("Cannot get Websocket session with blanck noteId");
            return null;
        }
        return this.getNoteSession(noteId, principal, ticket);
    }

    private Session getNoteSession(String noteId, String principal, String ticket) {
        LOG.info("Getting Note websocket connection for note {}", (Object)noteId);
        Session session = this.notesConnection.get(noteId);
        if (!this.isSessionOpen(session)) {
            LOG.info("No open connection for note {}, opening one", (Object)noteId);
            this.notesConnection.remove(noteId);
            session = this.openNoteSession(noteId, principal, ticket);
        }
        return session;
    }

    private Session openNoteSession(String noteId, String principal, String ticket) {
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader(ORIGIN, "*");
        ZeppelinWebsocket socket = new ZeppelinWebsocket(noteId);
        Future future = null;
        Session session = null;
        try {
            future = this.wsClient.connect((Object)socket, this.zeppelinWebsocketUrl, request);
            session = (Session)future.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.error("Couldn't establish websocket connection to Zeppelin ", (Throwable)e);
            return session;
        }
        if (this.notesConnection.containsKey(noteId)) {
            session.close();
            session = this.notesConnection.get(noteId);
        } else {
            String getNote = this.serialize(this.zeppelinGetNoteMsg(noteId, principal, ticket));
            session.getRemote().sendStringByFuture(getNote);
            this.notesConnection.put(noteId, session);
        }
        return session;
    }

    private boolean isSessionOpen(Session session) {
        return session != null && session.isOpen();
    }

    private Message zeppelinGetNoteMsg(String noteId, String principal, String ticket) {
        Message getNoteMsg = new Message(Message.OP.GET_NOTE);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", noteId);
        getNoteMsg.data = data;
        getNoteMsg.principal = principal;
        getNoteMsg.ticket = ticket;
        return getNoteMsg;
    }

    public void handleMsgFromZeppelin(String message, String noteId) {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("noteId", noteId);
        Message zeppelinMsg = this.deserialize(message);
        if (zeppelinMsg == null) {
            return;
        }
        if (!this.isActionable(zeppelinMsg.op)) {
            return;
        }
        String token = UserTokenContainer.getInstance().getUserToken(zeppelinMsg.principal);
        Client client = Client.getInstance();
        if (client == null) {
            LOG.warn("Client isn't initialized yet");
            return;
        }
        ZeppelinhubMessage hubMsg = ZeppelinhubMessage.newMessage(zeppelinMsg, meta);
        if (StringUtils.isEmpty((CharSequence)token)) {
            this.relayToAllZeppelinHub(hubMsg, noteId);
        } else {
            client.relayToZeppelinHub(hubMsg.toJson(), token);
        }
    }

    private void relayToAllZeppelinHub(ZeppelinhubMessage hubMsg, String noteId) {
        if (StringUtils.isBlank((CharSequence)noteId)) {
            return;
        }
        NotebookAuthorization noteAuth = NotebookAuthorization.getInstance();
        Map<String, String> userTokens = UserTokenContainer.getInstance().getAllUserTokens();
        Client client = Client.getInstance();
        for (String user : userTokens.keySet()) {
            Set<String> userAndRoles = noteAuth.getRoles(user);
            userAndRoles.add(user);
            if (!noteAuth.isReader(noteId, userAndRoles)) continue;
            String token = userTokens.get(user);
            hubMsg.meta.put("token", token);
            client.relayToZeppelinHub(hubMsg.toJson(), token);
        }
    }

    private boolean isActionable(Message.OP action) {
        if (action == null) {
            return false;
        }
        return actionable.contains(action.name());
    }

    public void removeNoteConnection(String noteId) {
        if (StringUtils.isBlank((CharSequence)noteId)) {
            LOG.error("Cannot remove session for empty noteId");
            return;
        }
        if (this.notesConnection.containsKey(noteId)) {
            Session connection = this.notesConnection.get(noteId);
            if (connection.isOpen()) {
                connection.close();
            }
            this.notesConnection.remove(noteId);
        }
        LOG.info("Removed note websocket connection for note {}", (Object)noteId);
    }

    private void removeAllConnections() {
        if (watcherSession != null && watcherSession.isOpen()) {
            watcherSession.close();
        }
        Session noteSession = null;
        for (Map.Entry<String, Session> note : this.notesConnection.entrySet()) {
            noteSession = note.getValue();
            if (!this.isSessionOpen(noteSession)) continue;
            noteSession.close();
        }
        this.notesConnection.clear();
    }

    public void ping() {
        if (watcherSession == null) {
            LOG.debug("Cannot send PING event, no watcher found");
            return;
        }
        watcherSession.getRemote().sendStringByFuture(this.serialize(new Message(Message.OP.PING)));
    }

    public int countConnectedNotes() {
        return this.notesConnection.size();
    }

    static {
        instance = null;
        actionable = new HashSet<String>(Arrays.asList("ANGULAR_OBJECT_UPDATE", "PROGRESS", "NOTE", "PARAGRAPH", "PARAGRAPH_UPDATE_OUTPUT", "PARAGRAPH_APPEND_OUTPUT", "PARAGRAPH_CLEAR_OUTPUT", "PARAGRAPH_REMOVE", "RUN_PARAGRAPH", "CANCEL_PARAGRAPH"));
    }
}

