/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.listener;

import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.ZeppelinClient;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.listener.ZeppelinWebsocket;
import org.apache.zeppelin.notebook.socket.Message;
import org.apache.zeppelin.notebook.socket.WatcherMessage;
import org.apache.zeppelin.ticket.TicketContainer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherWebsocket
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZeppelinWebsocket.class);
    private static final String watcherPrincipal = "watcher";
    public Session connection;

    public static WatcherWebsocket createInstace() {
        return new WatcherWebsocket();
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketClose(int code, String reason) {
        LOG.info("WatcherWebsocket connection closed with code: {}, message: {}", (Object)code, (Object)reason);
    }

    public void onWebSocketConnect(Session session) {
        LOG.info("WatcherWebsocket connection opened");
        this.connection = session;
        Message watcherMsg = new Message(Message.OP.WATCHER);
        watcherMsg.principal = watcherPrincipal;
        watcherMsg.ticket = TicketContainer.instance.getTicket(watcherPrincipal);
        session.getRemote().sendStringByFuture(watcherMsg.toJson());
    }

    public void onWebSocketError(Throwable cause) {
        LOG.warn("WatcherWebsocket socket connection error ", cause);
    }

    public void onWebSocketText(String message) {
        WatcherMessage watcherMsg = WatcherMessage.fromJson(message);
        if (StringUtils.isBlank((String)watcherMsg.noteId)) {
            return;
        }
        try {
            ZeppelinClient zeppelinClient = ZeppelinClient.getInstance();
            if (zeppelinClient != null) {
                zeppelinClient.handleMsgFromZeppelin(watcherMsg.message, watcherMsg.noteId);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to send message to ZeppelinHub: ", (Throwable)e);
        }
    }
}

