/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.listener;

import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.ZeppelinhubClient;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.utils.ZeppelinhubUtils;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinhubWebsocket
implements WebSocketListener {
    private Logger LOG = LoggerFactory.getLogger(ZeppelinhubWebsocket.class);
    private Session zeppelinHubSession;
    private final String token;

    private ZeppelinhubWebsocket(String token) {
        this.token = token;
    }

    public static ZeppelinhubWebsocket newInstance(String token) {
        return new ZeppelinhubWebsocket(token);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.LOG.info("Closing websocket connection [{}] : {}", (Object)statusCode, (Object)reason);
        this.send(ZeppelinhubUtils.deadMessage(this.token));
        this.zeppelinHubSession = null;
    }

    public void onWebSocketConnect(Session session) {
        this.LOG.info("Opening a new session to Zeppelinhub {}", (Object)session.hashCode());
        this.zeppelinHubSession = session;
        this.send(ZeppelinhubUtils.liveMessage(this.token));
    }

    public void onWebSocketError(Throwable cause) {
        this.LOG.error("Remote websocket error");
    }

    public void onWebSocketText(String message) {
        ZeppelinhubClient client = ZeppelinhubClient.getInstance();
        if (client != null) {
            client.handleMsgFromZeppelinHub(message);
        }
    }

    private boolean isSessionOpen() {
        return this.zeppelinHubSession != null && this.zeppelinHubSession.isOpen();
    }

    private void send(String msg) {
        if (this.isSessionOpen()) {
            this.zeppelinHubSession.getRemote().sendStringByFuture(msg);
        }
    }
}

