/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.protocol;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.Client;
import org.apache.zeppelin.notebook.socket.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinhubMessage
implements JsonSerializable {
    private static final Gson gson = new Gson();
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    public static final ZeppelinhubMessage EMPTY = new ZeppelinhubMessage();
    public Object op;
    public Object data;
    public Map<String, String> meta = Maps.newHashMap();

    private ZeppelinhubMessage() {
        this.op = Message.OP.LIST_NOTES;
        this.data = null;
    }

    private ZeppelinhubMessage(Object op, Object data, Map<String, String> meta) {
        this.op = op;
        this.data = data;
        this.meta = meta;
    }

    public static ZeppelinhubMessage newMessage(Object op, Object data, Map<String, String> meta) {
        return new ZeppelinhubMessage(op, data, meta);
    }

    public static ZeppelinhubMessage newMessage(Message zeppelinMsg, Map<String, String> meta) {
        if (zeppelinMsg == null) {
            return EMPTY;
        }
        return new ZeppelinhubMessage((Object)zeppelinMsg.op, zeppelinMsg.data, meta);
    }

    public String toJson() {
        return gson.toJson((Object)this, ZeppelinhubMessage.class);
    }

    public static ZeppelinhubMessage fromJson(String zeppelinhubMessage) {
        ZeppelinhubMessage msg;
        if (StringUtils.isBlank((String)zeppelinhubMessage)) {
            return EMPTY;
        }
        try {
            msg = (ZeppelinhubMessage)gson.fromJson(zeppelinhubMessage, ZeppelinhubMessage.class);
        }
        catch (JsonSyntaxException ex) {
            LOG.error("Cannot fromJson zeppelinhub message", (Throwable)ex);
            msg = EMPTY;
        }
        return msg;
    }
}

