/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SchedulerService {
    private final ScheduledExecutorService pool;
    private static SchedulerService instance = null;

    private SchedulerService(int numberOfThread) {
        this.pool = Executors.newScheduledThreadPool(numberOfThread);
    }

    public static SchedulerService create(int numberOfThread) {
        if (instance == null) {
            instance = new SchedulerService(numberOfThread);
        }
        return instance;
    }

    public static SchedulerService getInstance() {
        if (instance == null) {
            instance = new SchedulerService(2);
        }
        return instance;
    }

    public void add(Runnable service, int firstExecution, int period) {
        this.pool.scheduleAtFixedRate(service, firstExecution, period, TimeUnit.SECONDS);
    }

    public void addOnce(Runnable service, int firstExecution) {
        this.pool.schedule(service, (long)firstExecution, TimeUnit.SECONDS);
    }

    public void close() {
        this.pool.shutdown();
    }
}

