/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.session;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinhubSession {
    private static final Logger LOG = LoggerFactory.getLogger(ZeppelinhubSession.class);
    private Session session;
    private final String token;
    public static final ZeppelinhubSession EMPTY = new ZeppelinhubSession(null, "");

    public static ZeppelinhubSession createInstance(Session session, String token) {
        return new ZeppelinhubSession(session, token);
    }

    private ZeppelinhubSession(Session session, String token) {
        this.session = session;
        this.token = token;
    }

    public boolean isSessionOpen() {
        return this.session != null && this.session.isOpen();
    }

    public void close() {
        if (this.isSessionOpen()) {
            this.session.close();
        }
    }

    public void sendByFuture(String msg) {
        if (StringUtils.isBlank((String)msg)) {
            LOG.error("Cannot send event to Zeppelinhub, msg is empty");
        }
        if (this.isSessionOpen()) {
            this.session.getRemote().sendStringByFuture(msg);
        } else {
            LOG.error("Cannot send event to Zeppelinhub, session is close");
        }
    }
}

