/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteScheduler
implements Scheduler {
    Logger logger = LoggerFactory.getLogger(RemoteScheduler.class);
    List<Job> queue = new LinkedList<Job>();
    List<Job> running = new LinkedList<Job>();
    private ExecutorService executor;
    private SchedulerListener listener;
    boolean terminate = false;
    private String name;
    private int maxConcurrency;
    private final String sessionId;
    private RemoteInterpreter remoteInterpreter;

    public RemoteScheduler(String name, ExecutorService executor, String sessionId, RemoteInterpreter remoteInterpreter, SchedulerListener listener, int maxConcurrency) {
        this.name = name;
        this.executor = executor;
        this.listener = listener;
        this.sessionId = sessionId;
        this.remoteInterpreter = remoteInterpreter;
        this.maxConcurrency = maxConcurrency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.terminate) {
            Job job = null;
            List<Job> list = this.queue;
            synchronized (list) {
                if (this.running.size() >= this.maxConcurrency || this.queue.isEmpty()) {
                    try {
                        this.queue.wait(500L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Exception in RemoteScheduler while run queue.wait", (Throwable)e);
                    }
                    continue;
                }
                job = this.queue.remove(0);
                this.running.add(job);
            }
            RemoteScheduler scheduler = this;
            JobRunner jobRunner = new JobRunner(scheduler, job);
            this.executor.execute(jobRunner);
            while (!jobRunner.isJobSubmittedInRemote()) {
                List<Job> list2 = this.queue;
                synchronized (list2) {
                    try {
                        this.queue.wait(500L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Exception in RemoteScheduler while jobRunner.isJobSubmittedInRemote queue.wait", (Throwable)e);
                    }
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Job> getJobsWaiting() {
        LinkedList<Job> ret = new LinkedList<Job>();
        List<Job> list = this.queue;
        synchronized (list) {
            for (Job job : this.queue) {
                ret.add(job);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job removeFromWaitingQueue(String jobId) {
        List<Job> list = this.queue;
        synchronized (list) {
            Iterator<Job> it = this.queue.iterator();
            while (it.hasNext()) {
                Job job = it.next();
                if (!job.getId().equals(jobId)) continue;
                it.remove();
                return job;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Job> getJobsRunning() {
        LinkedList<Job> ret = new LinkedList<Job>();
        List<Job> list = this.queue;
        synchronized (list) {
            for (Job job : this.running) {
                if (job.getStatus() == Job.Status.RUNNING) {
                    ret.add(job);
                    continue;
                }
                this.logger.error("Tried to add {} to list of running jobs, but job status is {}", (Object)job.getJobName(), (Object)job.getStatus().toString());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Job job) {
        if (this.terminate) {
            throw new RuntimeException("Scheduler already terminated");
        }
        job.setStatus(Job.Status.PENDING);
        List<Job> list = this.queue;
        synchronized (list) {
            this.queue.add(job);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        List<Job> list = this.queue;
        synchronized (list) {
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.terminate = true;
        List<Job> list = this.queue;
        synchronized (list) {
            this.queue.notify();
        }
    }

    private class JobRunner
    implements Runnable,
    JobListener {
        private final Logger logger = LoggerFactory.getLogger(JobRunner.class);
        private Scheduler scheduler;
        private Job job;
        private volatile boolean jobExecuted;
        volatile boolean jobSubmittedRemotely;

        public JobRunner(Scheduler scheduler, Job job) {
            this.scheduler = scheduler;
            this.job = job;
            this.jobExecuted = false;
            this.jobSubmittedRemotely = false;
        }

        public boolean isJobSubmittedInRemote() {
            return this.jobSubmittedRemotely;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.job.isAborted()) {
                List<Job> list = RemoteScheduler.this.queue;
                synchronized (list) {
                    this.job.setStatus(Job.Status.ABORT);
                    this.job.aborted = false;
                    RemoteScheduler.this.running.remove(this.job);
                    RemoteScheduler.this.queue.notify();
                }
                this.jobSubmittedRemotely = true;
                return;
            }
            JobStatusPoller jobStatusPoller = new JobStatusPoller(1500L, 100L, 500L, this.job, this);
            jobStatusPoller.start();
            if (RemoteScheduler.this.listener != null) {
                RemoteScheduler.this.listener.jobStarted(this.scheduler, this.job);
            }
            this.job.run();
            this.jobExecuted = true;
            this.jobSubmittedRemotely = true;
            jobStatusPoller.shutdown();
            try {
                jobStatusPoller.join();
            }
            catch (InterruptedException e) {
                this.logger.error("JobStatusPoller interrupted", (Throwable)e);
            }
            Object jobResult = this.job.getReturn();
            if (this.job.isAborted()) {
                this.job.setStatus(Job.Status.ABORT);
            } else if (this.job.getException() != null) {
                this.logger.debug("Job ABORT, " + this.job.getId() + ", " + this.job.getErrorMessage());
                this.job.setStatus(Job.Status.ERROR);
            } else if (jobResult != null && jobResult instanceof InterpreterResult && ((InterpreterResult)jobResult).code() == InterpreterResult.Code.ERROR) {
                this.logger.debug("Job Error, " + this.job.getId() + ", " + this.job.getErrorMessage());
                this.job.setStatus(Job.Status.ERROR);
            } else {
                this.logger.debug("Job Finished, " + this.job.getId() + ", Result: " + this.job.getReturn());
                this.job.setStatus(Job.Status.FINISHED);
            }
            List<Job> list = RemoteScheduler.this.queue;
            synchronized (list) {
                if (RemoteScheduler.this.listener != null) {
                    RemoteScheduler.this.listener.jobFinished(this.scheduler, this.job);
                }
                this.job.aborted = false;
                RemoteScheduler.this.running.remove(this.job);
                RemoteScheduler.this.queue.notify();
            }
        }

        public void onProgressUpdate(Job job, int progress) {
        }

        public void beforeStatusChange(Job job, Job.Status before, Job.Status after) {
        }

        public void afterStatusChange(Job job, Job.Status before, Job.Status after) {
            if (!this.jobExecuted) {
                if (after == Job.Status.FINISHED || after == Job.Status.ABORT || after == Job.Status.ERROR) {
                    return;
                }
                if (after == Job.Status.RUNNING) {
                    this.jobSubmittedRemotely = true;
                    job.setStatus(Job.Status.RUNNING);
                }
            } else {
                this.jobSubmittedRemotely = true;
            }
            if (after == Job.Status.RUNNING) {
                job.setStatus(Job.Status.RUNNING);
            }
        }
    }

    private class JobStatusPoller
    extends Thread {
        private long initialPeriodMsec;
        private long initialPeriodCheckIntervalMsec;
        private long checkIntervalMsec;
        private volatile boolean terminate;
        private JobListener listener;
        private Job job;
        volatile Job.Status lastStatus;

        public JobStatusPoller(long initialPeriodMsec, long initialPeriodCheckIntervalMsec, long checkIntervalMsec, Job job, JobListener listener) {
            this.setName("JobStatusPoller-" + job.getId());
            this.initialPeriodMsec = initialPeriodMsec;
            this.initialPeriodCheckIntervalMsec = initialPeriodCheckIntervalMsec;
            this.checkIntervalMsec = checkIntervalMsec;
            this.job = job;
            this.listener = listener;
            this.terminate = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long started = System.currentTimeMillis();
            while (!this.terminate) {
                Job.Status newStatus;
                long current = System.currentTimeMillis();
                long interval = current - started < this.initialPeriodMsec ? this.initialPeriodCheckIntervalMsec : this.checkIntervalMsec;
                JobStatusPoller jobStatusPoller = this;
                synchronized (jobStatusPoller) {
                    try {
                        this.wait(interval);
                    }
                    catch (InterruptedException e) {
                        RemoteScheduler.this.logger.error("Exception in RemoteScheduler while run this.wait", (Throwable)e);
                    }
                }
                if (!this.terminate && ((newStatus = this.getStatus()) == Job.Status.UNKNOWN || newStatus == Job.Status.READY || newStatus == Job.Status.PENDING)) continue;
                break;
            }
            this.terminate = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.terminate = true;
            JobStatusPoller jobStatusPoller = this;
            synchronized (jobStatusPoller) {
                this.notify();
            }
        }

        private Job.Status getLastStatus() {
            if (this.terminate) {
                if (this.job.getErrorMessage() != null) {
                    return Job.Status.ERROR;
                }
                if (this.lastStatus != Job.Status.FINISHED && this.lastStatus != Job.Status.ERROR && this.lastStatus != Job.Status.ABORT) {
                    return Job.Status.FINISHED;
                }
                return this.lastStatus == null ? Job.Status.FINISHED : this.lastStatus;
            }
            return this.lastStatus == null ? Job.Status.UNKNOWN : this.lastStatus;
        }

        public synchronized Job.Status getStatus() {
            if (!RemoteScheduler.this.remoteInterpreter.isOpened()) {
                return this.getLastStatus();
            }
            Job.Status status = Job.Status.valueOf((String)RemoteScheduler.this.remoteInterpreter.getStatus(this.job.getId()));
            if (status == Job.Status.UNKNOWN) {
                this.listener.afterStatusChange(this.job, null, null);
                return this.job.getStatus();
            }
            this.lastStatus = status;
            this.listener.afterStatusChange(this.job, null, status);
            return status;
        }
    }
}

