/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.search;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.search.SearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSearch
implements SearchService {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneSearch.class);
    private static final String SEARCH_FIELD_TEXT = "contents";
    private static final String SEARCH_FIELD_TITLE = "header";
    static final String PARAGRAPH = "paragraph";
    static final String ID_FIELD = "id";
    Directory ramDirectory = new RAMDirectory();
    Analyzer analyzer = new StandardAnalyzer();
    IndexWriterConfig iwc = new IndexWriterConfig(this.analyzer);
    IndexWriter writer;

    public LuceneSearch() {
        try {
            this.writer = new IndexWriter(this.ramDirectory, this.iwc);
        }
        catch (IOException e) {
            LOG.error("Failed to create new IndexWriter", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, String>> query(String queryStr) {
        if (null == this.ramDirectory) {
            throw new IllegalStateException("Something went wrong on instance creation time, index dir is null");
        }
        List<Map<String, String>> result = Collections.emptyList();
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.ramDirectory);){
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{SEARCH_FIELD_TEXT, SEARCH_FIELD_TITLE}, (Analyzer)analyzer);
            Query query = parser.parse(queryStr);
            LOG.debug("Searching for: " + query.toString(SEARCH_FIELD_TEXT));
            SimpleHTMLFormatter htmlFormatter = new SimpleHTMLFormatter();
            Highlighter highlighter = new Highlighter((Formatter)htmlFormatter, (Scorer)new QueryScorer(query));
            result = this.doSearch(indexSearcher, query, (Analyzer)analyzer, highlighter);
            indexReader.close();
        }
        catch (IOException e) {
            LOG.error("Failed to open index dir {}, make sure indexing finished OK", (Object)this.ramDirectory, (Object)e);
        }
        catch (ParseException e) {
            LOG.error("Failed to parse query " + queryStr, (Throwable)e);
        }
        return result;
    }

    private List<Map<String, String>> doSearch(IndexSearcher searcher, Query query, Analyzer analyzer, Highlighter highlighter) {
        ArrayList matchingParagraphs = Lists.newArrayList();
        try {
            ScoreDoc[] hits = searcher.search((Query)query, (int)20).scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                LOG.debug("doc={} score={}", (Object)hits[i].doc, (Object)Float.valueOf(hits[i].score));
                int id = hits[i].doc;
                Document doc = searcher.doc(id);
                String path = doc.get(ID_FIELD);
                if (path != null) {
                    TokenStream tokenTitle;
                    TextFragment[] frgTitle;
                    LOG.debug(i + 1 + ". " + path);
                    String title = doc.get("title");
                    if (title != null) {
                        LOG.debug("   Title: {}", (Object)doc.get("title"));
                    }
                    String text = doc.get(SEARCH_FIELD_TEXT);
                    String header = doc.get(SEARCH_FIELD_TITLE);
                    String fragment = "";
                    if (text != null) {
                        TokenStream tokenStream = TokenSources.getTokenStream((IndexReader)searcher.getIndexReader(), (int)id, (String)SEARCH_FIELD_TEXT, (Analyzer)analyzer);
                        TextFragment[] frag = highlighter.getBestTextFragments(tokenStream, text, true, 3);
                        LOG.debug("    {} fragments found for query '{}'", (Object)frag.length, (Object)query);
                        for (int j = 0; j < frag.length; ++j) {
                            if (frag[j] == null || !(frag[j].getScore() > 0.0f)) continue;
                            LOG.debug("    Fragment: {}", (Object)frag[j].toString());
                        }
                        String string = fragment = frag != null && frag.length > 0 ? frag[0].toString() : "";
                    }
                    header = header != null ? ((frgTitle = highlighter.getBestTextFragments(tokenTitle = TokenSources.getTokenStream((IndexReader)searcher.getIndexReader(), (int)id, (String)SEARCH_FIELD_TITLE, (Analyzer)analyzer), header, true, 3)) != null && frgTitle.length > 0 ? frgTitle[0].toString() : "") : "";
                    matchingParagraphs.add(ImmutableMap.of((Object)ID_FIELD, (Object)path, (Object)"name", (Object)title, (Object)"snippet", (Object)fragment, (Object)"text", (Object)text, (Object)SEARCH_FIELD_TITLE, (Object)header));
                    continue;
                }
                LOG.info("{}. No {} for this document", (Object)(i + 1), (Object)ID_FIELD);
            }
        }
        catch (IOException | InvalidTokenOffsetsException e) {
            LOG.error("Exception on searching for {}", (Object)query, (Object)e);
        }
        return matchingParagraphs;
    }

    @Override
    public void updateIndexDoc(Note note) throws IOException {
        this.updateIndexNoteName(note);
        for (Paragraph p : note.getParagraphs()) {
            this.updateIndexParagraph(note, p);
        }
    }

    private void updateIndexNoteName(Note note) throws IOException {
        String noteName = note.getName();
        String noteId = note.getId();
        LOG.debug("Indexing Notebook {}, '{}'", (Object)noteId, (Object)noteName);
        if (null == noteName || noteName.isEmpty()) {
            LOG.debug("Skipping empty notebook name");
            return;
        }
        this.updateDoc(noteId, noteName, null);
    }

    private void updateIndexParagraph(Note note, Paragraph p) throws IOException {
        if (p.getText() == null) {
            LOG.debug("Skipping empty paragraph");
            return;
        }
        this.updateDoc(note.getId(), note.getName(), p);
    }

    private void updateDoc(String noteId, String noteName, Paragraph p) throws IOException {
        String id = LuceneSearch.formatId(noteId, p);
        Document doc = this.newDocument(id, noteName, p);
        try {
            this.writer.updateDocument(new Term(ID_FIELD, id), (Iterable)doc);
            this.writer.commit();
        }
        catch (IOException e) {
            LOG.error("Failed to updaet index of notebook {}", (Object)noteId, (Object)e);
        }
    }

    static String formatId(String noteId, Paragraph p) {
        String id = noteId;
        if (null != p) {
            id = Joiner.on((char)'/').join((Object)id, (Object)PARAGRAPH, new Object[]{p.getId()});
        }
        return id;
    }

    static String formatDeleteId(String noteId, Paragraph p) {
        String id = noteId;
        id = null != p ? Joiner.on((char)'/').join((Object)id, (Object)PARAGRAPH, new Object[]{p.getId()}) : id + "*";
        return id;
    }

    private Document newDocument(String id, String noteName, Paragraph p) {
        Document doc = new Document();
        StringField pathField = new StringField(ID_FIELD, id, Field.Store.YES);
        doc.add((IndexableField)pathField);
        doc.add((IndexableField)new StringField("title", noteName, Field.Store.YES));
        if (null != p) {
            doc.add((IndexableField)new TextField(SEARCH_FIELD_TEXT, p.getText(), Field.Store.YES));
            if (p.getTitle() != null) {
                doc.add((IndexableField)new TextField(SEARCH_FIELD_TITLE, p.getTitle(), Field.Store.YES));
            }
            Date date = p.getDateStarted() != null ? p.getDateStarted() : p.getDateCreated();
            doc.add((IndexableField)new LongField("modified", date.getTime(), Field.Store.NO));
        } else {
            doc.add((IndexableField)new TextField(SEARCH_FIELD_TEXT, noteName, Field.Store.YES));
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexDocs(Collection<Note> collection) {
        int docsIndexed = 0;
        long start = System.nanoTime();
        try {
            for (Note note : collection) {
                this.addIndexDocAsync(note);
                ++docsIndexed;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to index all Notebooks", (Throwable)e);
        }
        finally {
            try {
                this.writer.commit();
            }
            catch (IOException e) {
                LOG.error("Failed to save index", (Throwable)e);
            }
            long end = System.nanoTime();
            LOG.info("Indexing {} notebooks took {}ms", (Object)docsIndexed, (Object)TimeUnit.NANOSECONDS.toMillis(end - start));
        }
    }

    @Override
    public void addIndexDoc(Note note) {
        try {
            this.addIndexDocAsync(note);
            this.writer.commit();
        }
        catch (IOException e) {
            LOG.error("Failed to add note {} to index", (Object)note, (Object)e);
        }
    }

    private void addIndexDocAsync(Note note) throws IOException {
        this.indexNoteName(this.writer, note.getId(), note.getName());
        for (Paragraph doc : note.getParagraphs()) {
            if (doc.getText() == null) {
                LOG.debug("Skipping empty paragraph");
                continue;
            }
            this.indexDoc(this.writer, note.getId(), note.getName(), doc);
        }
    }

    @Override
    public void deleteIndexDocs(Note note) {
        this.deleteDoc(note, null);
    }

    @Override
    public void deleteIndexDoc(Note note, Paragraph p) {
        this.deleteDoc(note, p);
    }

    private void deleteDoc(Note note, Paragraph p) {
        if (null == note) {
            LOG.error("Trying to delete note by reference to NULL");
            return;
        }
        String fullNoteOrJustParagraph = LuceneSearch.formatDeleteId(note.getId(), p);
        LOG.debug("Deleting note {}, out of: {}", (Object)note.getId(), (Object)this.writer.numDocs());
        try {
            this.writer.deleteDocuments(new Query[]{new WildcardQuery(new Term(ID_FIELD, fullNoteOrJustParagraph))});
            this.writer.commit();
        }
        catch (IOException e) {
            LOG.error("Failed to delete {} from index by '{}'", new Object[]{note, fullNoteOrJustParagraph, e});
        }
        LOG.debug("Done, index contains {} docs now" + this.writer.numDocs());
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            LOG.error("Failed to .close() the notebook index", (Throwable)e);
        }
    }

    private void indexNoteName(IndexWriter w, String noteId, String noteName) throws IOException {
        LOG.debug("Indexing Notebook {}, '{}'", (Object)noteId, (Object)noteName);
        if (null == noteName || noteName.isEmpty()) {
            LOG.debug("Skipping empty notebook name");
            return;
        }
        this.indexDoc(w, noteId, noteName, null);
    }

    private void indexDoc(IndexWriter w, String noteId, String noteName, Paragraph p) throws IOException {
        String id = LuceneSearch.formatId(noteId, p);
        Document doc = this.newDocument(id, noteName, p);
        w.addDocument((Iterable)doc);
    }
}

