/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterInfoSaving;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.notebook.NotebookAuthorizationInfoSaving;
import org.apache.zeppelin.util.ReflectionUtils;

public abstract class ConfigStorage {
    private static ConfigStorage instance;
    protected ZeppelinConfiguration zConf;

    public static synchronized ConfigStorage getInstance(ZeppelinConfiguration zConf) throws IOException {
        if (instance == null) {
            instance = ConfigStorage.createConfigStorage(zConf);
        }
        return instance;
    }

    private static ConfigStorage createConfigStorage(ZeppelinConfiguration zConf) throws IOException {
        String configStorageClass = zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_CONFIG_STORAGE_CLASS);
        return (ConfigStorage)ReflectionUtils.createClazzInstance(configStorageClass, new Class[]{ZeppelinConfiguration.class}, new Object[]{zConf});
    }

    public ConfigStorage(ZeppelinConfiguration zConf) {
        this.zConf = zConf;
    }

    public abstract void save(InterpreterInfoSaving var1) throws IOException;

    public abstract InterpreterInfoSaving loadInterpreterSettings() throws IOException;

    public abstract void save(NotebookAuthorizationInfoSaving var1) throws IOException;

    public abstract NotebookAuthorizationInfoSaving loadNotebookAuthorization() throws IOException;

    public abstract String loadCredentials() throws IOException;

    public abstract void saveCredentials(String var1) throws IOException;

    protected InterpreterInfoSaving buildInterpreterInfoSaving(String json) {
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(json).getAsJsonObject();
        InterpreterInfoSaving infoSaving = InterpreterInfoSaving.fromJson(json);
        for (InterpreterSetting interpreterSetting : infoSaving.interpreterSettings.values()) {
            interpreterSetting.getOption();
            interpreterSetting.convertPermissionsFromUsersToOwners(jsonObject.getAsJsonObject("interpreterSettings").getAsJsonObject(interpreterSetting.getId()));
        }
        return infoSaving;
    }

    @VisibleForTesting
    public static void reset() {
        instance = null;
    }
}

