/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.storage;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterInfoSaving;
import org.apache.zeppelin.notebook.FileSystemStorage;
import org.apache.zeppelin.notebook.NotebookAuthorizationInfoSaving;
import org.apache.zeppelin.storage.ConfigStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemConfigStorage
extends ConfigStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemConfigStorage.class);
    private FileSystemStorage fs;
    private Path interpreterSettingPath;
    private Path authorizationPath;
    private Path credentialPath;

    public FileSystemConfigStorage(ZeppelinConfiguration zConf) throws IOException {
        super(zConf);
        this.fs = new FileSystemStorage(zConf, zConf.getConfigFSDir());
        LOGGER.info("Creating FileSystem: " + this.fs.getFs().getClass().getName() + " for Zeppelin Config");
        Path configPath = this.fs.makeQualified(new Path(zConf.getConfigFSDir()));
        this.fs.tryMkDir(configPath);
        LOGGER.info("Using folder {} to store Zeppelin Config", (Object)configPath);
        this.interpreterSettingPath = this.fs.makeQualified(new Path(zConf.getInterpreterSettingPath()));
        this.authorizationPath = this.fs.makeQualified(new Path(zConf.getNotebookAuthorizationPath()));
        this.credentialPath = this.fs.makeQualified(new Path(zConf.getCredentialsPath()));
    }

    @Override
    public void save(InterpreterInfoSaving settingInfos) throws IOException {
        LOGGER.info("Save Interpreter Settings to " + this.interpreterSettingPath);
        this.fs.writeFile(settingInfos.toJson(), this.interpreterSettingPath, false);
    }

    @Override
    public InterpreterInfoSaving loadInterpreterSettings() throws IOException {
        if (!this.fs.exists(this.interpreterSettingPath)) {
            LOGGER.warn("Interpreter Setting file {} is not existed", (Object)this.interpreterSettingPath);
            return null;
        }
        LOGGER.info("Load Interpreter Setting from file: " + this.interpreterSettingPath);
        String json = this.fs.readFile(this.interpreterSettingPath);
        return this.buildInterpreterInfoSaving(json);
    }

    @Override
    public void save(NotebookAuthorizationInfoSaving authorizationInfoSaving) throws IOException {
        LOGGER.info("Save notebook authorization to file: " + this.authorizationPath);
        this.fs.writeFile(authorizationInfoSaving.toJson(), this.authorizationPath, false);
    }

    @Override
    public NotebookAuthorizationInfoSaving loadNotebookAuthorization() throws IOException {
        if (!this.fs.exists(this.authorizationPath)) {
            LOGGER.warn("Notebook Authorization file {} is not existed", (Object)this.authorizationPath);
            return null;
        }
        LOGGER.info("Load notebook authorization from file: " + this.authorizationPath);
        String json = this.fs.readFile(this.authorizationPath);
        return NotebookAuthorizationInfoSaving.fromJson(json);
    }

    @Override
    public String loadCredentials() throws IOException {
        if (!this.fs.exists(this.credentialPath)) {
            LOGGER.warn("Credential file {} is not existed", (Object)this.credentialPath);
            return null;
        }
        LOGGER.info("Load Credential from file: " + this.credentialPath);
        return this.fs.readFile(this.credentialPath);
    }

    @Override
    public void saveCredentials(String credentials) throws IOException {
        LOGGER.info("Save Credentials to file: " + this.credentialPath);
        this.fs.writeFile(credentials, this.credentialPath, false);
    }
}

